/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.LogConfiguration;
import software.amazon.awssdk.services.ecs.model.ServiceConnectService;
import software.amazon.awssdk.services.ecs.model.ServiceConnectServiceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceConnectConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceConnectConfiguration> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(ServiceConnectConfiguration.getter(ServiceConnectConfiguration::enabled)).setter(ServiceConnectConfiguration.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(ServiceConnectConfiguration.getter(ServiceConnectConfiguration::namespace)).setter(ServiceConnectConfiguration.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<List<ServiceConnectService>> SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("services").getter(ServiceConnectConfiguration.getter(ServiceConnectConfiguration::services)).setter(ServiceConnectConfiguration.setter(Builder::services)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("services").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceConnectService::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LogConfiguration> LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logConfiguration").getter(ServiceConnectConfiguration.getter(ServiceConnectConfiguration::logConfiguration)).setter(ServiceConnectConfiguration.setter(Builder::logConfiguration)).constructor(LogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, NAMESPACE_FIELD, SERVICES_FIELD, LOG_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceConnectConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final String namespace;
    private final List<ServiceConnectService> services;
    private final LogConfiguration logConfiguration;

    private ServiceConnectConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.namespace = builder.namespace;
        this.services = builder.services;
        this.logConfiguration = builder.logConfiguration;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final boolean hasServices() {
        return this.services != null && !(this.services instanceof SdkAutoConstructList);
    }

    public final List<ServiceConnectService> services() {
        return this.services;
    }

    public final LogConfiguration logConfiguration() {
        return this.logConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServices() ? this.services() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceConnectConfiguration)) {
            return false;
        }
        ServiceConnectConfiguration other = (ServiceConnectConfiguration)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.namespace(), other.namespace()) && this.hasServices() == other.hasServices() && Objects.equals(this.services(), other.services()) && Objects.equals(this.logConfiguration(), other.logConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceConnectConfiguration").add("Enabled", (Object)this.enabled()).add("Namespace", (Object)this.namespace()).add("Services", this.hasServices() ? this.services() : null).add("LogConfiguration", (Object)this.logConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "services": {
                return Optional.ofNullable(clazz.cast(this.services()));
            }
            case "logConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("enabled", ENABLED_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("services", SERVICES_FIELD);
        map.put("logConfiguration", LOG_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceConnectConfiguration, T> g) {
        return obj -> g.apply((ServiceConnectConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String namespace;
        private List<ServiceConnectService> services = DefaultSdkAutoConstructList.getInstance();
        private LogConfiguration logConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceConnectConfiguration model) {
            this.enabled(model.enabled);
            this.namespace(model.namespace);
            this.services(model.services);
            this.logConfiguration(model.logConfiguration);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final List<ServiceConnectService.Builder> getServices() {
            List<ServiceConnectService.Builder> result = ServiceConnectServiceListCopier.copyToBuilder(this.services);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServices(Collection<ServiceConnectService.BuilderImpl> services) {
            this.services = ServiceConnectServiceListCopier.copyFromBuilder(services);
        }

        @Override
        public final Builder services(Collection<ServiceConnectService> services) {
            this.services = ServiceConnectServiceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(ServiceConnectService ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Consumer<ServiceConnectService.Builder> ... services) {
            this.services(Stream.of(services).map(c -> (ServiceConnectService)((ServiceConnectService.Builder)ServiceConnectService.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final LogConfiguration.Builder getLogConfiguration() {
            return this.logConfiguration != null ? this.logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(LogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(LogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public ServiceConnectConfiguration build() {
            return new ServiceConnectConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceConnectConfiguration> {
        public Builder enabled(Boolean var1);

        public Builder namespace(String var1);

        public Builder services(Collection<ServiceConnectService> var1);

        public Builder services(ServiceConnectService ... var1);

        public Builder services(Consumer<ServiceConnectService.Builder> ... var1);

        public Builder logConfiguration(LogConfiguration var1);

        default public Builder logConfiguration(Consumer<LogConfiguration.Builder> logConfiguration) {
            return this.logConfiguration((LogConfiguration)((LogConfiguration.Builder)LogConfiguration.builder().applyMutation(logConfiguration)).build());
        }
    }
}

