/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.IntegerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerRestartPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerRestartPolicy> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(ContainerRestartPolicy.getter(ContainerRestartPolicy::enabled)).setter(ContainerRestartPolicy.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<List<Integer>> IGNORED_EXIT_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ignoredExitCodes").getter(ContainerRestartPolicy.getter(ContainerRestartPolicy::ignoredExitCodes)).setter(ContainerRestartPolicy.setter(Builder::ignoredExitCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignoredExitCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> RESTART_ATTEMPT_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("restartAttemptPeriod").getter(ContainerRestartPolicy.getter(ContainerRestartPolicy::restartAttemptPeriod)).setter(ContainerRestartPolicy.setter(Builder::restartAttemptPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restartAttemptPeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, IGNORED_EXIT_CODES_FIELD, RESTART_ATTEMPT_PERIOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContainerRestartPolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final List<Integer> ignoredExitCodes;
    private final Integer restartAttemptPeriod;

    private ContainerRestartPolicy(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.ignoredExitCodes = builder.ignoredExitCodes;
        this.restartAttemptPeriod = builder.restartAttemptPeriod;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final boolean hasIgnoredExitCodes() {
        return this.ignoredExitCodes != null && !(this.ignoredExitCodes instanceof SdkAutoConstructList);
    }

    public final List<Integer> ignoredExitCodes() {
        return this.ignoredExitCodes;
    }

    public final Integer restartAttemptPeriod() {
        return this.restartAttemptPeriod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIgnoredExitCodes() ? this.ignoredExitCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.restartAttemptPeriod());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerRestartPolicy)) {
            return false;
        }
        ContainerRestartPolicy other = (ContainerRestartPolicy)obj;
        return Objects.equals(this.enabled(), other.enabled()) && this.hasIgnoredExitCodes() == other.hasIgnoredExitCodes() && Objects.equals(this.ignoredExitCodes(), other.ignoredExitCodes()) && Objects.equals(this.restartAttemptPeriod(), other.restartAttemptPeriod());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerRestartPolicy").add("Enabled", (Object)this.enabled()).add("IgnoredExitCodes", this.hasIgnoredExitCodes() ? this.ignoredExitCodes() : null).add("RestartAttemptPeriod", (Object)this.restartAttemptPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "ignoredExitCodes": {
                return Optional.ofNullable(clazz.cast(this.ignoredExitCodes()));
            }
            case "restartAttemptPeriod": {
                return Optional.ofNullable(clazz.cast(this.restartAttemptPeriod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("enabled", ENABLED_FIELD);
        map.put("ignoredExitCodes", IGNORED_EXIT_CODES_FIELD);
        map.put("restartAttemptPeriod", RESTART_ATTEMPT_PERIOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContainerRestartPolicy, T> g) {
        return obj -> g.apply((ContainerRestartPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private List<Integer> ignoredExitCodes = DefaultSdkAutoConstructList.getInstance();
        private Integer restartAttemptPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerRestartPolicy model) {
            this.enabled(model.enabled);
            this.ignoredExitCodes(model.ignoredExitCodes);
            this.restartAttemptPeriod(model.restartAttemptPeriod);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Collection<Integer> getIgnoredExitCodes() {
            if (this.ignoredExitCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ignoredExitCodes;
        }

        public final void setIgnoredExitCodes(Collection<Integer> ignoredExitCodes) {
            this.ignoredExitCodes = IntegerListCopier.copy(ignoredExitCodes);
        }

        @Override
        public final Builder ignoredExitCodes(Collection<Integer> ignoredExitCodes) {
            this.ignoredExitCodes = IntegerListCopier.copy(ignoredExitCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ignoredExitCodes(Integer ... ignoredExitCodes) {
            this.ignoredExitCodes(Arrays.asList(ignoredExitCodes));
            return this;
        }

        public final Integer getRestartAttemptPeriod() {
            return this.restartAttemptPeriod;
        }

        public final void setRestartAttemptPeriod(Integer restartAttemptPeriod) {
            this.restartAttemptPeriod = restartAttemptPeriod;
        }

        @Override
        public final Builder restartAttemptPeriod(Integer restartAttemptPeriod) {
            this.restartAttemptPeriod = restartAttemptPeriod;
            return this;
        }

        public ContainerRestartPolicy build() {
            return new ContainerRestartPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerRestartPolicy> {
        public Builder enabled(Boolean var1);

        public Builder ignoredExitCodes(Collection<Integer> var1);

        public Builder ignoredExitCodes(Integer ... var1);

        public Builder restartAttemptPeriod(Integer var1);
    }
}

