/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstanceHealthCheckState {
    OK("OK"),
    IMPAIRED("IMPAIRED"),
    INSUFFICIENT_DATA("INSUFFICIENT_DATA"),
    INITIALIZING("INITIALIZING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstanceHealthCheckState> VALUE_MAP;
    private final String value;

    private InstanceHealthCheckState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceHealthCheckState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceHealthCheckState> knownValues() {
        EnumSet<InstanceHealthCheckState> knownValues = EnumSet.allOf(InstanceHealthCheckState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstanceHealthCheckState.class, InstanceHealthCheckState::toString);
    }
}

