/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.ServiceDeploymentRollbackMonitorsStatus;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceDeploymentAlarms
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceDeploymentAlarms> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ServiceDeploymentAlarms.getter(ServiceDeploymentAlarms::statusAsString)).setter(ServiceDeploymentAlarms.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<String>> ALARM_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("alarmNames").getter(ServiceDeploymentAlarms.getter(ServiceDeploymentAlarms::alarmNames)).setter(ServiceDeploymentAlarms.setter(Builder::alarmNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TRIGGERED_ALARM_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("triggeredAlarmNames").getter(ServiceDeploymentAlarms.getter(ServiceDeploymentAlarms::triggeredAlarmNames)).setter(ServiceDeploymentAlarms.setter(Builder::triggeredAlarmNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggeredAlarmNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ALARM_NAMES_FIELD, TRIGGERED_ALARM_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("status", STATUS_FIELD);
            this.put("alarmNames", ALARM_NAMES_FIELD);
            this.put("triggeredAlarmNames", TRIGGERED_ALARM_NAMES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String status;
    private final List<String> alarmNames;
    private final List<String> triggeredAlarmNames;

    private ServiceDeploymentAlarms(BuilderImpl builder) {
        this.status = builder.status;
        this.alarmNames = builder.alarmNames;
        this.triggeredAlarmNames = builder.triggeredAlarmNames;
    }

    public final ServiceDeploymentRollbackMonitorsStatus status() {
        return ServiceDeploymentRollbackMonitorsStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasAlarmNames() {
        return this.alarmNames != null && !(this.alarmNames instanceof SdkAutoConstructList);
    }

    public final List<String> alarmNames() {
        return this.alarmNames;
    }

    public final boolean hasTriggeredAlarmNames() {
        return this.triggeredAlarmNames != null && !(this.triggeredAlarmNames instanceof SdkAutoConstructList);
    }

    public final List<String> triggeredAlarmNames() {
        return this.triggeredAlarmNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlarmNames() ? this.alarmNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTriggeredAlarmNames() ? this.triggeredAlarmNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceDeploymentAlarms)) {
            return false;
        }
        ServiceDeploymentAlarms other = (ServiceDeploymentAlarms)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasAlarmNames() == other.hasAlarmNames() && Objects.equals(this.alarmNames(), other.alarmNames()) && this.hasTriggeredAlarmNames() == other.hasTriggeredAlarmNames() && Objects.equals(this.triggeredAlarmNames(), other.triggeredAlarmNames());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceDeploymentAlarms").add("Status", (Object)this.statusAsString()).add("AlarmNames", this.hasAlarmNames() ? this.alarmNames() : null).add("TriggeredAlarmNames", this.hasTriggeredAlarmNames() ? this.triggeredAlarmNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "alarmNames": {
                return Optional.ofNullable(clazz.cast(this.alarmNames()));
            }
            case "triggeredAlarmNames": {
                return Optional.ofNullable(clazz.cast(this.triggeredAlarmNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ServiceDeploymentAlarms, T> g) {
        return obj -> g.apply((ServiceDeploymentAlarms)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private List<String> alarmNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> triggeredAlarmNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceDeploymentAlarms model) {
            this.status(model.status);
            this.alarmNames(model.alarmNames);
            this.triggeredAlarmNames(model.triggeredAlarmNames);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceDeploymentRollbackMonitorsStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getAlarmNames() {
            if (this.alarmNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.alarmNames;
        }

        public final void setAlarmNames(Collection<String> alarmNames) {
            this.alarmNames = StringListCopier.copy(alarmNames);
        }

        @Override
        public final Builder alarmNames(Collection<String> alarmNames) {
            this.alarmNames = StringListCopier.copy(alarmNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmNames(String ... alarmNames) {
            this.alarmNames(Arrays.asList(alarmNames));
            return this;
        }

        public final Collection<String> getTriggeredAlarmNames() {
            if (this.triggeredAlarmNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.triggeredAlarmNames;
        }

        public final void setTriggeredAlarmNames(Collection<String> triggeredAlarmNames) {
            this.triggeredAlarmNames = StringListCopier.copy(triggeredAlarmNames);
        }

        @Override
        public final Builder triggeredAlarmNames(Collection<String> triggeredAlarmNames) {
            this.triggeredAlarmNames = StringListCopier.copy(triggeredAlarmNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggeredAlarmNames(String ... triggeredAlarmNames) {
            this.triggeredAlarmNames(Arrays.asList(triggeredAlarmNames));
            return this;
        }

        public ServiceDeploymentAlarms build() {
            return new ServiceDeploymentAlarms(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceDeploymentAlarms> {
        public Builder status(String var1);

        public Builder status(ServiceDeploymentRollbackMonitorsStatus var1);

        public Builder alarmNames(Collection<String> var1);

        public Builder alarmNames(String ... var1);

        public Builder triggeredAlarmNames(Collection<String> var1);

        public Builder triggeredAlarmNames(String ... var1);
    }
}

