/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.ClusterConfiguration;
import software.amazon.awssdk.services.ecs.model.ClusterServiceConnectDefaultsRequest;
import software.amazon.awssdk.services.ecs.model.ClusterSetting;
import software.amazon.awssdk.services.ecs.model.ClusterSettingsCopier;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateClusterRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, UpdateClusterRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cluster").getter(UpdateClusterRequest.getter(UpdateClusterRequest::cluster)).setter(UpdateClusterRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<List<ClusterSetting>> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("settings").getter(UpdateClusterRequest.getter(UpdateClusterRequest::settings)).setter(UpdateClusterRequest.setter(Builder::settings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ClusterConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(UpdateClusterRequest.getter(UpdateClusterRequest::configuration)).setter(UpdateClusterRequest.setter(Builder::configuration)).constructor(ClusterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<ClusterServiceConnectDefaultsRequest> SERVICE_CONNECT_DEFAULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceConnectDefaults").getter(UpdateClusterRequest.getter(UpdateClusterRequest::serviceConnectDefaults)).setter(UpdateClusterRequest.setter(Builder::serviceConnectDefaults)).constructor(ClusterServiceConnectDefaultsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceConnectDefaults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, SETTINGS_FIELD, CONFIGURATION_FIELD, SERVICE_CONNECT_DEFAULTS_FIELD));
    private final String cluster;
    private final List<ClusterSetting> settings;
    private final ClusterConfiguration configuration;
    private final ClusterServiceConnectDefaultsRequest serviceConnectDefaults;

    private UpdateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.settings = builder.settings;
        this.configuration = builder.configuration;
        this.serviceConnectDefaults = builder.serviceConnectDefaults;
    }

    public final String cluster() {
        return this.cluster;
    }

    public final boolean hasSettings() {
        return this.settings != null && !(this.settings instanceof SdkAutoConstructList);
    }

    public final List<ClusterSetting> settings() {
        return this.settings;
    }

    public final ClusterConfiguration configuration() {
        return this.configuration;
    }

    public final ClusterServiceConnectDefaultsRequest serviceConnectDefaults() {
        return this.serviceConnectDefaults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSettings() ? this.settings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceConnectDefaults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterRequest)) {
            return false;
        }
        UpdateClusterRequest other = (UpdateClusterRequest)((Object)obj);
        return Objects.equals(this.cluster(), other.cluster()) && this.hasSettings() == other.hasSettings() && Objects.equals(this.settings(), other.settings()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.serviceConnectDefaults(), other.serviceConnectDefaults());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateClusterRequest").add("Cluster", (Object)this.cluster()).add("Settings", this.hasSettings() ? this.settings() : null).add("Configuration", (Object)this.configuration()).add("ServiceConnectDefaults", (Object)this.serviceConnectDefaults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "serviceConnectDefaults": {
                return Optional.ofNullable(clazz.cast(this.serviceConnectDefaults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterRequest, T> g) {
        return obj -> g.apply((UpdateClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String cluster;
        private List<ClusterSetting> settings = DefaultSdkAutoConstructList.getInstance();
        private ClusterConfiguration configuration;
        private ClusterServiceConnectDefaultsRequest serviceConnectDefaults;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterRequest model) {
            super(model);
            this.cluster(model.cluster);
            this.settings(model.settings);
            this.configuration(model.configuration);
            this.serviceConnectDefaults(model.serviceConnectDefaults);
        }

        public final String getCluster() {
            return this.cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final List<ClusterSetting.Builder> getSettings() {
            List<ClusterSetting.Builder> result = ClusterSettingsCopier.copyToBuilder(this.settings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSettings(Collection<ClusterSetting.BuilderImpl> settings) {
            this.settings = ClusterSettingsCopier.copyFromBuilder(settings);
        }

        @Override
        @Transient
        public final Builder settings(Collection<ClusterSetting> settings) {
            this.settings = ClusterSettingsCopier.copy(settings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder settings(ClusterSetting ... settings) {
            this.settings(Arrays.asList(settings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder settings(Consumer<ClusterSetting.Builder> ... settings) {
            this.settings(Stream.of(settings).map(c -> (ClusterSetting)((ClusterSetting.Builder)ClusterSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ClusterConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(ClusterConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ClusterConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final ClusterServiceConnectDefaultsRequest.Builder getServiceConnectDefaults() {
            return this.serviceConnectDefaults != null ? this.serviceConnectDefaults.toBuilder() : null;
        }

        public final void setServiceConnectDefaults(ClusterServiceConnectDefaultsRequest.BuilderImpl serviceConnectDefaults) {
            this.serviceConnectDefaults = serviceConnectDefaults != null ? serviceConnectDefaults.build() : null;
        }

        @Override
        public final Builder serviceConnectDefaults(ClusterServiceConnectDefaultsRequest serviceConnectDefaults) {
            this.serviceConnectDefaults = serviceConnectDefaults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClusterRequest build() {
            return new UpdateClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateClusterRequest> {
        public Builder cluster(String var1);

        public Builder settings(Collection<ClusterSetting> var1);

        public Builder settings(ClusterSetting ... var1);

        public Builder settings(Consumer<ClusterSetting.Builder> ... var1);

        public Builder configuration(ClusterConfiguration var1);

        default public Builder configuration(Consumer<ClusterConfiguration.Builder> configuration) {
            return this.configuration((ClusterConfiguration)((ClusterConfiguration.Builder)ClusterConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder serviceConnectDefaults(ClusterServiceConnectDefaultsRequest var1);

        default public Builder serviceConnectDefaults(Consumer<ClusterServiceConnectDefaultsRequest.Builder> serviceConnectDefaults) {
            return this.serviceConnectDefaults((ClusterServiceConnectDefaultsRequest)((ClusterServiceConnectDefaultsRequest.Builder)ClusterServiceConnectDefaultsRequest.builder().applyMutation(serviceConnectDefaults)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

