/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the managed agent status for the container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedAgent implements SdkPojo, Serializable, ToCopyableBuilder<ManagedAgent.Builder, ManagedAgent> {
    private static final SdkField<Instant> LAST_STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastStartedAt").getter(getter(ManagedAgent::lastStartedAt)).setter(setter(Builder::lastStartedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStartedAt").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ManagedAgent::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(ManagedAgent::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final SdkField<String> LAST_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastStatus").getter(getter(ManagedAgent::lastStatus)).setter(setter(Builder::lastStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_STARTED_AT_FIELD,
            NAME_FIELD, REASON_FIELD, LAST_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant lastStartedAt;

    private final String name;

    private final String reason;

    private final String lastStatus;

    private ManagedAgent(BuilderImpl builder) {
        this.lastStartedAt = builder.lastStartedAt;
        this.name = builder.name;
        this.reason = builder.reason;
        this.lastStatus = builder.lastStatus;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the managed agent was last started.
     * </p>
     * 
     * @return The Unix timestamp for the time when the managed agent was last started.
     */
    public final Instant lastStartedAt() {
        return lastStartedAt;
    }

    /**
     * <p>
     * The name of the managed agent. When the execute command feature is turned on, the managed agent name is
     * <code>ExecuteCommandAgent</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ManagedAgentName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the managed agent. When the execute command feature is turned on, the managed agent name is
     *         <code>ExecuteCommandAgent</code>.
     * @see ManagedAgentName
     */
    public final ManagedAgentName name() {
        return ManagedAgentName.fromValue(name);
    }

    /**
     * <p>
     * The name of the managed agent. When the execute command feature is turned on, the managed agent name is
     * <code>ExecuteCommandAgent</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ManagedAgentName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the managed agent. When the execute command feature is turned on, the managed agent name is
     *         <code>ExecuteCommandAgent</code>.
     * @see ManagedAgentName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The reason for why the managed agent is in the state it is in.
     * </p>
     * 
     * @return The reason for why the managed agent is in the state it is in.
     */
    public final String reason() {
        return reason;
    }

    /**
     * <p>
     * The last known status of the managed agent.
     * </p>
     * 
     * @return The last known status of the managed agent.
     */
    public final String lastStatus() {
        return lastStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastStartedAt());
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(lastStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedAgent)) {
            return false;
        }
        ManagedAgent other = (ManagedAgent) obj;
        return Objects.equals(lastStartedAt(), other.lastStartedAt()) && Objects.equals(nameAsString(), other.nameAsString())
                && Objects.equals(reason(), other.reason()) && Objects.equals(lastStatus(), other.lastStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedAgent").add("LastStartedAt", lastStartedAt()).add("Name", nameAsString())
                .add("Reason", reason()).add("LastStatus", lastStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lastStartedAt":
            return Optional.ofNullable(clazz.cast(lastStartedAt()));
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "lastStatus":
            return Optional.ofNullable(clazz.cast(lastStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManagedAgent, T> g) {
        return obj -> g.apply((ManagedAgent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedAgent> {
        /**
         * <p>
         * The Unix timestamp for the time when the managed agent was last started.
         * </p>
         * 
         * @param lastStartedAt
         *        The Unix timestamp for the time when the managed agent was last started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStartedAt(Instant lastStartedAt);

        /**
         * <p>
         * The name of the managed agent. When the execute command feature is turned on, the managed agent name is
         * <code>ExecuteCommandAgent</code>.
         * </p>
         * 
         * @param name
         *        The name of the managed agent. When the execute command feature is turned on, the managed agent name
         *        is <code>ExecuteCommandAgent</code>.
         * @see ManagedAgentName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedAgentName
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the managed agent. When the execute command feature is turned on, the managed agent name is
         * <code>ExecuteCommandAgent</code>.
         * </p>
         * 
         * @param name
         *        The name of the managed agent. When the execute command feature is turned on, the managed agent name
         *        is <code>ExecuteCommandAgent</code>.
         * @see ManagedAgentName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedAgentName
         */
        Builder name(ManagedAgentName name);

        /**
         * <p>
         * The reason for why the managed agent is in the state it is in.
         * </p>
         * 
         * @param reason
         *        The reason for why the managed agent is in the state it is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * The last known status of the managed agent.
         * </p>
         * 
         * @param lastStatus
         *        The last known status of the managed agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStatus(String lastStatus);
    }

    static final class BuilderImpl implements Builder {
        private Instant lastStartedAt;

        private String name;

        private String reason;

        private String lastStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedAgent model) {
            lastStartedAt(model.lastStartedAt);
            name(model.name);
            reason(model.reason);
            lastStatus(model.lastStatus);
        }

        public final Instant getLastStartedAt() {
            return lastStartedAt;
        }

        public final void setLastStartedAt(Instant lastStartedAt) {
            this.lastStartedAt = lastStartedAt;
        }

        @Override
        public final Builder lastStartedAt(Instant lastStartedAt) {
            this.lastStartedAt = lastStartedAt;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(ManagedAgentName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final String getLastStatus() {
            return lastStatus;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        public ManagedAgent build() {
            return new ManagedAgent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
