/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecs.EcsAsyncClient;
import software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceRequest;
import software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceResponse;

public class ListServicesByNamespacePublisher
implements SdkPublisher<ListServicesByNamespaceResponse> {
    private final EcsAsyncClient client;
    private final ListServicesByNamespaceRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServicesByNamespacePublisher(EcsAsyncClient client, ListServicesByNamespaceRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServicesByNamespacePublisher(EcsAsyncClient client, ListServicesByNamespaceRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServicesByNamespaceResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServicesByNamespaceResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> serviceArns() {
        Function<ListServicesByNamespaceResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceArns() != null) {
                return response.serviceArns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServicesByNamespaceResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServicesByNamespaceResponseFetcher
    implements AsyncPageFetcher<ListServicesByNamespaceResponse> {
        private ListServicesByNamespaceResponseFetcher() {
        }

        public boolean hasNextPage(ListServicesByNamespaceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServicesByNamespaceResponse> nextPage(ListServicesByNamespaceResponse previousPage) {
            if (previousPage == null) {
                return ListServicesByNamespacePublisher.this.client.listServicesByNamespace(ListServicesByNamespacePublisher.this.firstRequest);
            }
            return ListServicesByNamespacePublisher.this.client.listServicesByNamespace((ListServicesByNamespaceRequest)((Object)ListServicesByNamespacePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

