/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCapacityProviderRequest extends EcsRequest implements
        ToCopyableBuilder<UpdateCapacityProviderRequest.Builder, UpdateCapacityProviderRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateCapacityProviderRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<AutoScalingGroupProviderUpdate> AUTO_SCALING_GROUP_PROVIDER_FIELD = SdkField
            .<AutoScalingGroupProviderUpdate> builder(MarshallingType.SDK_POJO).memberName("autoScalingGroupProvider")
            .getter(getter(UpdateCapacityProviderRequest::autoScalingGroupProvider))
            .setter(setter(Builder::autoScalingGroupProvider)).constructor(AutoScalingGroupProviderUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroupProvider").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            AUTO_SCALING_GROUP_PROVIDER_FIELD));

    private final String name;

    private final AutoScalingGroupProviderUpdate autoScalingGroupProvider;

    private UpdateCapacityProviderRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.autoScalingGroupProvider = builder.autoScalingGroupProvider;
    }

    /**
     * <p>
     * The name of the capacity provider to update.
     * </p>
     * 
     * @return The name of the capacity provider to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An object that represent the parameters to update for the Auto Scaling group capacity provider.
     * </p>
     * 
     * @return An object that represent the parameters to update for the Auto Scaling group capacity provider.
     */
    public final AutoScalingGroupProviderUpdate autoScalingGroupProvider() {
        return autoScalingGroupProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupProvider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCapacityProviderRequest)) {
            return false;
        }
        UpdateCapacityProviderRequest other = (UpdateCapacityProviderRequest) obj;
        return Objects.equals(name(), other.name())
                && Objects.equals(autoScalingGroupProvider(), other.autoScalingGroupProvider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCapacityProviderRequest").add("Name", name())
                .add("AutoScalingGroupProvider", autoScalingGroupProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "autoScalingGroupProvider":
            return Optional.ofNullable(clazz.cast(autoScalingGroupProvider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCapacityProviderRequest, T> g) {
        return obj -> g.apply((UpdateCapacityProviderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCapacityProviderRequest> {
        /**
         * <p>
         * The name of the capacity provider to update.
         * </p>
         * 
         * @param name
         *        The name of the capacity provider to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An object that represent the parameters to update for the Auto Scaling group capacity provider.
         * </p>
         * 
         * @param autoScalingGroupProvider
         *        An object that represent the parameters to update for the Auto Scaling group capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupProvider(AutoScalingGroupProviderUpdate autoScalingGroupProvider);

        /**
         * <p>
         * An object that represent the parameters to update for the Auto Scaling group capacity provider.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoScalingGroupProviderUpdate.Builder} avoiding
         * the need to create one manually via {@link AutoScalingGroupProviderUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoScalingGroupProviderUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #autoScalingGroupProvider(AutoScalingGroupProviderUpdate)}.
         * 
         * @param autoScalingGroupProvider
         *        a consumer that will call methods on {@link AutoScalingGroupProviderUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScalingGroupProvider(AutoScalingGroupProviderUpdate)
         */
        default Builder autoScalingGroupProvider(Consumer<AutoScalingGroupProviderUpdate.Builder> autoScalingGroupProvider) {
            return autoScalingGroupProvider(AutoScalingGroupProviderUpdate.builder().applyMutation(autoScalingGroupProvider)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String name;

        private AutoScalingGroupProviderUpdate autoScalingGroupProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCapacityProviderRequest model) {
            super(model);
            name(model.name);
            autoScalingGroupProvider(model.autoScalingGroupProvider);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AutoScalingGroupProviderUpdate.Builder getAutoScalingGroupProvider() {
            return autoScalingGroupProvider != null ? autoScalingGroupProvider.toBuilder() : null;
        }

        public final void setAutoScalingGroupProvider(AutoScalingGroupProviderUpdate.BuilderImpl autoScalingGroupProvider) {
            this.autoScalingGroupProvider = autoScalingGroupProvider != null ? autoScalingGroupProvider.build() : null;
        }

        @Override
        @Transient
        public final Builder autoScalingGroupProvider(AutoScalingGroupProviderUpdate autoScalingGroupProvider) {
            this.autoScalingGroupProvider = autoScalingGroupProvider;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCapacityProviderRequest build() {
            return new UpdateCapacityProviderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
