/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubmitTaskStateChangeRequest extends EcsRequest implements
        ToCopyableBuilder<SubmitTaskStateChangeRequest.Builder, SubmitTaskStateChangeRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(SubmitTaskStateChangeRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> TASK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("task")
            .getter(getter(SubmitTaskStateChangeRequest::task)).setter(setter(Builder::task))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("task").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SubmitTaskStateChangeRequest::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(SubmitTaskStateChangeRequest::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final SdkField<List<ContainerStateChange>> CONTAINERS_FIELD = SdkField
            .<List<ContainerStateChange>> builder(MarshallingType.LIST)
            .memberName("containers")
            .getter(getter(SubmitTaskStateChangeRequest::containers))
            .setter(setter(Builder::containers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContainerStateChange> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContainerStateChange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AttachmentStateChange>> ATTACHMENTS_FIELD = SdkField
            .<List<AttachmentStateChange>> builder(MarshallingType.LIST)
            .memberName("attachments")
            .getter(getter(SubmitTaskStateChangeRequest::attachments))
            .setter(setter(Builder::attachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttachmentStateChange> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttachmentStateChange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ManagedAgentStateChange>> MANAGED_AGENTS_FIELD = SdkField
            .<List<ManagedAgentStateChange>> builder(MarshallingType.LIST)
            .memberName("managedAgents")
            .getter(getter(SubmitTaskStateChangeRequest::managedAgents))
            .setter(setter(Builder::managedAgents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedAgents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ManagedAgentStateChange> builder(MarshallingType.SDK_POJO)
                                            .constructor(ManagedAgentStateChange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> PULL_STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("pullStartedAt").getter(getter(SubmitTaskStateChangeRequest::pullStartedAt))
            .setter(setter(Builder::pullStartedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullStartedAt").build()).build();

    private static final SdkField<Instant> PULL_STOPPED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("pullStoppedAt").getter(getter(SubmitTaskStateChangeRequest::pullStoppedAt))
            .setter(setter(Builder::pullStoppedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullStoppedAt").build()).build();

    private static final SdkField<Instant> EXECUTION_STOPPED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("executionStoppedAt").getter(getter(SubmitTaskStateChangeRequest::executionStoppedAt))
            .setter(setter(Builder::executionStoppedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStoppedAt").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, TASK_FIELD,
            STATUS_FIELD, REASON_FIELD, CONTAINERS_FIELD, ATTACHMENTS_FIELD, MANAGED_AGENTS_FIELD, PULL_STARTED_AT_FIELD,
            PULL_STOPPED_AT_FIELD, EXECUTION_STOPPED_AT_FIELD));

    private final String cluster;

    private final String task;

    private final String status;

    private final String reason;

    private final List<ContainerStateChange> containers;

    private final List<AttachmentStateChange> attachments;

    private final List<ManagedAgentStateChange> managedAgents;

    private final Instant pullStartedAt;

    private final Instant pullStoppedAt;

    private final Instant executionStoppedAt;

    private SubmitTaskStateChangeRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.task = builder.task;
        this.status = builder.status;
        this.reason = builder.reason;
        this.containers = builder.containers;
        this.attachments = builder.attachments;
        this.managedAgents = builder.managedAgents;
        this.pullStartedAt = builder.pullStartedAt;
        this.pullStoppedAt = builder.pullStoppedAt;
        this.executionStoppedAt = builder.executionStoppedAt;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task.
     */
    public final String cluster() {
        return cluster;
    }

    /**
     * <p>
     * The task ID or full ARN of the task in the state change request.
     * </p>
     * 
     * @return The task ID or full ARN of the task in the state change request.
     */
    public final String task() {
        return task;
    }

    /**
     * <p>
     * The status of the state change request.
     * </p>
     * 
     * @return The status of the state change request.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The reason for the state change request.
     * </p>
     * 
     * @return The reason for the state change request.
     */
    public final String reason() {
        return reason;
    }

    /**
     * For responses, this returns true if the service returned a value for the Containers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContainers() {
        return containers != null && !(containers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any containers that's associated with the state change request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainers} method.
     * </p>
     * 
     * @return Any containers that's associated with the state change request.
     */
    public final List<ContainerStateChange> containers() {
        return containers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attachments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttachments() {
        return attachments != null && !(attachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any attachments associated with the state change request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachments} method.
     * </p>
     * 
     * @return Any attachments associated with the state change request.
     */
    public final List<AttachmentStateChange> attachments() {
        return attachments;
    }

    /**
     * For responses, this returns true if the service returned a value for the ManagedAgents property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasManagedAgents() {
        return managedAgents != null && !(managedAgents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details for the managed agent that's associated with the task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManagedAgents} method.
     * </p>
     * 
     * @return The details for the managed agent that's associated with the task.
     */
    public final List<ManagedAgentStateChange> managedAgents() {
        return managedAgents;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the container image pull started.
     * </p>
     * 
     * @return The Unix timestamp for the time when the container image pull started.
     */
    public final Instant pullStartedAt() {
        return pullStartedAt;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the container image pull completed.
     * </p>
     * 
     * @return The Unix timestamp for the time when the container image pull completed.
     */
    public final Instant pullStoppedAt() {
        return pullStoppedAt;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task execution stopped.
     * </p>
     * 
     * @return The Unix timestamp for the time when the task execution stopped.
     */
    public final Instant executionStoppedAt() {
        return executionStoppedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(task());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(hasContainers() ? containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachments() ? attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasManagedAgents() ? managedAgents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(pullStartedAt());
        hashCode = 31 * hashCode + Objects.hashCode(pullStoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(executionStoppedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitTaskStateChangeRequest)) {
            return false;
        }
        SubmitTaskStateChangeRequest other = (SubmitTaskStateChangeRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && Objects.equals(task(), other.task())
                && Objects.equals(status(), other.status()) && Objects.equals(reason(), other.reason())
                && hasContainers() == other.hasContainers() && Objects.equals(containers(), other.containers())
                && hasAttachments() == other.hasAttachments() && Objects.equals(attachments(), other.attachments())
                && hasManagedAgents() == other.hasManagedAgents() && Objects.equals(managedAgents(), other.managedAgents())
                && Objects.equals(pullStartedAt(), other.pullStartedAt())
                && Objects.equals(pullStoppedAt(), other.pullStoppedAt())
                && Objects.equals(executionStoppedAt(), other.executionStoppedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubmitTaskStateChangeRequest").add("Cluster", cluster()).add("Task", task())
                .add("Status", status()).add("Reason", reason()).add("Containers", hasContainers() ? containers() : null)
                .add("Attachments", hasAttachments() ? attachments() : null)
                .add("ManagedAgents", hasManagedAgents() ? managedAgents() : null).add("PullStartedAt", pullStartedAt())
                .add("PullStoppedAt", pullStoppedAt()).add("ExecutionStoppedAt", executionStoppedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "task":
            return Optional.ofNullable(clazz.cast(task()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "containers":
            return Optional.ofNullable(clazz.cast(containers()));
        case "attachments":
            return Optional.ofNullable(clazz.cast(attachments()));
        case "managedAgents":
            return Optional.ofNullable(clazz.cast(managedAgents()));
        case "pullStartedAt":
            return Optional.ofNullable(clazz.cast(pullStartedAt()));
        case "pullStoppedAt":
            return Optional.ofNullable(clazz.cast(pullStoppedAt()));
        case "executionStoppedAt":
            return Optional.ofNullable(clazz.cast(executionStoppedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubmitTaskStateChangeRequest, T> g) {
        return obj -> g.apply((SubmitTaskStateChangeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, SubmitTaskStateChangeRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The task ID or full ARN of the task in the state change request.
         * </p>
         * 
         * @param task
         *        The task ID or full ARN of the task in the state change request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder task(String task);

        /**
         * <p>
         * The status of the state change request.
         * </p>
         * 
         * @param status
         *        The status of the state change request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The reason for the state change request.
         * </p>
         * 
         * @param reason
         *        The reason for the state change request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * Any containers that's associated with the state change request.
         * </p>
         * 
         * @param containers
         *        Any containers that's associated with the state change request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(Collection<ContainerStateChange> containers);

        /**
         * <p>
         * Any containers that's associated with the state change request.
         * </p>
         * 
         * @param containers
         *        Any containers that's associated with the state change request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(ContainerStateChange... containers);

        /**
         * <p>
         * Any containers that's associated with the state change request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ContainerStateChange>.Builder} avoiding the
         * need to create one manually via {@link List<ContainerStateChange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ContainerStateChange>.Builder#build()} is called immediately
         * and its result is passed to {@link #containers(List<ContainerStateChange>)}.
         * 
         * @param containers
         *        a consumer that will call methods on {@link List<ContainerStateChange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containers(List<ContainerStateChange>)
         */
        Builder containers(Consumer<ContainerStateChange.Builder>... containers);

        /**
         * <p>
         * Any attachments associated with the state change request.
         * </p>
         * 
         * @param attachments
         *        Any attachments associated with the state change request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Collection<AttachmentStateChange> attachments);

        /**
         * <p>
         * Any attachments associated with the state change request.
         * </p>
         * 
         * @param attachments
         *        Any attachments associated with the state change request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(AttachmentStateChange... attachments);

        /**
         * <p>
         * Any attachments associated with the state change request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttachmentStateChange>.Builder} avoiding
         * the need to create one manually via {@link List<AttachmentStateChange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttachmentStateChange>.Builder#build()} is called
         * immediately and its result is passed to {@link #attachments(List<AttachmentStateChange>)}.
         * 
         * @param attachments
         *        a consumer that will call methods on {@link List<AttachmentStateChange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachments(List<AttachmentStateChange>)
         */
        Builder attachments(Consumer<AttachmentStateChange.Builder>... attachments);

        /**
         * <p>
         * The details for the managed agent that's associated with the task.
         * </p>
         * 
         * @param managedAgents
         *        The details for the managed agent that's associated with the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedAgents(Collection<ManagedAgentStateChange> managedAgents);

        /**
         * <p>
         * The details for the managed agent that's associated with the task.
         * </p>
         * 
         * @param managedAgents
         *        The details for the managed agent that's associated with the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedAgents(ManagedAgentStateChange... managedAgents);

        /**
         * <p>
         * The details for the managed agent that's associated with the task.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ManagedAgentStateChange>.Builder} avoiding
         * the need to create one manually via {@link List<ManagedAgentStateChange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ManagedAgentStateChange>.Builder#build()} is called
         * immediately and its result is passed to {@link #managedAgents(List<ManagedAgentStateChange>)}.
         * 
         * @param managedAgents
         *        a consumer that will call methods on {@link List<ManagedAgentStateChange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedAgents(List<ManagedAgentStateChange>)
         */
        Builder managedAgents(Consumer<ManagedAgentStateChange.Builder>... managedAgents);

        /**
         * <p>
         * The Unix timestamp for the time when the container image pull started.
         * </p>
         * 
         * @param pullStartedAt
         *        The Unix timestamp for the time when the container image pull started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullStartedAt(Instant pullStartedAt);

        /**
         * <p>
         * The Unix timestamp for the time when the container image pull completed.
         * </p>
         * 
         * @param pullStoppedAt
         *        The Unix timestamp for the time when the container image pull completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullStoppedAt(Instant pullStoppedAt);

        /**
         * <p>
         * The Unix timestamp for the time when the task execution stopped.
         * </p>
         * 
         * @param executionStoppedAt
         *        The Unix timestamp for the time when the task execution stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStoppedAt(Instant executionStoppedAt);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private String task;

        private String status;

        private String reason;

        private List<ContainerStateChange> containers = DefaultSdkAutoConstructList.getInstance();

        private List<AttachmentStateChange> attachments = DefaultSdkAutoConstructList.getInstance();

        private List<ManagedAgentStateChange> managedAgents = DefaultSdkAutoConstructList.getInstance();

        private Instant pullStartedAt;

        private Instant pullStoppedAt;

        private Instant executionStoppedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitTaskStateChangeRequest model) {
            super(model);
            cluster(model.cluster);
            task(model.task);
            status(model.status);
            reason(model.reason);
            containers(model.containers);
            attachments(model.attachments);
            managedAgents(model.managedAgents);
            pullStartedAt(model.pullStartedAt);
            pullStoppedAt(model.pullStoppedAt);
            executionStoppedAt(model.executionStoppedAt);
        }

        public final String getCluster() {
            return cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        @Transient
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final String getTask() {
            return task;
        }

        public final void setTask(String task) {
            this.task = task;
        }

        @Override
        @Transient
        public final Builder task(String task) {
            this.task = task;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        @Transient
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final List<ContainerStateChange.Builder> getContainers() {
            List<ContainerStateChange.Builder> result = ContainerStateChangesCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<ContainerStateChange.BuilderImpl> containers) {
            this.containers = ContainerStateChangesCopier.copyFromBuilder(containers);
        }

        @Override
        @Transient
        public final Builder containers(Collection<ContainerStateChange> containers) {
            this.containers = ContainerStateChangesCopier.copy(containers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder containers(ContainerStateChange... containers) {
            containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder containers(Consumer<ContainerStateChange.Builder>... containers) {
            containers(Stream.of(containers).map(c -> ContainerStateChange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AttachmentStateChange.Builder> getAttachments() {
            List<AttachmentStateChange.Builder> result = AttachmentStateChangesCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<AttachmentStateChange.BuilderImpl> attachments) {
            this.attachments = AttachmentStateChangesCopier.copyFromBuilder(attachments);
        }

        @Override
        @Transient
        public final Builder attachments(Collection<AttachmentStateChange> attachments) {
            this.attachments = AttachmentStateChangesCopier.copy(attachments);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attachments(AttachmentStateChange... attachments) {
            attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attachments(Consumer<AttachmentStateChange.Builder>... attachments) {
            attachments(Stream.of(attachments).map(c -> AttachmentStateChange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ManagedAgentStateChange.Builder> getManagedAgents() {
            List<ManagedAgentStateChange.Builder> result = ManagedAgentStateChangesCopier.copyToBuilder(this.managedAgents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedAgents(Collection<ManagedAgentStateChange.BuilderImpl> managedAgents) {
            this.managedAgents = ManagedAgentStateChangesCopier.copyFromBuilder(managedAgents);
        }

        @Override
        @Transient
        public final Builder managedAgents(Collection<ManagedAgentStateChange> managedAgents) {
            this.managedAgents = ManagedAgentStateChangesCopier.copy(managedAgents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder managedAgents(ManagedAgentStateChange... managedAgents) {
            managedAgents(Arrays.asList(managedAgents));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder managedAgents(Consumer<ManagedAgentStateChange.Builder>... managedAgents) {
            managedAgents(Stream.of(managedAgents).map(c -> ManagedAgentStateChange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getPullStartedAt() {
            return pullStartedAt;
        }

        public final void setPullStartedAt(Instant pullStartedAt) {
            this.pullStartedAt = pullStartedAt;
        }

        @Override
        @Transient
        public final Builder pullStartedAt(Instant pullStartedAt) {
            this.pullStartedAt = pullStartedAt;
            return this;
        }

        public final Instant getPullStoppedAt() {
            return pullStoppedAt;
        }

        public final void setPullStoppedAt(Instant pullStoppedAt) {
            this.pullStoppedAt = pullStoppedAt;
        }

        @Override
        @Transient
        public final Builder pullStoppedAt(Instant pullStoppedAt) {
            this.pullStoppedAt = pullStoppedAt;
            return this;
        }

        public final Instant getExecutionStoppedAt() {
            return executionStoppedAt;
        }

        public final void setExecutionStoppedAt(Instant executionStoppedAt) {
            this.executionStoppedAt = executionStoppedAt;
        }

        @Override
        @Transient
        public final Builder executionStoppedAt(Instant executionStoppedAt) {
            this.executionStoppedAt = executionStoppedAt;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SubmitTaskStateChangeRequest build() {
            return new SubmitTaskStateChangeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
