/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.Attribute;
import software.amazon.awssdk.services.ecs.model.AttributesCopier;
import software.amazon.awssdk.services.ecs.model.EcsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAttributesResponse
extends EcsResponse
implements ToCopyableBuilder<Builder, ListAttributesResponse> {
    private static final SdkField<List<Attribute>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributes").getter(ListAttributesResponse.getter(ListAttributesResponse::attributes)).setter(ListAttributesResponse.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAttributesResponse.getter(ListAttributesResponse::nextToken)).setter(ListAttributesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD, NEXT_TOKEN_FIELD));
    private final List<Attribute> attributes;
    private final String nextToken;

    private ListAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<Attribute> attributes() {
        return this.attributes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttributesResponse)) {
            return false;
        }
        ListAttributesResponse other = (ListAttributesResponse)((Object)obj);
        return this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAttributesResponse").add("Attributes", this.hasAttributes() ? this.attributes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAttributesResponse, T> g) {
        return obj -> g.apply((ListAttributesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsResponse.BuilderImpl
    implements Builder {
        private List<Attribute> attributes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttributesResponse model) {
            super(model);
            this.attributes(model.attributes);
            this.nextToken(model.nextToken);
        }

        public final List<Attribute.Builder> getAttributes() {
            List<Attribute.Builder> result = AttributesCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder attributes(Collection<Attribute> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Attribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<Attribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (Attribute)((Attribute.Builder)Attribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<Attribute.BuilderImpl> attributes) {
            this.attributes = AttributesCopier.copyFromBuilder(attributes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAttributesResponse build() {
            return new ListAttributesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAttributesResponse> {
        public Builder attributes(Collection<Attribute> var1);

        public Builder attributes(Attribute ... var1);

        public Builder attributes(Consumer<Attribute.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

