/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum IpcMode {
    HOST("host"),
    TASK("task"),
    NONE("none"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private IpcMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IpcMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(IpcMode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IpcMode> knownValues() {
        return Stream.of(IpcMode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

