/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Compatibility {
    EC2("EC2"),
    FARGATE("FARGATE"),
    EXTERNAL("EXTERNAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Compatibility(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Compatibility fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Compatibility.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Compatibility> knownValues() {
        return Stream.of(Compatibility.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

