/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecrpublic.model.RegistryAlias;
import software.amazon.awssdk.services.ecrpublic.model.RegistryAliasListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Registry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Registry> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(Registry.getter(Registry::registryId)).setter(Registry.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<String> REGISTRY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryArn").getter(Registry.getter(Registry::registryArn)).setter(Registry.setter(Builder::registryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryArn").build()}).build();
    private static final SdkField<String> REGISTRY_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryUri").getter(Registry.getter(Registry::registryUri)).setter(Registry.setter(Builder::registryUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryUri").build()}).build();
    private static final SdkField<Boolean> VERIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("verified").getter(Registry.getter(Registry::verified)).setter(Registry.setter(Builder::verified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verified").build()}).build();
    private static final SdkField<List<RegistryAlias>> ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("aliases").getter(Registry.getter(Registry::aliases)).setter(Registry.setter(Builder::aliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegistryAlias::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD, REGISTRY_ARN_FIELD, REGISTRY_URI_FIELD, VERIFIED_FIELD, ALIASES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Registry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String registryId;
    private final String registryArn;
    private final String registryUri;
    private final Boolean verified;
    private final List<RegistryAlias> aliases;

    private Registry(BuilderImpl builder) {
        this.registryId = builder.registryId;
        this.registryArn = builder.registryArn;
        this.registryUri = builder.registryUri;
        this.verified = builder.verified;
        this.aliases = builder.aliases;
    }

    public final String registryId() {
        return this.registryId;
    }

    public final String registryArn() {
        return this.registryArn;
    }

    public final String registryUri() {
        return this.registryUri;
    }

    public final Boolean verified() {
        return this.verified;
    }

    public final boolean hasAliases() {
        return this.aliases != null && !(this.aliases instanceof SdkAutoConstructList);
    }

    public final List<RegistryAlias> aliases() {
        return this.aliases;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.registryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.registryUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.verified());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAliases() ? this.aliases() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Registry)) {
            return false;
        }
        Registry other = (Registry)obj;
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.registryArn(), other.registryArn()) && Objects.equals(this.registryUri(), other.registryUri()) && Objects.equals(this.verified(), other.verified()) && this.hasAliases() == other.hasAliases() && Objects.equals(this.aliases(), other.aliases());
    }

    public final String toString() {
        return ToString.builder((String)"Registry").add("RegistryId", (Object)this.registryId()).add("RegistryArn", (Object)this.registryArn()).add("RegistryUri", (Object)this.registryUri()).add("Verified", (Object)this.verified()).add("Aliases", this.hasAliases() ? this.aliases() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "registryArn": {
                return Optional.ofNullable(clazz.cast(this.registryArn()));
            }
            case "registryUri": {
                return Optional.ofNullable(clazz.cast(this.registryUri()));
            }
            case "verified": {
                return Optional.ofNullable(clazz.cast(this.verified()));
            }
            case "aliases": {
                return Optional.ofNullable(clazz.cast(this.aliases()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("registryId", REGISTRY_ID_FIELD);
        map.put("registryArn", REGISTRY_ARN_FIELD);
        map.put("registryUri", REGISTRY_URI_FIELD);
        map.put("verified", VERIFIED_FIELD);
        map.put("aliases", ALIASES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Registry, T> g) {
        return obj -> g.apply((Registry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String registryId;
        private String registryArn;
        private String registryUri;
        private Boolean verified;
        private List<RegistryAlias> aliases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Registry model) {
            this.registryId(model.registryId);
            this.registryArn(model.registryArn);
            this.registryUri(model.registryUri);
            this.verified(model.verified);
            this.aliases(model.aliases);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRegistryArn() {
            return this.registryArn;
        }

        public final void setRegistryArn(String registryArn) {
            this.registryArn = registryArn;
        }

        @Override
        public final Builder registryArn(String registryArn) {
            this.registryArn = registryArn;
            return this;
        }

        public final String getRegistryUri() {
            return this.registryUri;
        }

        public final void setRegistryUri(String registryUri) {
            this.registryUri = registryUri;
        }

        @Override
        public final Builder registryUri(String registryUri) {
            this.registryUri = registryUri;
            return this;
        }

        public final Boolean getVerified() {
            return this.verified;
        }

        public final void setVerified(Boolean verified) {
            this.verified = verified;
        }

        @Override
        public final Builder verified(Boolean verified) {
            this.verified = verified;
            return this;
        }

        public final List<RegistryAlias.Builder> getAliases() {
            List<RegistryAlias.Builder> result = RegistryAliasListCopier.copyToBuilder(this.aliases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAliases(Collection<RegistryAlias.BuilderImpl> aliases) {
            this.aliases = RegistryAliasListCopier.copyFromBuilder(aliases);
        }

        @Override
        public final Builder aliases(Collection<RegistryAlias> aliases) {
            this.aliases = RegistryAliasListCopier.copy(aliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(RegistryAlias ... aliases) {
            this.aliases(Arrays.asList(aliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(Consumer<RegistryAlias.Builder> ... aliases) {
            this.aliases(Stream.of(aliases).map(c -> (RegistryAlias)((RegistryAlias.Builder)RegistryAlias.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Registry build() {
            return new Registry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Registry> {
        public Builder registryId(String var1);

        public Builder registryArn(String var1);

        public Builder registryUri(String var1);

        public Builder verified(Boolean var1);

        public Builder aliases(Collection<RegistryAlias> var1);

        public Builder aliases(RegistryAlias ... var1);

        public Builder aliases(Consumer<RegistryAlias.Builder> ... var1);
    }
}

