/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.ReplicationDestination;
import software.amazon.awssdk.services.ecr.model.ReplicationDestinationListCopier;
import software.amazon.awssdk.services.ecr.model.RepositoryFilter;
import software.amazon.awssdk.services.ecr.model.RepositoryFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationRule> {
    private static final SdkField<List<ReplicationDestination>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("destinations").getter(ReplicationRule.getter(ReplicationRule::destinations)).setter(ReplicationRule.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RepositoryFilter>> REPOSITORY_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("repositoryFilters").getter(ReplicationRule.getter(ReplicationRule::repositoryFilters)).setter(ReplicationRule.setter(Builder::repositoryFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RepositoryFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATIONS_FIELD, REPOSITORY_FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReplicationRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ReplicationDestination> destinations;
    private final List<RepositoryFilter> repositoryFilters;

    private ReplicationRule(BuilderImpl builder) {
        this.destinations = builder.destinations;
        this.repositoryFilters = builder.repositoryFilters;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<ReplicationDestination> destinations() {
        return this.destinations;
    }

    public final boolean hasRepositoryFilters() {
        return this.repositoryFilters != null && !(this.repositoryFilters instanceof SdkAutoConstructList);
    }

    public final List<RepositoryFilter> repositoryFilters() {
        return this.repositoryFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRepositoryFilters() ? this.repositoryFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationRule)) {
            return false;
        }
        ReplicationRule other = (ReplicationRule)obj;
        return this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && this.hasRepositoryFilters() == other.hasRepositoryFilters() && Objects.equals(this.repositoryFilters(), other.repositoryFilters());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicationRule").add("Destinations", this.hasDestinations() ? this.destinations() : null).add("RepositoryFilters", this.hasRepositoryFilters() ? this.repositoryFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "repositoryFilters": {
                return Optional.ofNullable(clazz.cast(this.repositoryFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("destinations", DESTINATIONS_FIELD);
        map.put("repositoryFilters", REPOSITORY_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicationRule, T> g) {
        return obj -> g.apply((ReplicationRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ReplicationDestination> destinations = DefaultSdkAutoConstructList.getInstance();
        private List<RepositoryFilter> repositoryFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationRule model) {
            this.destinations(model.destinations);
            this.repositoryFilters(model.repositoryFilters);
        }

        public final List<ReplicationDestination.Builder> getDestinations() {
            List<ReplicationDestination.Builder> result = ReplicationDestinationListCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<ReplicationDestination.BuilderImpl> destinations) {
            this.destinations = ReplicationDestinationListCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<ReplicationDestination> destinations) {
            this.destinations = ReplicationDestinationListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(ReplicationDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<ReplicationDestination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (ReplicationDestination)((ReplicationDestination.Builder)ReplicationDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RepositoryFilter.Builder> getRepositoryFilters() {
            List<RepositoryFilter.Builder> result = RepositoryFilterListCopier.copyToBuilder(this.repositoryFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRepositoryFilters(Collection<RepositoryFilter.BuilderImpl> repositoryFilters) {
            this.repositoryFilters = RepositoryFilterListCopier.copyFromBuilder(repositoryFilters);
        }

        @Override
        public final Builder repositoryFilters(Collection<RepositoryFilter> repositoryFilters) {
            this.repositoryFilters = RepositoryFilterListCopier.copy(repositoryFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryFilters(RepositoryFilter ... repositoryFilters) {
            this.repositoryFilters(Arrays.asList(repositoryFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryFilters(Consumer<RepositoryFilter.Builder> ... repositoryFilters) {
            this.repositoryFilters(Stream.of(repositoryFilters).map(c -> (RepositoryFilter)((RepositoryFilter.Builder)RepositoryFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ReplicationRule build() {
            return new ReplicationRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationRule> {
        public Builder destinations(Collection<ReplicationDestination> var1);

        public Builder destinations(ReplicationDestination ... var1);

        public Builder destinations(Consumer<ReplicationDestination.Builder> ... var1);

        public Builder repositoryFilters(Collection<RepositoryFilter> var1);

        public Builder repositoryFilters(RepositoryFilter ... var1);

        public Builder repositoryFilters(Consumer<RepositoryFilter.Builder> ... var1);
    }
}

