/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.PackageVulnerabilityDetails;
import software.amazon.awssdk.services.ecr.model.Remediation;
import software.amazon.awssdk.services.ecr.model.Resource;
import software.amazon.awssdk.services.ecr.model.ResourceListCopier;
import software.amazon.awssdk.services.ecr.model.ScoreDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnhancedImageScanFinding
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnhancedImageScanFinding> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsAccountId").getter(EnhancedImageScanFinding.getter(EnhancedImageScanFinding::awsAccountId)).setter(EnhancedImageScanFinding.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(EnhancedImageScanFinding.getter(EnhancedImageScanFinding::description)).setter(EnhancedImageScanFinding.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> FINDING_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("findingArn").getter(EnhancedImageScanFinding.getter(EnhancedImageScanFinding::findingArn)).setter(EnhancedImageScanFinding.setter(Builder::findingArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingArn").build()}).build();
    private static final SdkField<Instant> FIRST_OBSERVED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("firstObservedAt").getter(EnhancedImageScanFinding.getter(EnhancedImageScanFinding::firstObservedAt)).setter(EnhancedImageScanFinding.setter(Builder::firstObservedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstObservedAt").build()}).build();
    private static final SdkField<Instant> LAST_OBSERVED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastObservedAt").getter(EnhancedImageScanFinding.getter(EnhancedImageScanFinding::lastObservedAt)).setter(EnhancedImageScanFinding.setter(Builder::lastObservedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastObservedAt").build()}).build();
    private static final SdkField<PackageVulnerabilityDetails> PACKAGE_VULNERABILITY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("packageVulnerabilityDetails").getter(EnhancedImageScanFinding.getter(EnhancedImageScanFinding::packageVulnerabilityDetails)).setter(EnhancedImageScanFinding.setter(Builder::packageVulnerabilityDetails)).constructor(PackageVulnerabilityDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageVulnerabilityDetails").build()}).build();
    private static final SdkField<Remediation> REMEDIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("remediation").getter(EnhancedImageScanFinding.getter(EnhancedImageScanFinding::remediation)).setter(EnhancedImageScanFinding.setter(Builder::remediation)).constructor(Remediation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remediation").build()}).build();
    private static final SdkField<List<Resource>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resources").getter(EnhancedImageScanFinding.getter(EnhancedImageScanFinding::resources)).setter(EnhancedImageScanFinding.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("score").getter(EnhancedImageScanFinding.getter(EnhancedImageScanFinding::score)).setter(EnhancedImageScanFinding.setter(Builder::score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("score").build()}).build();
    private static final SdkField<ScoreDetails> SCORE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scoreDetails").getter(EnhancedImageScanFinding.getter(EnhancedImageScanFinding::scoreDetails)).setter(EnhancedImageScanFinding.setter(Builder::scoreDetails)).constructor(ScoreDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scoreDetails").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("severity").getter(EnhancedImageScanFinding.getter(EnhancedImageScanFinding::severity)).setter(EnhancedImageScanFinding.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(EnhancedImageScanFinding.getter(EnhancedImageScanFinding::status)).setter(EnhancedImageScanFinding.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(EnhancedImageScanFinding.getter(EnhancedImageScanFinding::title)).setter(EnhancedImageScanFinding.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(EnhancedImageScanFinding.getter(EnhancedImageScanFinding::type)).setter(EnhancedImageScanFinding.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(EnhancedImageScanFinding.getter(EnhancedImageScanFinding::updatedAt)).setter(EnhancedImageScanFinding.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> FIX_AVAILABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fixAvailable").getter(EnhancedImageScanFinding.getter(EnhancedImageScanFinding::fixAvailable)).setter(EnhancedImageScanFinding.setter(Builder::fixAvailable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixAvailable").build()}).build();
    private static final SdkField<String> EXPLOIT_AVAILABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exploitAvailable").getter(EnhancedImageScanFinding.getter(EnhancedImageScanFinding::exploitAvailable)).setter(EnhancedImageScanFinding.setter(Builder::exploitAvailable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exploitAvailable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, DESCRIPTION_FIELD, FINDING_ARN_FIELD, FIRST_OBSERVED_AT_FIELD, LAST_OBSERVED_AT_FIELD, PACKAGE_VULNERABILITY_DETAILS_FIELD, REMEDIATION_FIELD, RESOURCES_FIELD, SCORE_FIELD, SCORE_DETAILS_FIELD, SEVERITY_FIELD, STATUS_FIELD, TITLE_FIELD, TYPE_FIELD, UPDATED_AT_FIELD, FIX_AVAILABLE_FIELD, EXPLOIT_AVAILABLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnhancedImageScanFinding.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String awsAccountId;
    private final String description;
    private final String findingArn;
    private final Instant firstObservedAt;
    private final Instant lastObservedAt;
    private final PackageVulnerabilityDetails packageVulnerabilityDetails;
    private final Remediation remediation;
    private final List<Resource> resources;
    private final Double score;
    private final ScoreDetails scoreDetails;
    private final String severity;
    private final String status;
    private final String title;
    private final String type;
    private final Instant updatedAt;
    private final String fixAvailable;
    private final String exploitAvailable;

    private EnhancedImageScanFinding(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.description = builder.description;
        this.findingArn = builder.findingArn;
        this.firstObservedAt = builder.firstObservedAt;
        this.lastObservedAt = builder.lastObservedAt;
        this.packageVulnerabilityDetails = builder.packageVulnerabilityDetails;
        this.remediation = builder.remediation;
        this.resources = builder.resources;
        this.score = builder.score;
        this.scoreDetails = builder.scoreDetails;
        this.severity = builder.severity;
        this.status = builder.status;
        this.title = builder.title;
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
        this.fixAvailable = builder.fixAvailable;
        this.exploitAvailable = builder.exploitAvailable;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String description() {
        return this.description;
    }

    public final String findingArn() {
        return this.findingArn;
    }

    public final Instant firstObservedAt() {
        return this.firstObservedAt;
    }

    public final Instant lastObservedAt() {
        return this.lastObservedAt;
    }

    public final PackageVulnerabilityDetails packageVulnerabilityDetails() {
        return this.packageVulnerabilityDetails;
    }

    public final Remediation remediation() {
        return this.remediation;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<Resource> resources() {
        return this.resources;
    }

    public final Double score() {
        return this.score;
    }

    public final ScoreDetails scoreDetails() {
        return this.scoreDetails;
    }

    public final String severity() {
        return this.severity;
    }

    public final String status() {
        return this.status;
    }

    public final String title() {
        return this.title;
    }

    public final String type() {
        return this.type;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String fixAvailable() {
        return this.fixAvailable;
    }

    public final String exploitAvailable() {
        return this.exploitAvailable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstObservedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastObservedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageVulnerabilityDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.remediation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        hashCode = 31 * hashCode + Objects.hashCode(this.scoreDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixAvailable());
        hashCode = 31 * hashCode + Objects.hashCode(this.exploitAvailable());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnhancedImageScanFinding)) {
            return false;
        }
        EnhancedImageScanFinding other = (EnhancedImageScanFinding)obj;
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.findingArn(), other.findingArn()) && Objects.equals(this.firstObservedAt(), other.firstObservedAt()) && Objects.equals(this.lastObservedAt(), other.lastObservedAt()) && Objects.equals(this.packageVulnerabilityDetails(), other.packageVulnerabilityDetails()) && Objects.equals(this.remediation(), other.remediation()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.score(), other.score()) && Objects.equals(this.scoreDetails(), other.scoreDetails()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.fixAvailable(), other.fixAvailable()) && Objects.equals(this.exploitAvailable(), other.exploitAvailable());
    }

    public final String toString() {
        return ToString.builder((String)"EnhancedImageScanFinding").add("AwsAccountId", (Object)this.awsAccountId()).add("Description", (Object)this.description()).add("FindingArn", (Object)this.findingArn()).add("FirstObservedAt", (Object)this.firstObservedAt()).add("LastObservedAt", (Object)this.lastObservedAt()).add("PackageVulnerabilityDetails", (Object)this.packageVulnerabilityDetails()).add("Remediation", (Object)this.remediation()).add("Resources", this.hasResources() ? this.resources() : null).add("Score", (Object)this.score()).add("ScoreDetails", (Object)this.scoreDetails()).add("Severity", (Object)this.severity()).add("Status", (Object)this.status()).add("Title", (Object)this.title()).add("Type", (Object)this.type()).add("UpdatedAt", (Object)this.updatedAt()).add("FixAvailable", (Object)this.fixAvailable()).add("ExploitAvailable", (Object)this.exploitAvailable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "findingArn": {
                return Optional.ofNullable(clazz.cast(this.findingArn()));
            }
            case "firstObservedAt": {
                return Optional.ofNullable(clazz.cast(this.firstObservedAt()));
            }
            case "lastObservedAt": {
                return Optional.ofNullable(clazz.cast(this.lastObservedAt()));
            }
            case "packageVulnerabilityDetails": {
                return Optional.ofNullable(clazz.cast(this.packageVulnerabilityDetails()));
            }
            case "remediation": {
                return Optional.ofNullable(clazz.cast(this.remediation()));
            }
            case "resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
            case "scoreDetails": {
                return Optional.ofNullable(clazz.cast(this.scoreDetails()));
            }
            case "severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "fixAvailable": {
                return Optional.ofNullable(clazz.cast(this.fixAvailable()));
            }
            case "exploitAvailable": {
                return Optional.ofNullable(clazz.cast(this.exploitAvailable()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("findingArn", FINDING_ARN_FIELD);
        map.put("firstObservedAt", FIRST_OBSERVED_AT_FIELD);
        map.put("lastObservedAt", LAST_OBSERVED_AT_FIELD);
        map.put("packageVulnerabilityDetails", PACKAGE_VULNERABILITY_DETAILS_FIELD);
        map.put("remediation", REMEDIATION_FIELD);
        map.put("resources", RESOURCES_FIELD);
        map.put("score", SCORE_FIELD);
        map.put("scoreDetails", SCORE_DETAILS_FIELD);
        map.put("severity", SEVERITY_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("fixAvailable", FIX_AVAILABLE_FIELD);
        map.put("exploitAvailable", EXPLOIT_AVAILABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnhancedImageScanFinding, T> g) {
        return obj -> g.apply((EnhancedImageScanFinding)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String description;
        private String findingArn;
        private Instant firstObservedAt;
        private Instant lastObservedAt;
        private PackageVulnerabilityDetails packageVulnerabilityDetails;
        private Remediation remediation;
        private List<Resource> resources = DefaultSdkAutoConstructList.getInstance();
        private Double score;
        private ScoreDetails scoreDetails;
        private String severity;
        private String status;
        private String title;
        private String type;
        private Instant updatedAt;
        private String fixAvailable;
        private String exploitAvailable;

        private BuilderImpl() {
        }

        private BuilderImpl(EnhancedImageScanFinding model) {
            this.awsAccountId(model.awsAccountId);
            this.description(model.description);
            this.findingArn(model.findingArn);
            this.firstObservedAt(model.firstObservedAt);
            this.lastObservedAt(model.lastObservedAt);
            this.packageVulnerabilityDetails(model.packageVulnerabilityDetails);
            this.remediation(model.remediation);
            this.resources(model.resources);
            this.score(model.score);
            this.scoreDetails(model.scoreDetails);
            this.severity(model.severity);
            this.status(model.status);
            this.title(model.title);
            this.type(model.type);
            this.updatedAt(model.updatedAt);
            this.fixAvailable(model.fixAvailable);
            this.exploitAvailable(model.exploitAvailable);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFindingArn() {
            return this.findingArn;
        }

        public final void setFindingArn(String findingArn) {
            this.findingArn = findingArn;
        }

        @Override
        public final Builder findingArn(String findingArn) {
            this.findingArn = findingArn;
            return this;
        }

        public final Instant getFirstObservedAt() {
            return this.firstObservedAt;
        }

        public final void setFirstObservedAt(Instant firstObservedAt) {
            this.firstObservedAt = firstObservedAt;
        }

        @Override
        public final Builder firstObservedAt(Instant firstObservedAt) {
            this.firstObservedAt = firstObservedAt;
            return this;
        }

        public final Instant getLastObservedAt() {
            return this.lastObservedAt;
        }

        public final void setLastObservedAt(Instant lastObservedAt) {
            this.lastObservedAt = lastObservedAt;
        }

        @Override
        public final Builder lastObservedAt(Instant lastObservedAt) {
            this.lastObservedAt = lastObservedAt;
            return this;
        }

        public final PackageVulnerabilityDetails.Builder getPackageVulnerabilityDetails() {
            return this.packageVulnerabilityDetails != null ? this.packageVulnerabilityDetails.toBuilder() : null;
        }

        public final void setPackageVulnerabilityDetails(PackageVulnerabilityDetails.BuilderImpl packageVulnerabilityDetails) {
            this.packageVulnerabilityDetails = packageVulnerabilityDetails != null ? packageVulnerabilityDetails.build() : null;
        }

        @Override
        public final Builder packageVulnerabilityDetails(PackageVulnerabilityDetails packageVulnerabilityDetails) {
            this.packageVulnerabilityDetails = packageVulnerabilityDetails;
            return this;
        }

        public final Remediation.Builder getRemediation() {
            return this.remediation != null ? this.remediation.toBuilder() : null;
        }

        public final void setRemediation(Remediation.BuilderImpl remediation) {
            this.remediation = remediation != null ? remediation.build() : null;
        }

        @Override
        public final Builder remediation(Remediation remediation) {
            this.remediation = remediation;
            return this;
        }

        public final List<Resource.Builder> getResources() {
            List<Resource.Builder> result = ResourceListCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<Resource.BuilderImpl> resources) {
            this.resources = ResourceListCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ResourceListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Resource ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<Resource.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (Resource)((Resource.Builder)Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getScore() {
            return this.score;
        }

        public final void setScore(Double score) {
            this.score = score;
        }

        @Override
        public final Builder score(Double score) {
            this.score = score;
            return this;
        }

        public final ScoreDetails.Builder getScoreDetails() {
            return this.scoreDetails != null ? this.scoreDetails.toBuilder() : null;
        }

        public final void setScoreDetails(ScoreDetails.BuilderImpl scoreDetails) {
            this.scoreDetails = scoreDetails != null ? scoreDetails.build() : null;
        }

        @Override
        public final Builder scoreDetails(ScoreDetails scoreDetails) {
            this.scoreDetails = scoreDetails;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getFixAvailable() {
            return this.fixAvailable;
        }

        public final void setFixAvailable(String fixAvailable) {
            this.fixAvailable = fixAvailable;
        }

        @Override
        public final Builder fixAvailable(String fixAvailable) {
            this.fixAvailable = fixAvailable;
            return this;
        }

        public final String getExploitAvailable() {
            return this.exploitAvailable;
        }

        public final void setExploitAvailable(String exploitAvailable) {
            this.exploitAvailable = exploitAvailable;
        }

        @Override
        public final Builder exploitAvailable(String exploitAvailable) {
            this.exploitAvailable = exploitAvailable;
            return this;
        }

        public EnhancedImageScanFinding build() {
            return new EnhancedImageScanFinding(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnhancedImageScanFinding> {
        public Builder awsAccountId(String var1);

        public Builder description(String var1);

        public Builder findingArn(String var1);

        public Builder firstObservedAt(Instant var1);

        public Builder lastObservedAt(Instant var1);

        public Builder packageVulnerabilityDetails(PackageVulnerabilityDetails var1);

        default public Builder packageVulnerabilityDetails(Consumer<PackageVulnerabilityDetails.Builder> packageVulnerabilityDetails) {
            return this.packageVulnerabilityDetails((PackageVulnerabilityDetails)((PackageVulnerabilityDetails.Builder)PackageVulnerabilityDetails.builder().applyMutation(packageVulnerabilityDetails)).build());
        }

        public Builder remediation(Remediation var1);

        default public Builder remediation(Consumer<Remediation.Builder> remediation) {
            return this.remediation((Remediation)((Remediation.Builder)Remediation.builder().applyMutation(remediation)).build());
        }

        public Builder resources(Collection<Resource> var1);

        public Builder resources(Resource ... var1);

        public Builder resources(Consumer<Resource.Builder> ... var1);

        public Builder score(Double var1);

        public Builder scoreDetails(ScoreDetails var1);

        default public Builder scoreDetails(Consumer<ScoreDetails.Builder> scoreDetails) {
            return this.scoreDetails((ScoreDetails)((ScoreDetails.Builder)ScoreDetails.builder().applyMutation(scoreDetails)).build());
        }

        public Builder severity(String var1);

        public Builder status(String var1);

        public Builder title(String var1);

        public Builder type(String var1);

        public Builder updatedAt(Instant var1);

        public Builder fixAvailable(String var1);

        public Builder exploitAvailable(String var1);
    }
}

