/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse;
import software.amazon.awssdk.services.ec2.model.NetworkInterface;

public class DescribeNetworkInterfacesPublisher
implements SdkPublisher<DescribeNetworkInterfacesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeNetworkInterfacesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeNetworkInterfacesPublisher(Ec2AsyncClient client, DescribeNetworkInterfacesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeNetworkInterfacesPublisher(Ec2AsyncClient client, DescribeNetworkInterfacesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeNetworkInterfacesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeNetworkInterfacesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NetworkInterface> networkInterfaces() {
        return this.flatMapIterable(response -> response.networkInterfaces());
    }

    private class DescribeNetworkInterfacesResponseFetcher
    implements AsyncPageFetcher<DescribeNetworkInterfacesResponse> {
        private DescribeNetworkInterfacesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNetworkInterfacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeNetworkInterfacesResponse> nextPage(DescribeNetworkInterfacesResponse previousPage) {
            if (previousPage == null) {
                return DescribeNetworkInterfacesPublisher.this.client.describeNetworkInterfaces(DescribeNetworkInterfacesPublisher.this.firstRequest);
            }
            return DescribeNetworkInterfacesPublisher.this.client.describeNetworkInterfaces((DescribeNetworkInterfacesRequest)((Object)DescribeNetworkInterfacesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

