/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeIpamsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamsResponse;
import software.amazon.awssdk.services.ec2.model.Ipam;

public class DescribeIpamsPublisher
implements SdkPublisher<DescribeIpamsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeIpamsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeIpamsPublisher(Ec2AsyncClient client, DescribeIpamsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeIpamsPublisher(Ec2AsyncClient client, DescribeIpamsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeIpamsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeIpamsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Ipam> ipams() {
        return this.flatMapIterable(response -> response.ipams());
    }

    private class DescribeIpamsResponseFetcher
    implements AsyncPageFetcher<DescribeIpamsResponse> {
        private DescribeIpamsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeIpamsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeIpamsResponse> nextPage(DescribeIpamsResponse previousPage) {
            if (previousPage == null) {
                return DescribeIpamsPublisher.this.client.describeIpams(DescribeIpamsPublisher.this.firstRequest);
            }
            return DescribeIpamsPublisher.this.client.describeIpams((DescribeIpamsRequest)((Object)DescribeIpamsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

