/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the encryption support status for a transit gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionSupport implements SdkPojo, Serializable,
        ToCopyableBuilder<EncryptionSupport.Builder, EncryptionSupport> {
    private static final SdkField<String> ENCRYPTION_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EncryptionState")
            .getter(getter(EncryptionSupport::encryptionStateAsString))
            .setter(setter(Builder::encryptionState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionState")
                    .unmarshallLocationName("encryptionState").build()).build();

    private static final SdkField<String> STATE_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StateMessage")
            .getter(getter(EncryptionSupport::stateMessage))
            .setter(setter(Builder::stateMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateMessage")
                    .unmarshallLocationName("stateMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_STATE_FIELD,
            STATE_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String encryptionState;

    private final String stateMessage;

    private EncryptionSupport(BuilderImpl builder) {
        this.encryptionState = builder.encryptionState;
        this.stateMessage = builder.stateMessage;
    }

    /**
     * <p>
     * The current encryption state of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionState}
     * will return {@link EncryptionStateValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #encryptionStateAsString}.
     * </p>
     * 
     * @return The current encryption state of the resource.
     * @see EncryptionStateValue
     */
    public final EncryptionStateValue encryptionState() {
        return EncryptionStateValue.fromValue(encryptionState);
    }

    /**
     * <p>
     * The current encryption state of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionState}
     * will return {@link EncryptionStateValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #encryptionStateAsString}.
     * </p>
     * 
     * @return The current encryption state of the resource.
     * @see EncryptionStateValue
     */
    public final String encryptionStateAsString() {
        return encryptionState;
    }

    /**
     * <p>
     * A message describing the encryption state.
     * </p>
     * 
     * @return A message describing the encryption state.
     */
    public final String stateMessage() {
        return stateMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryptionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionSupport)) {
            return false;
        }
        EncryptionSupport other = (EncryptionSupport) obj;
        return Objects.equals(encryptionStateAsString(), other.encryptionStateAsString())
                && Objects.equals(stateMessage(), other.stateMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EncryptionSupport").add("EncryptionState", encryptionStateAsString())
                .add("StateMessage", stateMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncryptionState":
            return Optional.ofNullable(clazz.cast(encryptionStateAsString()));
        case "StateMessage":
            return Optional.ofNullable(clazz.cast(stateMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EncryptionState", ENCRYPTION_STATE_FIELD);
        map.put("StateMessage", STATE_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EncryptionSupport, T> g) {
        return obj -> g.apply((EncryptionSupport) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionSupport> {
        /**
         * <p>
         * The current encryption state of the resource.
         * </p>
         * 
         * @param encryptionState
         *        The current encryption state of the resource.
         * @see EncryptionStateValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionStateValue
         */
        Builder encryptionState(String encryptionState);

        /**
         * <p>
         * The current encryption state of the resource.
         * </p>
         * 
         * @param encryptionState
         *        The current encryption state of the resource.
         * @see EncryptionStateValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionStateValue
         */
        Builder encryptionState(EncryptionStateValue encryptionState);

        /**
         * <p>
         * A message describing the encryption state.
         * </p>
         * 
         * @param stateMessage
         *        A message describing the encryption state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMessage(String stateMessage);
    }

    static final class BuilderImpl implements Builder {
        private String encryptionState;

        private String stateMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionSupport model) {
            encryptionState(model.encryptionState);
            stateMessage(model.stateMessage);
        }

        public final String getEncryptionState() {
            return encryptionState;
        }

        public final void setEncryptionState(String encryptionState) {
            this.encryptionState = encryptionState;
        }

        @Override
        public final Builder encryptionState(String encryptionState) {
            this.encryptionState = encryptionState;
            return this;
        }

        @Override
        public final Builder encryptionState(EncryptionStateValue encryptionState) {
            this.encryptionState(encryptionState == null ? null : encryptionState.toString());
            return this;
        }

        public final String getStateMessage() {
            return stateMessage;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        @Override
        public EncryptionSupport build() {
            return new EncryptionSupport(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
