/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an appliance attached to a NAT Gateway, providing managed security solutions for traffic filtering
 * and inspection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NatGatewayAttachedAppliance implements SdkPojo, Serializable,
        ToCopyableBuilder<NatGatewayAttachedAppliance.Builder, NatGatewayAttachedAppliance> {
    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Type")
            .getter(getter(NatGatewayAttachedAppliance::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("type").build()).build();

    private static final SdkField<String> APPLIANCE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApplianceArn")
            .getter(getter(NatGatewayAttachedAppliance::applianceArn))
            .setter(setter(Builder::applianceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplianceArn")
                    .unmarshallLocationName("applianceArn").build()).build();

    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointId")
            .getter(getter(NatGatewayAttachedAppliance::vpcEndpointId))
            .setter(setter(Builder::vpcEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId")
                    .unmarshallLocationName("vpcEndpointId").build()).build();

    private static final SdkField<String> ATTACHMENT_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AttachmentState")
            .getter(getter(NatGatewayAttachedAppliance::attachmentStateAsString))
            .setter(setter(Builder::attachmentState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentState")
                    .unmarshallLocationName("attachmentState").build()).build();

    private static final SdkField<String> MODIFICATION_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ModificationState")
            .getter(getter(NatGatewayAttachedAppliance::modificationStateAsString))
            .setter(setter(Builder::modificationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationState")
                    .unmarshallLocationName("modificationState").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FailureCode")
            .getter(getter(NatGatewayAttachedAppliance::failureCode))
            .setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode")
                    .unmarshallLocationName("failureCode").build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FailureMessage")
            .getter(getter(NatGatewayAttachedAppliance::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage")
                    .unmarshallLocationName("failureMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            APPLIANCE_ARN_FIELD, VPC_ENDPOINT_ID_FIELD, ATTACHMENT_STATE_FIELD, MODIFICATION_STATE_FIELD, FAILURE_CODE_FIELD,
            FAILURE_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String applianceArn;

    private final String vpcEndpointId;

    private final String attachmentState;

    private final String modificationState;

    private final String failureCode;

    private final String failureMessage;

    private NatGatewayAttachedAppliance(BuilderImpl builder) {
        this.type = builder.type;
        this.applianceArn = builder.applianceArn;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.attachmentState = builder.attachmentState;
        this.modificationState = builder.modificationState;
        this.failureCode = builder.failureCode;
        this.failureMessage = builder.failureMessage;
    }

    /**
     * <p>
     * The type of appliance attached to the NAT Gateway. For network firewall proxy functionality, this will be
     * "network-firewall-proxy".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NatGatewayApplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of appliance attached to the NAT Gateway. For network firewall proxy functionality, this will be
     *         "network-firewall-proxy".
     * @see NatGatewayApplianceType
     */
    public final NatGatewayApplianceType type() {
        return NatGatewayApplianceType.fromValue(type);
    }

    /**
     * <p>
     * The type of appliance attached to the NAT Gateway. For network firewall proxy functionality, this will be
     * "network-firewall-proxy".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NatGatewayApplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of appliance attached to the NAT Gateway. For network firewall proxy functionality, this will be
     *         "network-firewall-proxy".
     * @see NatGatewayApplianceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the attached appliance, identifying the specific proxy or security appliance
     * resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the attached appliance, identifying the specific proxy or security
     *         appliance resource.
     */
    public final String applianceArn() {
        return applianceArn;
    }

    /**
     * <p>
     * The VPC endpoint ID used to route traffic from application VPCs to the proxy for inspection and filtering.
     * </p>
     * 
     * @return The VPC endpoint ID used to route traffic from application VPCs to the proxy for inspection and
     *         filtering.
     */
    public final String vpcEndpointId() {
        return vpcEndpointId;
    }

    /**
     * <p>
     * The current attachment state of the appliance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attachmentState}
     * will return {@link NatGatewayApplianceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attachmentStateAsString}.
     * </p>
     * 
     * @return The current attachment state of the appliance.
     * @see NatGatewayApplianceState
     */
    public final NatGatewayApplianceState attachmentState() {
        return NatGatewayApplianceState.fromValue(attachmentState);
    }

    /**
     * <p>
     * The current attachment state of the appliance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attachmentState}
     * will return {@link NatGatewayApplianceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attachmentStateAsString}.
     * </p>
     * 
     * @return The current attachment state of the appliance.
     * @see NatGatewayApplianceState
     */
    public final String attachmentStateAsString() {
        return attachmentState;
    }

    /**
     * <p>
     * The current modification state of the appliance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modificationState}
     * will return {@link NatGatewayApplianceModifyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #modificationStateAsString}.
     * </p>
     * 
     * @return The current modification state of the appliance.
     * @see NatGatewayApplianceModifyState
     */
    public final NatGatewayApplianceModifyState modificationState() {
        return NatGatewayApplianceModifyState.fromValue(modificationState);
    }

    /**
     * <p>
     * The current modification state of the appliance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modificationState}
     * will return {@link NatGatewayApplianceModifyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #modificationStateAsString}.
     * </p>
     * 
     * @return The current modification state of the appliance.
     * @see NatGatewayApplianceModifyState
     */
    public final String modificationStateAsString() {
        return modificationState;
    }

    /**
     * <p>
     * The failure code if the appliance attachment or modification operation failed.
     * </p>
     * 
     * @return The failure code if the appliance attachment or modification operation failed.
     */
    public final String failureCode() {
        return failureCode;
    }

    /**
     * <p>
     * A descriptive message explaining the failure if the appliance attachment or modification operation failed.
     * </p>
     * 
     * @return A descriptive message explaining the failure if the appliance attachment or modification operation
     *         failed.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applianceArn());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modificationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NatGatewayAttachedAppliance)) {
            return false;
        }
        NatGatewayAttachedAppliance other = (NatGatewayAttachedAppliance) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(applianceArn(), other.applianceArn())
                && Objects.equals(vpcEndpointId(), other.vpcEndpointId())
                && Objects.equals(attachmentStateAsString(), other.attachmentStateAsString())
                && Objects.equals(modificationStateAsString(), other.modificationStateAsString())
                && Objects.equals(failureCode(), other.failureCode()) && Objects.equals(failureMessage(), other.failureMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NatGatewayAttachedAppliance").add("Type", typeAsString()).add("ApplianceArn", applianceArn())
                .add("VpcEndpointId", vpcEndpointId()).add("AttachmentState", attachmentStateAsString())
                .add("ModificationState", modificationStateAsString()).add("FailureCode", failureCode())
                .add("FailureMessage", failureMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ApplianceArn":
            return Optional.ofNullable(clazz.cast(applianceArn()));
        case "VpcEndpointId":
            return Optional.ofNullable(clazz.cast(vpcEndpointId()));
        case "AttachmentState":
            return Optional.ofNullable(clazz.cast(attachmentStateAsString()));
        case "ModificationState":
            return Optional.ofNullable(clazz.cast(modificationStateAsString()));
        case "FailureCode":
            return Optional.ofNullable(clazz.cast(failureCode()));
        case "FailureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("ApplianceArn", APPLIANCE_ARN_FIELD);
        map.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        map.put("AttachmentState", ATTACHMENT_STATE_FIELD);
        map.put("ModificationState", MODIFICATION_STATE_FIELD);
        map.put("FailureCode", FAILURE_CODE_FIELD);
        map.put("FailureMessage", FAILURE_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NatGatewayAttachedAppliance, T> g) {
        return obj -> g.apply((NatGatewayAttachedAppliance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NatGatewayAttachedAppliance> {
        /**
         * <p>
         * The type of appliance attached to the NAT Gateway. For network firewall proxy functionality, this will be
         * "network-firewall-proxy".
         * </p>
         * 
         * @param type
         *        The type of appliance attached to the NAT Gateway. For network firewall proxy functionality, this will
         *        be "network-firewall-proxy".
         * @see NatGatewayApplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NatGatewayApplianceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of appliance attached to the NAT Gateway. For network firewall proxy functionality, this will be
         * "network-firewall-proxy".
         * </p>
         * 
         * @param type
         *        The type of appliance attached to the NAT Gateway. For network firewall proxy functionality, this will
         *        be "network-firewall-proxy".
         * @see NatGatewayApplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NatGatewayApplianceType
         */
        Builder type(NatGatewayApplianceType type);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the attached appliance, identifying the specific proxy or security
         * appliance resource.
         * </p>
         * 
         * @param applianceArn
         *        The Amazon Resource Name (ARN) of the attached appliance, identifying the specific proxy or security
         *        appliance resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applianceArn(String applianceArn);

        /**
         * <p>
         * The VPC endpoint ID used to route traffic from application VPCs to the proxy for inspection and filtering.
         * </p>
         * 
         * @param vpcEndpointId
         *        The VPC endpoint ID used to route traffic from application VPCs to the proxy for inspection and
         *        filtering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);

        /**
         * <p>
         * The current attachment state of the appliance.
         * </p>
         * 
         * @param attachmentState
         *        The current attachment state of the appliance.
         * @see NatGatewayApplianceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NatGatewayApplianceState
         */
        Builder attachmentState(String attachmentState);

        /**
         * <p>
         * The current attachment state of the appliance.
         * </p>
         * 
         * @param attachmentState
         *        The current attachment state of the appliance.
         * @see NatGatewayApplianceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NatGatewayApplianceState
         */
        Builder attachmentState(NatGatewayApplianceState attachmentState);

        /**
         * <p>
         * The current modification state of the appliance.
         * </p>
         * 
         * @param modificationState
         *        The current modification state of the appliance.
         * @see NatGatewayApplianceModifyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NatGatewayApplianceModifyState
         */
        Builder modificationState(String modificationState);

        /**
         * <p>
         * The current modification state of the appliance.
         * </p>
         * 
         * @param modificationState
         *        The current modification state of the appliance.
         * @see NatGatewayApplianceModifyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NatGatewayApplianceModifyState
         */
        Builder modificationState(NatGatewayApplianceModifyState modificationState);

        /**
         * <p>
         * The failure code if the appliance attachment or modification operation failed.
         * </p>
         * 
         * @param failureCode
         *        The failure code if the appliance attachment or modification operation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * A descriptive message explaining the failure if the appliance attachment or modification operation failed.
         * </p>
         * 
         * @param failureMessage
         *        A descriptive message explaining the failure if the appliance attachment or modification operation
         *        failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String applianceArn;

        private String vpcEndpointId;

        private String attachmentState;

        private String modificationState;

        private String failureCode;

        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(NatGatewayAttachedAppliance model) {
            type(model.type);
            applianceArn(model.applianceArn);
            vpcEndpointId(model.vpcEndpointId);
            attachmentState(model.attachmentState);
            modificationState(model.modificationState);
            failureCode(model.failureCode);
            failureMessage(model.failureMessage);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NatGatewayApplianceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getApplianceArn() {
            return applianceArn;
        }

        public final void setApplianceArn(String applianceArn) {
            this.applianceArn = applianceArn;
        }

        @Override
        public final Builder applianceArn(String applianceArn) {
            this.applianceArn = applianceArn;
            return this;
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final String getAttachmentState() {
            return attachmentState;
        }

        public final void setAttachmentState(String attachmentState) {
            this.attachmentState = attachmentState;
        }

        @Override
        public final Builder attachmentState(String attachmentState) {
            this.attachmentState = attachmentState;
            return this;
        }

        @Override
        public final Builder attachmentState(NatGatewayApplianceState attachmentState) {
            this.attachmentState(attachmentState == null ? null : attachmentState.toString());
            return this;
        }

        public final String getModificationState() {
            return modificationState;
        }

        public final void setModificationState(String modificationState) {
            this.modificationState = modificationState;
        }

        @Override
        public final Builder modificationState(String modificationState) {
            this.modificationState = modificationState;
            return this;
        }

        @Override
        public final Builder modificationState(NatGatewayApplianceModifyState modificationState) {
            this.modificationState(modificationState == null ? null : modificationState.toString());
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        @Override
        public NatGatewayAttachedAppliance build() {
            return new NatGatewayAttachedAppliance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
