/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupVpcAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupVpcAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.SecurityGroupVpcAssociation;

public class DescribeSecurityGroupVpcAssociationsPublisher
implements SdkPublisher<DescribeSecurityGroupVpcAssociationsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeSecurityGroupVpcAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSecurityGroupVpcAssociationsPublisher(Ec2AsyncClient client, DescribeSecurityGroupVpcAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSecurityGroupVpcAssociationsPublisher(Ec2AsyncClient client, DescribeSecurityGroupVpcAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSecurityGroupVpcAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSecurityGroupVpcAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SecurityGroupVpcAssociation> securityGroupVpcAssociations() {
        Function<DescribeSecurityGroupVpcAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityGroupVpcAssociations() != null) {
                return response.securityGroupVpcAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeSecurityGroupVpcAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeSecurityGroupVpcAssociationsResponseFetcher
    implements AsyncPageFetcher<DescribeSecurityGroupVpcAssociationsResponse> {
        private DescribeSecurityGroupVpcAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSecurityGroupVpcAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSecurityGroupVpcAssociationsResponse> nextPage(DescribeSecurityGroupVpcAssociationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSecurityGroupVpcAssociationsPublisher.this.client.describeSecurityGroupVpcAssociations(DescribeSecurityGroupVpcAssociationsPublisher.this.firstRequest);
            }
            return DescribeSecurityGroupVpcAssociationsPublisher.this.client.describeSecurityGroupVpcAssociations((DescribeSecurityGroupVpcAssociationsRequest)((Object)DescribeSecurityGroupVpcAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

