/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CreationDateConditionRequest;
import software.amazon.awssdk.services.ec2.model.DeprecationTimeConditionRequest;
import software.amazon.awssdk.services.ec2.model.ImageNameRequestListCopier;
import software.amazon.awssdk.services.ec2.model.ImageProviderRequestListCopier;
import software.amazon.awssdk.services.ec2.model.MarketplaceProductCodeRequestListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageCriterionRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageCriterionRequest> {
    private static final SdkField<List<String>> IMAGE_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImageProviders").getter(ImageCriterionRequest.getter(ImageCriterionRequest::imageProviders)).setter(ImageCriterionRequest.setter(Builder::imageProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageProvider").unmarshallLocationName("ImageProvider").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MARKETPLACE_PRODUCT_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MarketplaceProductCodes").getter(ImageCriterionRequest.getter(ImageCriterionRequest::marketplaceProductCodes)).setter(ImageCriterionRequest.setter(Builder::marketplaceProductCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarketplaceProductCode").unmarshallLocationName("MarketplaceProductCode").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> IMAGE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImageNames").getter(ImageCriterionRequest.getter(ImageCriterionRequest::imageNames)).setter(ImageCriterionRequest.setter(Builder::imageNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").unmarshallLocationName("ImageName").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<DeprecationTimeConditionRequest> DEPRECATION_TIME_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeprecationTimeCondition").getter(ImageCriterionRequest.getter(ImageCriterionRequest::deprecationTimeCondition)).setter(ImageCriterionRequest.setter(Builder::deprecationTimeCondition)).constructor(DeprecationTimeConditionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprecationTimeCondition").unmarshallLocationName("DeprecationTimeCondition").build()}).build();
    private static final SdkField<CreationDateConditionRequest> CREATION_DATE_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreationDateCondition").getter(ImageCriterionRequest.getter(ImageCriterionRequest::creationDateCondition)).setter(ImageCriterionRequest.setter(Builder::creationDateCondition)).constructor(CreationDateConditionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDateCondition").unmarshallLocationName("CreationDateCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_PROVIDERS_FIELD, MARKETPLACE_PRODUCT_CODES_FIELD, IMAGE_NAMES_FIELD, DEPRECATION_TIME_CONDITION_FIELD, CREATION_DATE_CONDITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageCriterionRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> imageProviders;
    private final List<String> marketplaceProductCodes;
    private final List<String> imageNames;
    private final DeprecationTimeConditionRequest deprecationTimeCondition;
    private final CreationDateConditionRequest creationDateCondition;

    private ImageCriterionRequest(BuilderImpl builder) {
        this.imageProviders = builder.imageProviders;
        this.marketplaceProductCodes = builder.marketplaceProductCodes;
        this.imageNames = builder.imageNames;
        this.deprecationTimeCondition = builder.deprecationTimeCondition;
        this.creationDateCondition = builder.creationDateCondition;
    }

    public final boolean hasImageProviders() {
        return this.imageProviders != null && !(this.imageProviders instanceof SdkAutoConstructList);
    }

    public final List<String> imageProviders() {
        return this.imageProviders;
    }

    public final boolean hasMarketplaceProductCodes() {
        return this.marketplaceProductCodes != null && !(this.marketplaceProductCodes instanceof SdkAutoConstructList);
    }

    public final List<String> marketplaceProductCodes() {
        return this.marketplaceProductCodes;
    }

    public final boolean hasImageNames() {
        return this.imageNames != null && !(this.imageNames instanceof SdkAutoConstructList);
    }

    public final List<String> imageNames() {
        return this.imageNames;
    }

    public final DeprecationTimeConditionRequest deprecationTimeCondition() {
        return this.deprecationTimeCondition;
    }

    public final CreationDateConditionRequest creationDateCondition() {
        return this.creationDateCondition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageProviders() ? this.imageProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMarketplaceProductCodes() ? this.marketplaceProductCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageNames() ? this.imageNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deprecationTimeCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateCondition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageCriterionRequest)) {
            return false;
        }
        ImageCriterionRequest other = (ImageCriterionRequest)obj;
        return this.hasImageProviders() == other.hasImageProviders() && Objects.equals(this.imageProviders(), other.imageProviders()) && this.hasMarketplaceProductCodes() == other.hasMarketplaceProductCodes() && Objects.equals(this.marketplaceProductCodes(), other.marketplaceProductCodes()) && this.hasImageNames() == other.hasImageNames() && Objects.equals(this.imageNames(), other.imageNames()) && Objects.equals(this.deprecationTimeCondition(), other.deprecationTimeCondition()) && Objects.equals(this.creationDateCondition(), other.creationDateCondition());
    }

    public final String toString() {
        return ToString.builder((String)"ImageCriterionRequest").add("ImageProviders", this.hasImageProviders() ? this.imageProviders() : null).add("MarketplaceProductCodes", this.hasMarketplaceProductCodes() ? this.marketplaceProductCodes() : null).add("ImageNames", this.hasImageNames() ? this.imageNames() : null).add("DeprecationTimeCondition", (Object)this.deprecationTimeCondition()).add("CreationDateCondition", (Object)this.creationDateCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageProviders": {
                return Optional.ofNullable(clazz.cast(this.imageProviders()));
            }
            case "MarketplaceProductCodes": {
                return Optional.ofNullable(clazz.cast(this.marketplaceProductCodes()));
            }
            case "ImageNames": {
                return Optional.ofNullable(clazz.cast(this.imageNames()));
            }
            case "DeprecationTimeCondition": {
                return Optional.ofNullable(clazz.cast(this.deprecationTimeCondition()));
            }
            case "CreationDateCondition": {
                return Optional.ofNullable(clazz.cast(this.creationDateCondition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ImageProvider", IMAGE_PROVIDERS_FIELD);
        map.put("MarketplaceProductCode", MARKETPLACE_PRODUCT_CODES_FIELD);
        map.put("ImageName", IMAGE_NAMES_FIELD);
        map.put("DeprecationTimeCondition", DEPRECATION_TIME_CONDITION_FIELD);
        map.put("CreationDateCondition", CREATION_DATE_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageCriterionRequest, T> g) {
        return obj -> g.apply((ImageCriterionRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> imageProviders = DefaultSdkAutoConstructList.getInstance();
        private List<String> marketplaceProductCodes = DefaultSdkAutoConstructList.getInstance();
        private List<String> imageNames = DefaultSdkAutoConstructList.getInstance();
        private DeprecationTimeConditionRequest deprecationTimeCondition;
        private CreationDateConditionRequest creationDateCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageCriterionRequest model) {
            this.imageProviders(model.imageProviders);
            this.marketplaceProductCodes(model.marketplaceProductCodes);
            this.imageNames(model.imageNames);
            this.deprecationTimeCondition(model.deprecationTimeCondition);
            this.creationDateCondition(model.creationDateCondition);
        }

        public final Collection<String> getImageProviders() {
            if (this.imageProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.imageProviders;
        }

        public final void setImageProviders(Collection<String> imageProviders) {
            this.imageProviders = ImageProviderRequestListCopier.copy(imageProviders);
        }

        @Override
        public final Builder imageProviders(Collection<String> imageProviders) {
            this.imageProviders = ImageProviderRequestListCopier.copy(imageProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageProviders(String ... imageProviders) {
            this.imageProviders(Arrays.asList(imageProviders));
            return this;
        }

        public final Collection<String> getMarketplaceProductCodes() {
            if (this.marketplaceProductCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.marketplaceProductCodes;
        }

        public final void setMarketplaceProductCodes(Collection<String> marketplaceProductCodes) {
            this.marketplaceProductCodes = MarketplaceProductCodeRequestListCopier.copy(marketplaceProductCodes);
        }

        @Override
        public final Builder marketplaceProductCodes(Collection<String> marketplaceProductCodes) {
            this.marketplaceProductCodes = MarketplaceProductCodeRequestListCopier.copy(marketplaceProductCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder marketplaceProductCodes(String ... marketplaceProductCodes) {
            this.marketplaceProductCodes(Arrays.asList(marketplaceProductCodes));
            return this;
        }

        public final Collection<String> getImageNames() {
            if (this.imageNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.imageNames;
        }

        public final void setImageNames(Collection<String> imageNames) {
            this.imageNames = ImageNameRequestListCopier.copy(imageNames);
        }

        @Override
        public final Builder imageNames(Collection<String> imageNames) {
            this.imageNames = ImageNameRequestListCopier.copy(imageNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageNames(String ... imageNames) {
            this.imageNames(Arrays.asList(imageNames));
            return this;
        }

        public final DeprecationTimeConditionRequest.Builder getDeprecationTimeCondition() {
            return this.deprecationTimeCondition != null ? this.deprecationTimeCondition.toBuilder() : null;
        }

        public final void setDeprecationTimeCondition(DeprecationTimeConditionRequest.BuilderImpl deprecationTimeCondition) {
            this.deprecationTimeCondition = deprecationTimeCondition != null ? deprecationTimeCondition.build() : null;
        }

        @Override
        public final Builder deprecationTimeCondition(DeprecationTimeConditionRequest deprecationTimeCondition) {
            this.deprecationTimeCondition = deprecationTimeCondition;
            return this;
        }

        public final CreationDateConditionRequest.Builder getCreationDateCondition() {
            return this.creationDateCondition != null ? this.creationDateCondition.toBuilder() : null;
        }

        public final void setCreationDateCondition(CreationDateConditionRequest.BuilderImpl creationDateCondition) {
            this.creationDateCondition = creationDateCondition != null ? creationDateCondition.build() : null;
        }

        @Override
        public final Builder creationDateCondition(CreationDateConditionRequest creationDateCondition) {
            this.creationDateCondition = creationDateCondition;
            return this;
        }

        public ImageCriterionRequest build() {
            return new ImageCriterionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageCriterionRequest> {
        public Builder imageProviders(Collection<String> var1);

        public Builder imageProviders(String ... var1);

        public Builder marketplaceProductCodes(Collection<String> var1);

        public Builder marketplaceProductCodes(String ... var1);

        public Builder imageNames(Collection<String> var1);

        public Builder imageNames(String ... var1);

        public Builder deprecationTimeCondition(DeprecationTimeConditionRequest var1);

        default public Builder deprecationTimeCondition(Consumer<DeprecationTimeConditionRequest.Builder> deprecationTimeCondition) {
            return this.deprecationTimeCondition((DeprecationTimeConditionRequest)((DeprecationTimeConditionRequest.Builder)DeprecationTimeConditionRequest.builder().applyMutation(deprecationTimeCondition)).build());
        }

        public Builder creationDateCondition(CreationDateConditionRequest var1);

        default public Builder creationDateCondition(Consumer<CreationDateConditionRequest.Builder> creationDateCondition) {
            return this.creationDateCondition((CreationDateConditionRequest)((CreationDateConditionRequest.Builder)CreationDateConditionRequest.builder().applyMutation(creationDateCondition)).build());
        }
    }
}

