/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverTarget;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverTargetSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIpamPrefixListResolverTargetsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeIpamPrefixListResolverTargetsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeIpamPrefixListResolverTargetsResponse.getter(DescribeIpamPrefixListResolverTargetsResponse::nextToken)).setter(DescribeIpamPrefixListResolverTargetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<IpamPrefixListResolverTarget>> IPAM_PREFIX_LIST_RESOLVER_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpamPrefixListResolverTargets").getter(DescribeIpamPrefixListResolverTargetsResponse.getter(DescribeIpamPrefixListResolverTargetsResponse::ipamPrefixListResolverTargets)).setter(DescribeIpamPrefixListResolverTargetsResponse.setter(Builder::ipamPrefixListResolverTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPrefixListResolverTargetSet").unmarshallLocationName("ipamPrefixListResolverTargetSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamPrefixListResolverTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, IPAM_PREFIX_LIST_RESOLVER_TARGETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeIpamPrefixListResolverTargetsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<IpamPrefixListResolverTarget> ipamPrefixListResolverTargets;

    private DescribeIpamPrefixListResolverTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.ipamPrefixListResolverTargets = builder.ipamPrefixListResolverTargets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasIpamPrefixListResolverTargets() {
        return this.ipamPrefixListResolverTargets != null && !(this.ipamPrefixListResolverTargets instanceof SdkAutoConstructList);
    }

    public final List<IpamPrefixListResolverTarget> ipamPrefixListResolverTargets() {
        return this.ipamPrefixListResolverTargets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpamPrefixListResolverTargets() ? this.ipamPrefixListResolverTargets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIpamPrefixListResolverTargetsResponse)) {
            return false;
        }
        DescribeIpamPrefixListResolverTargetsResponse other = (DescribeIpamPrefixListResolverTargetsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasIpamPrefixListResolverTargets() == other.hasIpamPrefixListResolverTargets() && Objects.equals(this.ipamPrefixListResolverTargets(), other.ipamPrefixListResolverTargets());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeIpamPrefixListResolverTargetsResponse").add("NextToken", (Object)this.nextToken()).add("IpamPrefixListResolverTargets", this.hasIpamPrefixListResolverTargets() ? this.ipamPrefixListResolverTargets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "IpamPrefixListResolverTargets": {
                return Optional.ofNullable(clazz.cast(this.ipamPrefixListResolverTargets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("IpamPrefixListResolverTargetSet", IPAM_PREFIX_LIST_RESOLVER_TARGETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeIpamPrefixListResolverTargetsResponse, T> g) {
        return obj -> g.apply((DescribeIpamPrefixListResolverTargetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<IpamPrefixListResolverTarget> ipamPrefixListResolverTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIpamPrefixListResolverTargetsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.ipamPrefixListResolverTargets(model.ipamPrefixListResolverTargets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<IpamPrefixListResolverTarget.Builder> getIpamPrefixListResolverTargets() {
            List<IpamPrefixListResolverTarget.Builder> result = IpamPrefixListResolverTargetSetCopier.copyToBuilder(this.ipamPrefixListResolverTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamPrefixListResolverTargets(Collection<IpamPrefixListResolverTarget.BuilderImpl> ipamPrefixListResolverTargets) {
            this.ipamPrefixListResolverTargets = IpamPrefixListResolverTargetSetCopier.copyFromBuilder(ipamPrefixListResolverTargets);
        }

        @Override
        public final Builder ipamPrefixListResolverTargets(Collection<IpamPrefixListResolverTarget> ipamPrefixListResolverTargets) {
            this.ipamPrefixListResolverTargets = IpamPrefixListResolverTargetSetCopier.copy(ipamPrefixListResolverTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamPrefixListResolverTargets(IpamPrefixListResolverTarget ... ipamPrefixListResolverTargets) {
            this.ipamPrefixListResolverTargets(Arrays.asList(ipamPrefixListResolverTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamPrefixListResolverTargets(Consumer<IpamPrefixListResolverTarget.Builder> ... ipamPrefixListResolverTargets) {
            this.ipamPrefixListResolverTargets(Stream.of(ipamPrefixListResolverTargets).map(c -> (IpamPrefixListResolverTarget)((IpamPrefixListResolverTarget.Builder)IpamPrefixListResolverTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeIpamPrefixListResolverTargetsResponse build() {
            return new DescribeIpamPrefixListResolverTargetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIpamPrefixListResolverTargetsResponse> {
        public Builder nextToken(String var1);

        public Builder ipamPrefixListResolverTargets(Collection<IpamPrefixListResolverTarget> var1);

        public Builder ipamPrefixListResolverTargets(IpamPrefixListResolverTarget ... var1);

        public Builder ipamPrefixListResolverTargets(Consumer<IpamPrefixListResolverTarget.Builder> ... var1);
    }
}

