/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AllocationIdListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.IpListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateNatGatewayAddressRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, AssociateNatGatewayAddressRequest> {
    private static final SdkField<String> NAT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NatGatewayId").getter(AssociateNatGatewayAddressRequest.getter(AssociateNatGatewayAddressRequest::natGatewayId)).setter(AssociateNatGatewayAddressRequest.setter(Builder::natGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId").unmarshallLocationName("NatGatewayId").build()}).build();
    private static final SdkField<List<String>> ALLOCATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllocationIds").getter(AssociateNatGatewayAddressRequest.getter(AssociateNatGatewayAddressRequest::allocationIds)).setter(AssociateNatGatewayAddressRequest.setter(Builder::allocationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").unmarshallLocationName("AllocationId").build(), ListTrait.builder().memberLocationName("AllocationId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").unmarshallLocationName("AllocationId").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PRIVATE_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrivateIpAddresses").getter(AssociateNatGatewayAddressRequest.getter(AssociateNatGatewayAddressRequest::privateIpAddresses)).setter(AssociateNatGatewayAddressRequest.setter(Builder::privateIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").unmarshallLocationName("PrivateIpAddress").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(AssociateNatGatewayAddressRequest.getter(AssociateNatGatewayAddressRequest::dryRun)).setter(AssociateNatGatewayAddressRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(AssociateNatGatewayAddressRequest.getter(AssociateNatGatewayAddressRequest::availabilityZone)).setter(AssociateNatGatewayAddressRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(AssociateNatGatewayAddressRequest.getter(AssociateNatGatewayAddressRequest::availabilityZoneId)).setter(AssociateNatGatewayAddressRequest.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").unmarshallLocationName("AvailabilityZoneId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAT_GATEWAY_ID_FIELD, ALLOCATION_IDS_FIELD, PRIVATE_IP_ADDRESSES_FIELD, DRY_RUN_FIELD, AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateNatGatewayAddressRequest.memberNameToFieldInitializer();
    private final String natGatewayId;
    private final List<String> allocationIds;
    private final List<String> privateIpAddresses;
    private final Boolean dryRun;
    private final String availabilityZone;
    private final String availabilityZoneId;

    private AssociateNatGatewayAddressRequest(BuilderImpl builder) {
        super(builder);
        this.natGatewayId = builder.natGatewayId;
        this.allocationIds = builder.allocationIds;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.dryRun = builder.dryRun;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
    }

    public final String natGatewayId() {
        return this.natGatewayId;
    }

    public final boolean hasAllocationIds() {
        return this.allocationIds != null && !(this.allocationIds instanceof SdkAutoConstructList);
    }

    public final List<String> allocationIds() {
        return this.allocationIds;
    }

    public final boolean hasPrivateIpAddresses() {
        return this.privateIpAddresses != null && !(this.privateIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllocationIds() ? this.allocationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateNatGatewayAddressRequest)) {
            return false;
        }
        AssociateNatGatewayAddressRequest other = (AssociateNatGatewayAddressRequest)((Object)obj);
        return Objects.equals(this.natGatewayId(), other.natGatewayId()) && this.hasAllocationIds() == other.hasAllocationIds() && Objects.equals(this.allocationIds(), other.allocationIds()) && this.hasPrivateIpAddresses() == other.hasPrivateIpAddresses() && Objects.equals(this.privateIpAddresses(), other.privateIpAddresses()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateNatGatewayAddressRequest").add("NatGatewayId", (Object)this.natGatewayId()).add("AllocationIds", this.hasAllocationIds() ? this.allocationIds() : null).add("PrivateIpAddresses", this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null).add("DryRun", (Object)this.dryRun()).add("AvailabilityZone", (Object)this.availabilityZone()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NatGatewayId": {
                return Optional.ofNullable(clazz.cast(this.natGatewayId()));
            }
            case "AllocationIds": {
                return Optional.ofNullable(clazz.cast(this.allocationIds()));
            }
            case "PrivateIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddresses()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NatGatewayId", NAT_GATEWAY_ID_FIELD);
        map.put("AllocationId", ALLOCATION_IDS_FIELD);
        map.put("PrivateIpAddress", PRIVATE_IP_ADDRESSES_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateNatGatewayAddressRequest, T> g) {
        return obj -> g.apply((AssociateNatGatewayAddressRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String natGatewayId;
        private List<String> allocationIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;
        private String availabilityZone;
        private String availabilityZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateNatGatewayAddressRequest model) {
            super(model);
            this.natGatewayId(model.natGatewayId);
            this.allocationIds(model.allocationIds);
            this.privateIpAddresses(model.privateIpAddresses);
            this.dryRun(model.dryRun);
            this.availabilityZone(model.availabilityZone);
            this.availabilityZoneId(model.availabilityZoneId);
        }

        public final String getNatGatewayId() {
            return this.natGatewayId;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final Collection<String> getAllocationIds() {
            if (this.allocationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allocationIds;
        }

        public final void setAllocationIds(Collection<String> allocationIds) {
            this.allocationIds = AllocationIdListCopier.copy(allocationIds);
        }

        @Override
        public final Builder allocationIds(Collection<String> allocationIds) {
            this.allocationIds = AllocationIdListCopier.copy(allocationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allocationIds(String ... allocationIds) {
            this.allocationIds(Arrays.asList(allocationIds));
            return this;
        }

        public final Collection<String> getPrivateIpAddresses() {
            if (this.privateIpAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.privateIpAddresses;
        }

        public final void setPrivateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = IpListCopier.copy(privateIpAddresses);
        }

        @Override
        public final Builder privateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = IpListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(String ... privateIpAddresses) {
            this.privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateNatGatewayAddressRequest build() {
            return new AssociateNatGatewayAddressRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateNatGatewayAddressRequest> {
        public Builder natGatewayId(String var1);

        public Builder allocationIds(Collection<String> var1);

        public Builder allocationIds(String ... var1);

        public Builder privateIpAddresses(Collection<String> var1);

        public Builder privateIpAddresses(String ... var1);

        public Builder dryRun(Boolean var1);

        public Builder availabilityZone(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

