/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeIpamPrefixListResolverTargetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamPrefixListResolverTargetsResponse;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverTarget;

public class DescribeIpamPrefixListResolverTargetsPublisher
implements SdkPublisher<DescribeIpamPrefixListResolverTargetsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeIpamPrefixListResolverTargetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeIpamPrefixListResolverTargetsPublisher(Ec2AsyncClient client, DescribeIpamPrefixListResolverTargetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeIpamPrefixListResolverTargetsPublisher(Ec2AsyncClient client, DescribeIpamPrefixListResolverTargetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeIpamPrefixListResolverTargetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeIpamPrefixListResolverTargetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IpamPrefixListResolverTarget> ipamPrefixListResolverTargets() {
        Function<DescribeIpamPrefixListResolverTargetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipamPrefixListResolverTargets() != null) {
                return response.ipamPrefixListResolverTargets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeIpamPrefixListResolverTargetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeIpamPrefixListResolverTargetsResponseFetcher
    implements AsyncPageFetcher<DescribeIpamPrefixListResolverTargetsResponse> {
        private DescribeIpamPrefixListResolverTargetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeIpamPrefixListResolverTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeIpamPrefixListResolverTargetsResponse> nextPage(DescribeIpamPrefixListResolverTargetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeIpamPrefixListResolverTargetsPublisher.this.client.describeIpamPrefixListResolverTargets(DescribeIpamPrefixListResolverTargetsPublisher.this.firstRequest);
            }
            return DescribeIpamPrefixListResolverTargetsPublisher.this.client.describeIpamPrefixListResolverTargets((DescribeIpamPrefixListResolverTargetsRequest)((Object)DescribeIpamPrefixListResolverTargetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

