/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.EncryptionStateValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EncryptionSupport
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EncryptionSupport> {
    private static final SdkField<String> ENCRYPTION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionState").getter(EncryptionSupport.getter(EncryptionSupport::encryptionStateAsString)).setter(EncryptionSupport.setter(Builder::encryptionState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionState").unmarshallLocationName("encryptionState").build()}).build();
    private static final SdkField<String> STATE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateMessage").getter(EncryptionSupport.getter(EncryptionSupport::stateMessage)).setter(EncryptionSupport.setter(Builder::stateMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateMessage").unmarshallLocationName("stateMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_STATE_FIELD, STATE_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EncryptionSupport.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String encryptionState;
    private final String stateMessage;

    private EncryptionSupport(BuilderImpl builder) {
        this.encryptionState = builder.encryptionState;
        this.stateMessage = builder.stateMessage;
    }

    public final EncryptionStateValue encryptionState() {
        return EncryptionStateValue.fromValue(this.encryptionState);
    }

    public final String encryptionStateAsString() {
        return this.encryptionState;
    }

    public final String stateMessage() {
        return this.stateMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionSupport)) {
            return false;
        }
        EncryptionSupport other = (EncryptionSupport)obj;
        return Objects.equals(this.encryptionStateAsString(), other.encryptionStateAsString()) && Objects.equals(this.stateMessage(), other.stateMessage());
    }

    public final String toString() {
        return ToString.builder((String)"EncryptionSupport").add("EncryptionState", (Object)this.encryptionStateAsString()).add("StateMessage", (Object)this.stateMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EncryptionState": {
                return Optional.ofNullable(clazz.cast(this.encryptionStateAsString()));
            }
            case "StateMessage": {
                return Optional.ofNullable(clazz.cast(this.stateMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("EncryptionState", ENCRYPTION_STATE_FIELD);
        map.put("StateMessage", STATE_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EncryptionSupport, T> g) {
        return obj -> g.apply((EncryptionSupport)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String encryptionState;
        private String stateMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionSupport model) {
            this.encryptionState(model.encryptionState);
            this.stateMessage(model.stateMessage);
        }

        public final String getEncryptionState() {
            return this.encryptionState;
        }

        public final void setEncryptionState(String encryptionState) {
            this.encryptionState = encryptionState;
        }

        @Override
        public final Builder encryptionState(String encryptionState) {
            this.encryptionState = encryptionState;
            return this;
        }

        @Override
        public final Builder encryptionState(EncryptionStateValue encryptionState) {
            this.encryptionState(encryptionState == null ? null : encryptionState.toString());
            return this;
        }

        public final String getStateMessage() {
            return this.stateMessage;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public EncryptionSupport build() {
            return new EncryptionSupport(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EncryptionSupport> {
        public Builder encryptionState(String var1);

        public Builder encryptionState(EncryptionStateValue var1);

        public Builder stateMessage(String var1);
    }
}

