/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolver;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIpamPrefixListResolversResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeIpamPrefixListResolversResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeIpamPrefixListResolversResponse.getter(DescribeIpamPrefixListResolversResponse::nextToken)).setter(DescribeIpamPrefixListResolversResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<IpamPrefixListResolver>> IPAM_PREFIX_LIST_RESOLVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpamPrefixListResolvers").getter(DescribeIpamPrefixListResolversResponse.getter(DescribeIpamPrefixListResolversResponse::ipamPrefixListResolvers)).setter(DescribeIpamPrefixListResolversResponse.setter(Builder::ipamPrefixListResolvers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPrefixListResolverSet").unmarshallLocationName("ipamPrefixListResolverSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamPrefixListResolver::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, IPAM_PREFIX_LIST_RESOLVERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeIpamPrefixListResolversResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<IpamPrefixListResolver> ipamPrefixListResolvers;

    private DescribeIpamPrefixListResolversResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.ipamPrefixListResolvers = builder.ipamPrefixListResolvers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasIpamPrefixListResolvers() {
        return this.ipamPrefixListResolvers != null && !(this.ipamPrefixListResolvers instanceof SdkAutoConstructList);
    }

    public final List<IpamPrefixListResolver> ipamPrefixListResolvers() {
        return this.ipamPrefixListResolvers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpamPrefixListResolvers() ? this.ipamPrefixListResolvers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIpamPrefixListResolversResponse)) {
            return false;
        }
        DescribeIpamPrefixListResolversResponse other = (DescribeIpamPrefixListResolversResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasIpamPrefixListResolvers() == other.hasIpamPrefixListResolvers() && Objects.equals(this.ipamPrefixListResolvers(), other.ipamPrefixListResolvers());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeIpamPrefixListResolversResponse").add("NextToken", (Object)this.nextToken()).add("IpamPrefixListResolvers", this.hasIpamPrefixListResolvers() ? this.ipamPrefixListResolvers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "IpamPrefixListResolvers": {
                return Optional.ofNullable(clazz.cast(this.ipamPrefixListResolvers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("IpamPrefixListResolverSet", IPAM_PREFIX_LIST_RESOLVERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeIpamPrefixListResolversResponse, T> g) {
        return obj -> g.apply((DescribeIpamPrefixListResolversResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<IpamPrefixListResolver> ipamPrefixListResolvers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIpamPrefixListResolversResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.ipamPrefixListResolvers(model.ipamPrefixListResolvers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<IpamPrefixListResolver.Builder> getIpamPrefixListResolvers() {
            List<IpamPrefixListResolver.Builder> result = IpamPrefixListResolverSetCopier.copyToBuilder(this.ipamPrefixListResolvers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamPrefixListResolvers(Collection<IpamPrefixListResolver.BuilderImpl> ipamPrefixListResolvers) {
            this.ipamPrefixListResolvers = IpamPrefixListResolverSetCopier.copyFromBuilder(ipamPrefixListResolvers);
        }

        @Override
        public final Builder ipamPrefixListResolvers(Collection<IpamPrefixListResolver> ipamPrefixListResolvers) {
            this.ipamPrefixListResolvers = IpamPrefixListResolverSetCopier.copy(ipamPrefixListResolvers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamPrefixListResolvers(IpamPrefixListResolver ... ipamPrefixListResolvers) {
            this.ipamPrefixListResolvers(Arrays.asList(ipamPrefixListResolvers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamPrefixListResolvers(Consumer<IpamPrefixListResolver.Builder> ... ipamPrefixListResolvers) {
            this.ipamPrefixListResolvers(Stream.of(ipamPrefixListResolvers).map(c -> (IpamPrefixListResolver)((IpamPrefixListResolver.Builder)IpamPrefixListResolver.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeIpamPrefixListResolversResponse build() {
            return new DescribeIpamPrefixListResolversResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIpamPrefixListResolversResponse> {
        public Builder nextToken(String var1);

        public Builder ipamPrefixListResolvers(Collection<IpamPrefixListResolver> var1);

        public Builder ipamPrefixListResolvers(IpamPrefixListResolver ... var1);

        public Builder ipamPrefixListResolvers(Consumer<IpamPrefixListResolver.Builder> ... var1);
    }
}

