/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoipAddressUsage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoipAddressUsage> {
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllocationId").getter(CoipAddressUsage.getter(CoipAddressUsage::allocationId)).setter(CoipAddressUsage.setter(Builder::allocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").unmarshallLocationName("allocationId").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(CoipAddressUsage.getter(CoipAddressUsage::awsAccountId)).setter(CoipAddressUsage.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").unmarshallLocationName("awsAccountId").build()}).build();
    private static final SdkField<String> AWS_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsService").getter(CoipAddressUsage.getter(CoipAddressUsage::awsService)).setter(CoipAddressUsage.setter(Builder::awsService)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsService").unmarshallLocationName("awsService").build()}).build();
    private static final SdkField<String> CO_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoIp").getter(CoipAddressUsage.getter(CoipAddressUsage::coIp)).setter(CoipAddressUsage.setter(Builder::coIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoIp").unmarshallLocationName("coIp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_ID_FIELD, AWS_ACCOUNT_ID_FIELD, AWS_SERVICE_FIELD, CO_IP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CoipAddressUsage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String allocationId;
    private final String awsAccountId;
    private final String awsService;
    private final String coIp;

    private CoipAddressUsage(BuilderImpl builder) {
        this.allocationId = builder.allocationId;
        this.awsAccountId = builder.awsAccountId;
        this.awsService = builder.awsService;
        this.coIp = builder.coIp;
    }

    public final String allocationId() {
        return this.allocationId;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String awsService() {
        return this.awsService;
    }

    public final String coIp() {
        return this.coIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsService());
        hashCode = 31 * hashCode + Objects.hashCode(this.coIp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoipAddressUsage)) {
            return false;
        }
        CoipAddressUsage other = (CoipAddressUsage)obj;
        return Objects.equals(this.allocationId(), other.allocationId()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.awsService(), other.awsService()) && Objects.equals(this.coIp(), other.coIp());
    }

    public final String toString() {
        return ToString.builder((String)"CoipAddressUsage").add("AllocationId", (Object)this.allocationId()).add("AwsAccountId", (Object)this.awsAccountId()).add("AwsService", (Object)this.awsService()).add("CoIp", (Object)this.coIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationId": {
                return Optional.ofNullable(clazz.cast(this.allocationId()));
            }
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "AwsService": {
                return Optional.ofNullable(clazz.cast(this.awsService()));
            }
            case "CoIp": {
                return Optional.ofNullable(clazz.cast(this.coIp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AllocationId", ALLOCATION_ID_FIELD);
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("AwsService", AWS_SERVICE_FIELD);
        map.put("CoIp", CO_IP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CoipAddressUsage, T> g) {
        return obj -> g.apply((CoipAddressUsage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String allocationId;
        private String awsAccountId;
        private String awsService;
        private String coIp;

        private BuilderImpl() {
        }

        private BuilderImpl(CoipAddressUsage model) {
            this.allocationId(model.allocationId);
            this.awsAccountId(model.awsAccountId);
            this.awsService(model.awsService);
            this.coIp(model.coIp);
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsService() {
            return this.awsService;
        }

        public final void setAwsService(String awsService) {
            this.awsService = awsService;
        }

        @Override
        public final Builder awsService(String awsService) {
            this.awsService = awsService;
            return this;
        }

        public final String getCoIp() {
            return this.coIp;
        }

        public final void setCoIp(String coIp) {
            this.coIp = coIp;
        }

        @Override
        public final Builder coIp(String coIp) {
            this.coIp = coIp;
            return this;
        }

        public CoipAddressUsage build() {
            return new CoipAddressUsage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoipAddressUsage> {
        public Builder allocationId(String var1);

        public Builder awsAccountId(String var1);

        public Builder awsService(String var1);

        public Builder coIp(String var1);
    }
}

