/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.VpcEncryptionControl;
import software.amazon.awssdk.services.ec2.model.VpcEncryptionControlListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpcEncryptionControlsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVpcEncryptionControlsResponse> {
    private static final SdkField<List<VpcEncryptionControl>> VPC_ENCRYPTION_CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcEncryptionControls").getter(DescribeVpcEncryptionControlsResponse.getter(DescribeVpcEncryptionControlsResponse::vpcEncryptionControls)).setter(DescribeVpcEncryptionControlsResponse.setter(Builder::vpcEncryptionControls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEncryptionControlSet").unmarshallLocationName("vpcEncryptionControlSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcEncryptionControl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeVpcEncryptionControlsResponse.getter(DescribeVpcEncryptionControlsResponse::nextToken)).setter(DescribeVpcEncryptionControlsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENCRYPTION_CONTROLS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeVpcEncryptionControlsResponse.memberNameToFieldInitializer();
    private final List<VpcEncryptionControl> vpcEncryptionControls;
    private final String nextToken;

    private DescribeVpcEncryptionControlsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcEncryptionControls = builder.vpcEncryptionControls;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVpcEncryptionControls() {
        return this.vpcEncryptionControls != null && !(this.vpcEncryptionControls instanceof SdkAutoConstructList);
    }

    public final List<VpcEncryptionControl> vpcEncryptionControls() {
        return this.vpcEncryptionControls;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcEncryptionControls() ? this.vpcEncryptionControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEncryptionControlsResponse)) {
            return false;
        }
        DescribeVpcEncryptionControlsResponse other = (DescribeVpcEncryptionControlsResponse)((Object)obj);
        return this.hasVpcEncryptionControls() == other.hasVpcEncryptionControls() && Objects.equals(this.vpcEncryptionControls(), other.vpcEncryptionControls()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVpcEncryptionControlsResponse").add("VpcEncryptionControls", this.hasVpcEncryptionControls() ? this.vpcEncryptionControls() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcEncryptionControls": {
                return Optional.ofNullable(clazz.cast(this.vpcEncryptionControls()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VpcEncryptionControlSet", VPC_ENCRYPTION_CONTROLS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcEncryptionControlsResponse, T> g) {
        return obj -> g.apply((DescribeVpcEncryptionControlsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<VpcEncryptionControl> vpcEncryptionControls = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEncryptionControlsResponse model) {
            super(model);
            this.vpcEncryptionControls(model.vpcEncryptionControls);
            this.nextToken(model.nextToken);
        }

        public final List<VpcEncryptionControl.Builder> getVpcEncryptionControls() {
            List<VpcEncryptionControl.Builder> result = VpcEncryptionControlListCopier.copyToBuilder(this.vpcEncryptionControls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcEncryptionControls(Collection<VpcEncryptionControl.BuilderImpl> vpcEncryptionControls) {
            this.vpcEncryptionControls = VpcEncryptionControlListCopier.copyFromBuilder(vpcEncryptionControls);
        }

        @Override
        public final Builder vpcEncryptionControls(Collection<VpcEncryptionControl> vpcEncryptionControls) {
            this.vpcEncryptionControls = VpcEncryptionControlListCopier.copy(vpcEncryptionControls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEncryptionControls(VpcEncryptionControl ... vpcEncryptionControls) {
            this.vpcEncryptionControls(Arrays.asList(vpcEncryptionControls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEncryptionControls(Consumer<VpcEncryptionControl.Builder> ... vpcEncryptionControls) {
            this.vpcEncryptionControls(Stream.of(vpcEncryptionControls).map(c -> (VpcEncryptionControl)((VpcEncryptionControl.Builder)VpcEncryptionControl.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeVpcEncryptionControlsResponse build() {
            return new DescribeVpcEncryptionControlsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVpcEncryptionControlsResponse> {
        public Builder vpcEncryptionControls(Collection<VpcEncryptionControl> var1);

        public Builder vpcEncryptionControls(VpcEncryptionControl ... var1);

        public Builder vpcEncryptionControls(Consumer<VpcEncryptionControl.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

