/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDefaultCreditSpecificationResponse extends Ec2Response implements
        ToCopyableBuilder<GetDefaultCreditSpecificationResponse.Builder, GetDefaultCreditSpecificationResponse> {
    private static final SdkField<InstanceFamilyCreditSpecification> INSTANCE_FAMILY_CREDIT_SPECIFICATION_FIELD = SdkField
            .<InstanceFamilyCreditSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceFamilyCreditSpecification")
            .getter(getter(GetDefaultCreditSpecificationResponse::instanceFamilyCreditSpecification))
            .setter(setter(Builder::instanceFamilyCreditSpecification))
            .constructor(InstanceFamilyCreditSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamilyCreditSpecification")
                    .unmarshallLocationName("instanceFamilyCreditSpecification").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INSTANCE_FAMILY_CREDIT_SPECIFICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final InstanceFamilyCreditSpecification instanceFamilyCreditSpecification;

    private GetDefaultCreditSpecificationResponse(BuilderImpl builder) {
        super(builder);
        this.instanceFamilyCreditSpecification = builder.instanceFamilyCreditSpecification;
    }

    /**
     * <p>
     * The default credit option for CPU usage of the instance family.
     * </p>
     * 
     * @return The default credit option for CPU usage of the instance family.
     */
    public final InstanceFamilyCreditSpecification instanceFamilyCreditSpecification() {
        return instanceFamilyCreditSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceFamilyCreditSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDefaultCreditSpecificationResponse)) {
            return false;
        }
        GetDefaultCreditSpecificationResponse other = (GetDefaultCreditSpecificationResponse) obj;
        return Objects.equals(instanceFamilyCreditSpecification(), other.instanceFamilyCreditSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDefaultCreditSpecificationResponse")
                .add("InstanceFamilyCreditSpecification", instanceFamilyCreditSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceFamilyCreditSpecification":
            return Optional.ofNullable(clazz.cast(instanceFamilyCreditSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceFamilyCreditSpecification", INSTANCE_FAMILY_CREDIT_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDefaultCreditSpecificationResponse, T> g) {
        return obj -> g.apply((GetDefaultCreditSpecificationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDefaultCreditSpecificationResponse> {
        /**
         * <p>
         * The default credit option for CPU usage of the instance family.
         * </p>
         * 
         * @param instanceFamilyCreditSpecification
         *        The default credit option for CPU usage of the instance family.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFamilyCreditSpecification(InstanceFamilyCreditSpecification instanceFamilyCreditSpecification);

        /**
         * <p>
         * The default credit option for CPU usage of the instance family.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InstanceFamilyCreditSpecification.Builder} avoiding the need to create one manually via
         * {@link InstanceFamilyCreditSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceFamilyCreditSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #instanceFamilyCreditSpecification(InstanceFamilyCreditSpecification)}.
         * 
         * @param instanceFamilyCreditSpecification
         *        a consumer that will call methods on {@link InstanceFamilyCreditSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceFamilyCreditSpecification(InstanceFamilyCreditSpecification)
         */
        default Builder instanceFamilyCreditSpecification(
                Consumer<InstanceFamilyCreditSpecification.Builder> instanceFamilyCreditSpecification) {
            return instanceFamilyCreditSpecification(InstanceFamilyCreditSpecification.builder()
                    .applyMutation(instanceFamilyCreditSpecification).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private InstanceFamilyCreditSpecification instanceFamilyCreditSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDefaultCreditSpecificationResponse model) {
            super(model);
            instanceFamilyCreditSpecification(model.instanceFamilyCreditSpecification);
        }

        public final InstanceFamilyCreditSpecification.Builder getInstanceFamilyCreditSpecification() {
            return instanceFamilyCreditSpecification != null ? instanceFamilyCreditSpecification.toBuilder() : null;
        }

        public final void setInstanceFamilyCreditSpecification(
                InstanceFamilyCreditSpecification.BuilderImpl instanceFamilyCreditSpecification) {
            this.instanceFamilyCreditSpecification = instanceFamilyCreditSpecification != null ? instanceFamilyCreditSpecification
                    .build() : null;
        }

        @Override
        public final Builder instanceFamilyCreditSpecification(InstanceFamilyCreditSpecification instanceFamilyCreditSpecification) {
            this.instanceFamilyCreditSpecification = instanceFamilyCreditSpecification;
            return this;
        }

        @Override
        public GetDefaultCreditSpecificationResponse build() {
            return new GetDefaultCreditSpecificationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
