/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIpamPrefixListResolverTargetResponse extends Ec2Response implements
        ToCopyableBuilder<CreateIpamPrefixListResolverTargetResponse.Builder, CreateIpamPrefixListResolverTargetResponse> {
    private static final SdkField<IpamPrefixListResolverTarget> IPAM_PREFIX_LIST_RESOLVER_TARGET_FIELD = SdkField
            .<IpamPrefixListResolverTarget> builder(MarshallingType.SDK_POJO)
            .memberName("IpamPrefixListResolverTarget")
            .getter(getter(CreateIpamPrefixListResolverTargetResponse::ipamPrefixListResolverTarget))
            .setter(setter(Builder::ipamPrefixListResolverTarget))
            .constructor(IpamPrefixListResolverTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPrefixListResolverTarget")
                    .unmarshallLocationName("ipamPrefixListResolverTarget").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IPAM_PREFIX_LIST_RESOLVER_TARGET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final IpamPrefixListResolverTarget ipamPrefixListResolverTarget;

    private CreateIpamPrefixListResolverTargetResponse(BuilderImpl builder) {
        super(builder);
        this.ipamPrefixListResolverTarget = builder.ipamPrefixListResolverTarget;
    }

    /**
     * <p>
     * Information about the IPAM prefix list resolver target that was created.
     * </p>
     * 
     * @return Information about the IPAM prefix list resolver target that was created.
     */
    public final IpamPrefixListResolverTarget ipamPrefixListResolverTarget() {
        return ipamPrefixListResolverTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipamPrefixListResolverTarget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpamPrefixListResolverTargetResponse)) {
            return false;
        }
        CreateIpamPrefixListResolverTargetResponse other = (CreateIpamPrefixListResolverTargetResponse) obj;
        return Objects.equals(ipamPrefixListResolverTarget(), other.ipamPrefixListResolverTarget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIpamPrefixListResolverTargetResponse")
                .add("IpamPrefixListResolverTarget", ipamPrefixListResolverTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpamPrefixListResolverTarget":
            return Optional.ofNullable(clazz.cast(ipamPrefixListResolverTarget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IpamPrefixListResolverTarget", IPAM_PREFIX_LIST_RESOLVER_TARGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIpamPrefixListResolverTargetResponse, T> g) {
        return obj -> g.apply((CreateIpamPrefixListResolverTargetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateIpamPrefixListResolverTargetResponse> {
        /**
         * <p>
         * Information about the IPAM prefix list resolver target that was created.
         * </p>
         * 
         * @param ipamPrefixListResolverTarget
         *        Information about the IPAM prefix list resolver target that was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPrefixListResolverTarget(IpamPrefixListResolverTarget ipamPrefixListResolverTarget);

        /**
         * <p>
         * Information about the IPAM prefix list resolver target that was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link IpamPrefixListResolverTarget.Builder}
         * avoiding the need to create one manually via {@link IpamPrefixListResolverTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IpamPrefixListResolverTarget.Builder#build()} is called
         * immediately and its result is passed to {@link #ipamPrefixListResolverTarget(IpamPrefixListResolverTarget)}.
         * 
         * @param ipamPrefixListResolverTarget
         *        a consumer that will call methods on {@link IpamPrefixListResolverTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipamPrefixListResolverTarget(IpamPrefixListResolverTarget)
         */
        default Builder ipamPrefixListResolverTarget(Consumer<IpamPrefixListResolverTarget.Builder> ipamPrefixListResolverTarget) {
            return ipamPrefixListResolverTarget(IpamPrefixListResolverTarget.builder()
                    .applyMutation(ipamPrefixListResolverTarget).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private IpamPrefixListResolverTarget ipamPrefixListResolverTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIpamPrefixListResolverTargetResponse model) {
            super(model);
            ipamPrefixListResolverTarget(model.ipamPrefixListResolverTarget);
        }

        public final IpamPrefixListResolverTarget.Builder getIpamPrefixListResolverTarget() {
            return ipamPrefixListResolverTarget != null ? ipamPrefixListResolverTarget.toBuilder() : null;
        }

        public final void setIpamPrefixListResolverTarget(IpamPrefixListResolverTarget.BuilderImpl ipamPrefixListResolverTarget) {
            this.ipamPrefixListResolverTarget = ipamPrefixListResolverTarget != null ? ipamPrefixListResolverTarget.build()
                    : null;
        }

        @Override
        public final Builder ipamPrefixListResolverTarget(IpamPrefixListResolverTarget ipamPrefixListResolverTarget) {
            this.ipamPrefixListResolverTarget = ipamPrefixListResolverTarget;
            return this;
        }

        @Override
        public CreateIpamPrefixListResolverTargetResponse build() {
            return new CreateIpamPrefixListResolverTargetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
