/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyTransitGatewayMeteringPolicyRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyTransitGatewayMeteringPolicyRequest.Builder, ModifyTransitGatewayMeteringPolicyRequest> {
    private static final SdkField<String> TRANSIT_GATEWAY_METERING_POLICY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayMeteringPolicyId")
            .getter(getter(ModifyTransitGatewayMeteringPolicyRequest::transitGatewayMeteringPolicyId))
            .setter(setter(Builder::transitGatewayMeteringPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayMeteringPolicyId")
                    .unmarshallLocationName("TransitGatewayMeteringPolicyId").build()).build();

    private static final SdkField<List<String>> ADD_MIDDLEBOX_ATTACHMENT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddMiddleboxAttachmentIds")
            .getter(getter(ModifyTransitGatewayMeteringPolicyRequest::addMiddleboxAttachmentIds))
            .setter(setter(Builder::addMiddleboxAttachmentIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddMiddleboxAttachmentId")
                    .unmarshallLocationName("AddMiddleboxAttachmentId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> REMOVE_MIDDLEBOX_ATTACHMENT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveMiddleboxAttachmentIds")
            .getter(getter(ModifyTransitGatewayMeteringPolicyRequest::removeMiddleboxAttachmentIds))
            .setter(setter(Builder::removeMiddleboxAttachmentIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveMiddleboxAttachmentId")
                    .unmarshallLocationName("RemoveMiddleboxAttachmentId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyTransitGatewayMeteringPolicyRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_METERING_POLICY_ID_FIELD, ADD_MIDDLEBOX_ATTACHMENT_IDS_FIELD, REMOVE_MIDDLEBOX_ATTACHMENT_IDS_FIELD,
            DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String transitGatewayMeteringPolicyId;

    private final List<String> addMiddleboxAttachmentIds;

    private final List<String> removeMiddleboxAttachmentIds;

    private final Boolean dryRun;

    private ModifyTransitGatewayMeteringPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.transitGatewayMeteringPolicyId = builder.transitGatewayMeteringPolicyId;
        this.addMiddleboxAttachmentIds = builder.addMiddleboxAttachmentIds;
        this.removeMiddleboxAttachmentIds = builder.removeMiddleboxAttachmentIds;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The ID of the transit gateway metering policy to modify.
     * </p>
     * 
     * @return The ID of the transit gateway metering policy to modify.
     */
    public final String transitGatewayMeteringPolicyId() {
        return transitGatewayMeteringPolicyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddMiddleboxAttachmentIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAddMiddleboxAttachmentIds() {
        return addMiddleboxAttachmentIds != null && !(addMiddleboxAttachmentIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of middlebox attachments to add to the metering policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddMiddleboxAttachmentIds} method.
     * </p>
     * 
     * @return The IDs of middlebox attachments to add to the metering policy.
     */
    public final List<String> addMiddleboxAttachmentIds() {
        return addMiddleboxAttachmentIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveMiddleboxAttachmentIds property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRemoveMiddleboxAttachmentIds() {
        return removeMiddleboxAttachmentIds != null && !(removeMiddleboxAttachmentIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of middlebox attachments to remove from the metering policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveMiddleboxAttachmentIds} method.
     * </p>
     * 
     * @return The IDs of middlebox attachments to remove from the metering policy.
     */
    public final List<String> removeMiddleboxAttachmentIds() {
        return removeMiddleboxAttachmentIds;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayMeteringPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddMiddleboxAttachmentIds() ? addMiddleboxAttachmentIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveMiddleboxAttachmentIds() ? removeMiddleboxAttachmentIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTransitGatewayMeteringPolicyRequest)) {
            return false;
        }
        ModifyTransitGatewayMeteringPolicyRequest other = (ModifyTransitGatewayMeteringPolicyRequest) obj;
        return Objects.equals(transitGatewayMeteringPolicyId(), other.transitGatewayMeteringPolicyId())
                && hasAddMiddleboxAttachmentIds() == other.hasAddMiddleboxAttachmentIds()
                && Objects.equals(addMiddleboxAttachmentIds(), other.addMiddleboxAttachmentIds())
                && hasRemoveMiddleboxAttachmentIds() == other.hasRemoveMiddleboxAttachmentIds()
                && Objects.equals(removeMiddleboxAttachmentIds(), other.removeMiddleboxAttachmentIds())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyTransitGatewayMeteringPolicyRequest")
                .add("TransitGatewayMeteringPolicyId", transitGatewayMeteringPolicyId())
                .add("AddMiddleboxAttachmentIds", hasAddMiddleboxAttachmentIds() ? addMiddleboxAttachmentIds() : null)
                .add("RemoveMiddleboxAttachmentIds", hasRemoveMiddleboxAttachmentIds() ? removeMiddleboxAttachmentIds() : null)
                .add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayMeteringPolicyId":
            return Optional.ofNullable(clazz.cast(transitGatewayMeteringPolicyId()));
        case "AddMiddleboxAttachmentIds":
            return Optional.ofNullable(clazz.cast(addMiddleboxAttachmentIds()));
        case "RemoveMiddleboxAttachmentIds":
            return Optional.ofNullable(clazz.cast(removeMiddleboxAttachmentIds()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TransitGatewayMeteringPolicyId", TRANSIT_GATEWAY_METERING_POLICY_ID_FIELD);
        map.put("AddMiddleboxAttachmentId", ADD_MIDDLEBOX_ATTACHMENT_IDS_FIELD);
        map.put("RemoveMiddleboxAttachmentId", REMOVE_MIDDLEBOX_ATTACHMENT_IDS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyTransitGatewayMeteringPolicyRequest, T> g) {
        return obj -> g.apply((ModifyTransitGatewayMeteringPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyTransitGatewayMeteringPolicyRequest> {
        /**
         * <p>
         * The ID of the transit gateway metering policy to modify.
         * </p>
         * 
         * @param transitGatewayMeteringPolicyId
         *        The ID of the transit gateway metering policy to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayMeteringPolicyId(String transitGatewayMeteringPolicyId);

        /**
         * <p>
         * The IDs of middlebox attachments to add to the metering policy.
         * </p>
         * 
         * @param addMiddleboxAttachmentIds
         *        The IDs of middlebox attachments to add to the metering policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addMiddleboxAttachmentIds(Collection<String> addMiddleboxAttachmentIds);

        /**
         * <p>
         * The IDs of middlebox attachments to add to the metering policy.
         * </p>
         * 
         * @param addMiddleboxAttachmentIds
         *        The IDs of middlebox attachments to add to the metering policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addMiddleboxAttachmentIds(String... addMiddleboxAttachmentIds);

        /**
         * <p>
         * The IDs of middlebox attachments to remove from the metering policy.
         * </p>
         * 
         * @param removeMiddleboxAttachmentIds
         *        The IDs of middlebox attachments to remove from the metering policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeMiddleboxAttachmentIds(Collection<String> removeMiddleboxAttachmentIds);

        /**
         * <p>
         * The IDs of middlebox attachments to remove from the metering policy.
         * </p>
         * 
         * @param removeMiddleboxAttachmentIds
         *        The IDs of middlebox attachments to remove from the metering policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeMiddleboxAttachmentIds(String... removeMiddleboxAttachmentIds);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String transitGatewayMeteringPolicyId;

        private List<String> addMiddleboxAttachmentIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeMiddleboxAttachmentIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTransitGatewayMeteringPolicyRequest model) {
            super(model);
            transitGatewayMeteringPolicyId(model.transitGatewayMeteringPolicyId);
            addMiddleboxAttachmentIds(model.addMiddleboxAttachmentIds);
            removeMiddleboxAttachmentIds(model.removeMiddleboxAttachmentIds);
            dryRun(model.dryRun);
        }

        public final String getTransitGatewayMeteringPolicyId() {
            return transitGatewayMeteringPolicyId;
        }

        public final void setTransitGatewayMeteringPolicyId(String transitGatewayMeteringPolicyId) {
            this.transitGatewayMeteringPolicyId = transitGatewayMeteringPolicyId;
        }

        @Override
        public final Builder transitGatewayMeteringPolicyId(String transitGatewayMeteringPolicyId) {
            this.transitGatewayMeteringPolicyId = transitGatewayMeteringPolicyId;
            return this;
        }

        public final Collection<String> getAddMiddleboxAttachmentIds() {
            if (addMiddleboxAttachmentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return addMiddleboxAttachmentIds;
        }

        public final void setAddMiddleboxAttachmentIds(Collection<String> addMiddleboxAttachmentIds) {
            this.addMiddleboxAttachmentIds = TransitGatewayAttachmentIdStringListCopier.copy(addMiddleboxAttachmentIds);
        }

        @Override
        public final Builder addMiddleboxAttachmentIds(Collection<String> addMiddleboxAttachmentIds) {
            this.addMiddleboxAttachmentIds = TransitGatewayAttachmentIdStringListCopier.copy(addMiddleboxAttachmentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addMiddleboxAttachmentIds(String... addMiddleboxAttachmentIds) {
            addMiddleboxAttachmentIds(Arrays.asList(addMiddleboxAttachmentIds));
            return this;
        }

        public final Collection<String> getRemoveMiddleboxAttachmentIds() {
            if (removeMiddleboxAttachmentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return removeMiddleboxAttachmentIds;
        }

        public final void setRemoveMiddleboxAttachmentIds(Collection<String> removeMiddleboxAttachmentIds) {
            this.removeMiddleboxAttachmentIds = TransitGatewayAttachmentIdStringListCopier.copy(removeMiddleboxAttachmentIds);
        }

        @Override
        public final Builder removeMiddleboxAttachmentIds(Collection<String> removeMiddleboxAttachmentIds) {
            this.removeMiddleboxAttachmentIds = TransitGatewayAttachmentIdStringListCopier.copy(removeMiddleboxAttachmentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeMiddleboxAttachmentIds(String... removeMiddleboxAttachmentIds) {
            removeMiddleboxAttachmentIds(Arrays.asList(removeMiddleboxAttachmentIds));
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyTransitGatewayMeteringPolicyRequest build() {
            return new ModifyTransitGatewayMeteringPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
