/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEnabledIpamPolicyResponse extends Ec2Response implements
        ToCopyableBuilder<GetEnabledIpamPolicyResponse.Builder, GetEnabledIpamPolicyResponse> {
    private static final SdkField<Boolean> IPAM_POLICY_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IpamPolicyEnabled")
            .getter(getter(GetEnabledIpamPolicyResponse::ipamPolicyEnabled))
            .setter(setter(Builder::ipamPolicyEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPolicyEnabled")
                    .unmarshallLocationName("ipamPolicyEnabled").build()).build();

    private static final SdkField<String> IPAM_POLICY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamPolicyId")
            .getter(getter(GetEnabledIpamPolicyResponse::ipamPolicyId))
            .setter(setter(Builder::ipamPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPolicyId")
                    .unmarshallLocationName("ipamPolicyId").build()).build();

    private static final SdkField<String> MANAGED_BY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ManagedBy")
            .getter(getter(GetEnabledIpamPolicyResponse::managedByAsString))
            .setter(setter(Builder::managedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedBy")
                    .unmarshallLocationName("managedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_POLICY_ENABLED_FIELD,
            IPAM_POLICY_ID_FIELD, MANAGED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean ipamPolicyEnabled;

    private final String ipamPolicyId;

    private final String managedBy;

    private GetEnabledIpamPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.ipamPolicyEnabled = builder.ipamPolicyEnabled;
        this.ipamPolicyId = builder.ipamPolicyId;
        this.managedBy = builder.managedBy;
    }

    /**
     * <p>
     * Indicates whether the IPAM policy is enabled.
     * </p>
     * 
     * @return Indicates whether the IPAM policy is enabled.
     */
    public final Boolean ipamPolicyEnabled() {
        return ipamPolicyEnabled;
    }

    /**
     * <p>
     * The ID of the enabled IPAM policy.
     * </p>
     * 
     * @return The ID of the enabled IPAM policy.
     */
    public final String ipamPolicyId() {
        return ipamPolicyId;
    }

    /**
     * <p>
     * The entity that manages the IPAM policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #managedBy} will
     * return {@link IpamPolicyManagedBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #managedByAsString}.
     * </p>
     * 
     * @return The entity that manages the IPAM policy.
     * @see IpamPolicyManagedBy
     */
    public final IpamPolicyManagedBy managedBy() {
        return IpamPolicyManagedBy.fromValue(managedBy);
    }

    /**
     * <p>
     * The entity that manages the IPAM policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #managedBy} will
     * return {@link IpamPolicyManagedBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #managedByAsString}.
     * </p>
     * 
     * @return The entity that manages the IPAM policy.
     * @see IpamPolicyManagedBy
     */
    public final String managedByAsString() {
        return managedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipamPolicyEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(ipamPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(managedByAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnabledIpamPolicyResponse)) {
            return false;
        }
        GetEnabledIpamPolicyResponse other = (GetEnabledIpamPolicyResponse) obj;
        return Objects.equals(ipamPolicyEnabled(), other.ipamPolicyEnabled())
                && Objects.equals(ipamPolicyId(), other.ipamPolicyId())
                && Objects.equals(managedByAsString(), other.managedByAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEnabledIpamPolicyResponse").add("IpamPolicyEnabled", ipamPolicyEnabled())
                .add("IpamPolicyId", ipamPolicyId()).add("ManagedBy", managedByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpamPolicyEnabled":
            return Optional.ofNullable(clazz.cast(ipamPolicyEnabled()));
        case "IpamPolicyId":
            return Optional.ofNullable(clazz.cast(ipamPolicyId()));
        case "ManagedBy":
            return Optional.ofNullable(clazz.cast(managedByAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IpamPolicyEnabled", IPAM_POLICY_ENABLED_FIELD);
        map.put("IpamPolicyId", IPAM_POLICY_ID_FIELD);
        map.put("ManagedBy", MANAGED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEnabledIpamPolicyResponse, T> g) {
        return obj -> g.apply((GetEnabledIpamPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetEnabledIpamPolicyResponse> {
        /**
         * <p>
         * Indicates whether the IPAM policy is enabled.
         * </p>
         * 
         * @param ipamPolicyEnabled
         *        Indicates whether the IPAM policy is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPolicyEnabled(Boolean ipamPolicyEnabled);

        /**
         * <p>
         * The ID of the enabled IPAM policy.
         * </p>
         * 
         * @param ipamPolicyId
         *        The ID of the enabled IPAM policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPolicyId(String ipamPolicyId);

        /**
         * <p>
         * The entity that manages the IPAM policy.
         * </p>
         * 
         * @param managedBy
         *        The entity that manages the IPAM policy.
         * @see IpamPolicyManagedBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamPolicyManagedBy
         */
        Builder managedBy(String managedBy);

        /**
         * <p>
         * The entity that manages the IPAM policy.
         * </p>
         * 
         * @param managedBy
         *        The entity that manages the IPAM policy.
         * @see IpamPolicyManagedBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamPolicyManagedBy
         */
        Builder managedBy(IpamPolicyManagedBy managedBy);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private Boolean ipamPolicyEnabled;

        private String ipamPolicyId;

        private String managedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnabledIpamPolicyResponse model) {
            super(model);
            ipamPolicyEnabled(model.ipamPolicyEnabled);
            ipamPolicyId(model.ipamPolicyId);
            managedBy(model.managedBy);
        }

        public final Boolean getIpamPolicyEnabled() {
            return ipamPolicyEnabled;
        }

        public final void setIpamPolicyEnabled(Boolean ipamPolicyEnabled) {
            this.ipamPolicyEnabled = ipamPolicyEnabled;
        }

        @Override
        public final Builder ipamPolicyEnabled(Boolean ipamPolicyEnabled) {
            this.ipamPolicyEnabled = ipamPolicyEnabled;
            return this;
        }

        public final String getIpamPolicyId() {
            return ipamPolicyId;
        }

        public final void setIpamPolicyId(String ipamPolicyId) {
            this.ipamPolicyId = ipamPolicyId;
        }

        @Override
        public final Builder ipamPolicyId(String ipamPolicyId) {
            this.ipamPolicyId = ipamPolicyId;
            return this;
        }

        public final String getManagedBy() {
            return managedBy;
        }

        public final void setManagedBy(String managedBy) {
            this.managedBy = managedBy;
        }

        @Override
        public final Builder managedBy(String managedBy) {
            this.managedBy = managedBy;
            return this;
        }

        @Override
        public final Builder managedBy(IpamPolicyManagedBy managedBy) {
            this.managedBy(managedBy == null ? null : managedBy.toString());
            return this;
        }

        @Override
        public GetEnabledIpamPolicyResponse build() {
            return new GetEnabledIpamPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
