/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class DeleteLaunchTemplateVersionsResponseErrorSetCopier {
    static List<DeleteLaunchTemplateVersionsResponseErrorItem> copy(
            Collection<? extends DeleteLaunchTemplateVersionsResponseErrorItem> deleteLaunchTemplateVersionsResponseErrorSetParam) {
        List<DeleteLaunchTemplateVersionsResponseErrorItem> list;
        if (deleteLaunchTemplateVersionsResponseErrorSetParam == null
                || deleteLaunchTemplateVersionsResponseErrorSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DeleteLaunchTemplateVersionsResponseErrorItem> modifiableList = new ArrayList<>(
                    deleteLaunchTemplateVersionsResponseErrorSetParam.size());
            deleteLaunchTemplateVersionsResponseErrorSetParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DeleteLaunchTemplateVersionsResponseErrorItem> copyFromBuilder(
            Collection<? extends DeleteLaunchTemplateVersionsResponseErrorItem.Builder> deleteLaunchTemplateVersionsResponseErrorSetParam) {
        List<DeleteLaunchTemplateVersionsResponseErrorItem> list;
        if (deleteLaunchTemplateVersionsResponseErrorSetParam == null
                || deleteLaunchTemplateVersionsResponseErrorSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DeleteLaunchTemplateVersionsResponseErrorItem> modifiableList = new ArrayList<>(
                    deleteLaunchTemplateVersionsResponseErrorSetParam.size());
            deleteLaunchTemplateVersionsResponseErrorSetParam.forEach(entry -> {
                DeleteLaunchTemplateVersionsResponseErrorItem member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DeleteLaunchTemplateVersionsResponseErrorItem.Builder> copyToBuilder(
            Collection<? extends DeleteLaunchTemplateVersionsResponseErrorItem> deleteLaunchTemplateVersionsResponseErrorSetParam) {
        List<DeleteLaunchTemplateVersionsResponseErrorItem.Builder> list;
        if (deleteLaunchTemplateVersionsResponseErrorSetParam == null
                || deleteLaunchTemplateVersionsResponseErrorSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DeleteLaunchTemplateVersionsResponseErrorItem.Builder> modifiableList = new ArrayList<>(
                    deleteLaunchTemplateVersionsResponseErrorSetParam.size());
            deleteLaunchTemplateVersionsResponseErrorSetParam.forEach(entry -> {
                DeleteLaunchTemplateVersionsResponseErrorItem.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
