/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AddressFamily;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverState;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverVersionCreationStatus;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpamPrefixListResolver
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpamPrefixListResolver> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(IpamPrefixListResolver.getter(IpamPrefixListResolver::ownerId)).setter(IpamPrefixListResolver.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> IPAM_PREFIX_LIST_RESOLVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPrefixListResolverId").getter(IpamPrefixListResolver.getter(IpamPrefixListResolver::ipamPrefixListResolverId)).setter(IpamPrefixListResolver.setter(Builder::ipamPrefixListResolverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPrefixListResolverId").unmarshallLocationName("ipamPrefixListResolverId").build()}).build();
    private static final SdkField<String> IPAM_PREFIX_LIST_RESOLVER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPrefixListResolverArn").getter(IpamPrefixListResolver.getter(IpamPrefixListResolver::ipamPrefixListResolverArn)).setter(IpamPrefixListResolver.setter(Builder::ipamPrefixListResolverArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPrefixListResolverArn").unmarshallLocationName("ipamPrefixListResolverArn").build()}).build();
    private static final SdkField<String> IPAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamArn").getter(IpamPrefixListResolver.getter(IpamPrefixListResolver::ipamArn)).setter(IpamPrefixListResolver.setter(Builder::ipamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamArn").unmarshallLocationName("ipamArn").build()}).build();
    private static final SdkField<String> IPAM_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamRegion").getter(IpamPrefixListResolver.getter(IpamPrefixListResolver::ipamRegion)).setter(IpamPrefixListResolver.setter(Builder::ipamRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamRegion").unmarshallLocationName("ipamRegion").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(IpamPrefixListResolver.getter(IpamPrefixListResolver::description)).setter(IpamPrefixListResolver.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<String> ADDRESS_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressFamily").getter(IpamPrefixListResolver.getter(IpamPrefixListResolver::addressFamilyAsString)).setter(IpamPrefixListResolver.setter(Builder::addressFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressFamily").unmarshallLocationName("addressFamily").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(IpamPrefixListResolver.getter(IpamPrefixListResolver::stateAsString)).setter(IpamPrefixListResolver.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(IpamPrefixListResolver.getter(IpamPrefixListResolver::tags)).setter(IpamPrefixListResolver.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> LAST_VERSION_CREATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastVersionCreationStatus").getter(IpamPrefixListResolver.getter(IpamPrefixListResolver::lastVersionCreationStatusAsString)).setter(IpamPrefixListResolver.setter(Builder::lastVersionCreationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastVersionCreationStatus").unmarshallLocationName("lastVersionCreationStatus").build()}).build();
    private static final SdkField<String> LAST_VERSION_CREATION_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastVersionCreationStatusMessage").getter(IpamPrefixListResolver.getter(IpamPrefixListResolver::lastVersionCreationStatusMessage)).setter(IpamPrefixListResolver.setter(Builder::lastVersionCreationStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastVersionCreationStatusMessage").unmarshallLocationName("lastVersionCreationStatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD, IPAM_PREFIX_LIST_RESOLVER_ID_FIELD, IPAM_PREFIX_LIST_RESOLVER_ARN_FIELD, IPAM_ARN_FIELD, IPAM_REGION_FIELD, DESCRIPTION_FIELD, ADDRESS_FAMILY_FIELD, STATE_FIELD, TAGS_FIELD, LAST_VERSION_CREATION_STATUS_FIELD, LAST_VERSION_CREATION_STATUS_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IpamPrefixListResolver.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ownerId;
    private final String ipamPrefixListResolverId;
    private final String ipamPrefixListResolverArn;
    private final String ipamArn;
    private final String ipamRegion;
    private final String description;
    private final String addressFamily;
    private final String state;
    private final List<Tag> tags;
    private final String lastVersionCreationStatus;
    private final String lastVersionCreationStatusMessage;

    private IpamPrefixListResolver(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.ipamPrefixListResolverId = builder.ipamPrefixListResolverId;
        this.ipamPrefixListResolverArn = builder.ipamPrefixListResolverArn;
        this.ipamArn = builder.ipamArn;
        this.ipamRegion = builder.ipamRegion;
        this.description = builder.description;
        this.addressFamily = builder.addressFamily;
        this.state = builder.state;
        this.tags = builder.tags;
        this.lastVersionCreationStatus = builder.lastVersionCreationStatus;
        this.lastVersionCreationStatusMessage = builder.lastVersionCreationStatusMessage;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String ipamPrefixListResolverId() {
        return this.ipamPrefixListResolverId;
    }

    public final String ipamPrefixListResolverArn() {
        return this.ipamPrefixListResolverArn;
    }

    public final String ipamArn() {
        return this.ipamArn;
    }

    public final String ipamRegion() {
        return this.ipamRegion;
    }

    public final String description() {
        return this.description;
    }

    public final AddressFamily addressFamily() {
        return AddressFamily.fromValue(this.addressFamily);
    }

    public final String addressFamilyAsString() {
        return this.addressFamily;
    }

    public final IpamPrefixListResolverState state() {
        return IpamPrefixListResolverState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final IpamPrefixListResolverVersionCreationStatus lastVersionCreationStatus() {
        return IpamPrefixListResolverVersionCreationStatus.fromValue(this.lastVersionCreationStatus);
    }

    public final String lastVersionCreationStatusAsString() {
        return this.lastVersionCreationStatus;
    }

    public final String lastVersionCreationStatusMessage() {
        return this.lastVersionCreationStatusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPrefixListResolverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPrefixListResolverArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastVersionCreationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastVersionCreationStatusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamPrefixListResolver)) {
            return false;
        }
        IpamPrefixListResolver other = (IpamPrefixListResolver)obj;
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.ipamPrefixListResolverId(), other.ipamPrefixListResolverId()) && Objects.equals(this.ipamPrefixListResolverArn(), other.ipamPrefixListResolverArn()) && Objects.equals(this.ipamArn(), other.ipamArn()) && Objects.equals(this.ipamRegion(), other.ipamRegion()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.addressFamilyAsString(), other.addressFamilyAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.lastVersionCreationStatusAsString(), other.lastVersionCreationStatusAsString()) && Objects.equals(this.lastVersionCreationStatusMessage(), other.lastVersionCreationStatusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"IpamPrefixListResolver").add("OwnerId", (Object)this.ownerId()).add("IpamPrefixListResolverId", (Object)this.ipamPrefixListResolverId()).add("IpamPrefixListResolverArn", (Object)this.ipamPrefixListResolverArn()).add("IpamArn", (Object)this.ipamArn()).add("IpamRegion", (Object)this.ipamRegion()).add("Description", (Object)this.description()).add("AddressFamily", (Object)this.addressFamilyAsString()).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("LastVersionCreationStatus", (Object)this.lastVersionCreationStatusAsString()).add("LastVersionCreationStatusMessage", (Object)this.lastVersionCreationStatusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "IpamPrefixListResolverId": {
                return Optional.ofNullable(clazz.cast(this.ipamPrefixListResolverId()));
            }
            case "IpamPrefixListResolverArn": {
                return Optional.ofNullable(clazz.cast(this.ipamPrefixListResolverArn()));
            }
            case "IpamArn": {
                return Optional.ofNullable(clazz.cast(this.ipamArn()));
            }
            case "IpamRegion": {
                return Optional.ofNullable(clazz.cast(this.ipamRegion()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AddressFamily": {
                return Optional.ofNullable(clazz.cast(this.addressFamilyAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "LastVersionCreationStatus": {
                return Optional.ofNullable(clazz.cast(this.lastVersionCreationStatusAsString()));
            }
            case "LastVersionCreationStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.lastVersionCreationStatusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("IpamPrefixListResolverId", IPAM_PREFIX_LIST_RESOLVER_ID_FIELD);
        map.put("IpamPrefixListResolverArn", IPAM_PREFIX_LIST_RESOLVER_ARN_FIELD);
        map.put("IpamArn", IPAM_ARN_FIELD);
        map.put("IpamRegion", IPAM_REGION_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AddressFamily", ADDRESS_FAMILY_FIELD);
        map.put("State", STATE_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("LastVersionCreationStatus", LAST_VERSION_CREATION_STATUS_FIELD);
        map.put("LastVersionCreationStatusMessage", LAST_VERSION_CREATION_STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpamPrefixListResolver, T> g) {
        return obj -> g.apply((IpamPrefixListResolver)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private String ipamPrefixListResolverId;
        private String ipamPrefixListResolverArn;
        private String ipamArn;
        private String ipamRegion;
        private String description;
        private String addressFamily;
        private String state;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String lastVersionCreationStatus;
        private String lastVersionCreationStatusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamPrefixListResolver model) {
            this.ownerId(model.ownerId);
            this.ipamPrefixListResolverId(model.ipamPrefixListResolverId);
            this.ipamPrefixListResolverArn(model.ipamPrefixListResolverArn);
            this.ipamArn(model.ipamArn);
            this.ipamRegion(model.ipamRegion);
            this.description(model.description);
            this.addressFamily(model.addressFamily);
            this.state(model.state);
            this.tags(model.tags);
            this.lastVersionCreationStatus(model.lastVersionCreationStatus);
            this.lastVersionCreationStatusMessage(model.lastVersionCreationStatusMessage);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getIpamPrefixListResolverId() {
            return this.ipamPrefixListResolverId;
        }

        public final void setIpamPrefixListResolverId(String ipamPrefixListResolverId) {
            this.ipamPrefixListResolverId = ipamPrefixListResolverId;
        }

        @Override
        public final Builder ipamPrefixListResolverId(String ipamPrefixListResolverId) {
            this.ipamPrefixListResolverId = ipamPrefixListResolverId;
            return this;
        }

        public final String getIpamPrefixListResolverArn() {
            return this.ipamPrefixListResolverArn;
        }

        public final void setIpamPrefixListResolverArn(String ipamPrefixListResolverArn) {
            this.ipamPrefixListResolverArn = ipamPrefixListResolverArn;
        }

        @Override
        public final Builder ipamPrefixListResolverArn(String ipamPrefixListResolverArn) {
            this.ipamPrefixListResolverArn = ipamPrefixListResolverArn;
            return this;
        }

        public final String getIpamArn() {
            return this.ipamArn;
        }

        public final void setIpamArn(String ipamArn) {
            this.ipamArn = ipamArn;
        }

        @Override
        public final Builder ipamArn(String ipamArn) {
            this.ipamArn = ipamArn;
            return this;
        }

        public final String getIpamRegion() {
            return this.ipamRegion;
        }

        public final void setIpamRegion(String ipamRegion) {
            this.ipamRegion = ipamRegion;
        }

        @Override
        public final Builder ipamRegion(String ipamRegion) {
            this.ipamRegion = ipamRegion;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAddressFamily() {
            return this.addressFamily;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @Override
        public final Builder addressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily == null ? null : addressFamily.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(IpamPrefixListResolverState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLastVersionCreationStatus() {
            return this.lastVersionCreationStatus;
        }

        public final void setLastVersionCreationStatus(String lastVersionCreationStatus) {
            this.lastVersionCreationStatus = lastVersionCreationStatus;
        }

        @Override
        public final Builder lastVersionCreationStatus(String lastVersionCreationStatus) {
            this.lastVersionCreationStatus = lastVersionCreationStatus;
            return this;
        }

        @Override
        public final Builder lastVersionCreationStatus(IpamPrefixListResolverVersionCreationStatus lastVersionCreationStatus) {
            this.lastVersionCreationStatus(lastVersionCreationStatus == null ? null : lastVersionCreationStatus.toString());
            return this;
        }

        public final String getLastVersionCreationStatusMessage() {
            return this.lastVersionCreationStatusMessage;
        }

        public final void setLastVersionCreationStatusMessage(String lastVersionCreationStatusMessage) {
            this.lastVersionCreationStatusMessage = lastVersionCreationStatusMessage;
        }

        @Override
        public final Builder lastVersionCreationStatusMessage(String lastVersionCreationStatusMessage) {
            this.lastVersionCreationStatusMessage = lastVersionCreationStatusMessage;
            return this;
        }

        public IpamPrefixListResolver build() {
            return new IpamPrefixListResolver(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpamPrefixListResolver> {
        public Builder ownerId(String var1);

        public Builder ipamPrefixListResolverId(String var1);

        public Builder ipamPrefixListResolverArn(String var1);

        public Builder ipamArn(String var1);

        public Builder ipamRegion(String var1);

        public Builder description(String var1);

        public Builder addressFamily(String var1);

        public Builder addressFamily(AddressFamily var1);

        public Builder state(String var1);

        public Builder state(IpamPrefixListResolverState var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder lastVersionCreationStatus(String var1);

        public Builder lastVersionCreationStatus(IpamPrefixListResolverVersionCreationStatus var1);

        public Builder lastVersionCreationStatusMessage(String var1);
    }
}

