/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisableIpamPolicyRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DisableIpamPolicyRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DisableIpamPolicyRequest.getter(DisableIpamPolicyRequest::dryRun)).setter(DisableIpamPolicyRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> IPAM_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPolicyId").getter(DisableIpamPolicyRequest.getter(DisableIpamPolicyRequest::ipamPolicyId)).setter(DisableIpamPolicyRequest.setter(Builder::ipamPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPolicyId").unmarshallLocationName("IpamPolicyId").build()}).build();
    private static final SdkField<String> ORGANIZATION_TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationTargetId").getter(DisableIpamPolicyRequest.getter(DisableIpamPolicyRequest::organizationTargetId)).setter(DisableIpamPolicyRequest.setter(Builder::organizationTargetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationTargetId").unmarshallLocationName("OrganizationTargetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, IPAM_POLICY_ID_FIELD, ORGANIZATION_TARGET_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DisableIpamPolicyRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String ipamPolicyId;
    private final String organizationTargetId;

    private DisableIpamPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamPolicyId = builder.ipamPolicyId;
        this.organizationTargetId = builder.organizationTargetId;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String ipamPolicyId() {
        return this.ipamPolicyId;
    }

    public final String organizationTargetId() {
        return this.organizationTargetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationTargetId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableIpamPolicyRequest)) {
            return false;
        }
        DisableIpamPolicyRequest other = (DisableIpamPolicyRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.ipamPolicyId(), other.ipamPolicyId()) && Objects.equals(this.organizationTargetId(), other.organizationTargetId());
    }

    public final String toString() {
        return ToString.builder((String)"DisableIpamPolicyRequest").add("DryRun", (Object)this.dryRun()).add("IpamPolicyId", (Object)this.ipamPolicyId()).add("OrganizationTargetId", (Object)this.organizationTargetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "IpamPolicyId": {
                return Optional.ofNullable(clazz.cast(this.ipamPolicyId()));
            }
            case "OrganizationTargetId": {
                return Optional.ofNullable(clazz.cast(this.organizationTargetId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("IpamPolicyId", IPAM_POLICY_ID_FIELD);
        map.put("OrganizationTargetId", ORGANIZATION_TARGET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisableIpamPolicyRequest, T> g) {
        return obj -> g.apply((DisableIpamPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String ipamPolicyId;
        private String organizationTargetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableIpamPolicyRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.ipamPolicyId(model.ipamPolicyId);
            this.organizationTargetId(model.organizationTargetId);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamPolicyId() {
            return this.ipamPolicyId;
        }

        public final void setIpamPolicyId(String ipamPolicyId) {
            this.ipamPolicyId = ipamPolicyId;
        }

        @Override
        public final Builder ipamPolicyId(String ipamPolicyId) {
            this.ipamPolicyId = ipamPolicyId;
            return this;
        }

        public final String getOrganizationTargetId() {
            return this.organizationTargetId;
        }

        public final void setOrganizationTargetId(String organizationTargetId) {
            this.organizationTargetId = organizationTargetId;
        }

        @Override
        public final Builder organizationTargetId(String organizationTargetId) {
            this.organizationTargetId = organizationTargetId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisableIpamPolicyRequest build() {
            return new DisableIpamPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisableIpamPolicyRequest> {
        public Builder dryRun(Boolean var1);

        public Builder ipamPolicyId(String var1);

        public Builder organizationTargetId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

