/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.VpnConcentrator;
import software.amazon.awssdk.services.ec2.model.VpnConcentratorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpnConcentratorsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVpnConcentratorsResponse> {
    private static final SdkField<List<VpnConcentrator>> VPN_CONCENTRATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpnConcentrators").getter(DescribeVpnConcentratorsResponse.getter(DescribeVpnConcentratorsResponse::vpnConcentrators)).setter(DescribeVpnConcentratorsResponse.setter(Builder::vpnConcentrators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConcentratorSet").unmarshallLocationName("vpnConcentratorSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpnConcentrator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeVpnConcentratorsResponse.getter(DescribeVpnConcentratorsResponse::nextToken)).setter(DescribeVpnConcentratorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPN_CONCENTRATORS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeVpnConcentratorsResponse.memberNameToFieldInitializer();
    private final List<VpnConcentrator> vpnConcentrators;
    private final String nextToken;

    private DescribeVpnConcentratorsResponse(BuilderImpl builder) {
        super(builder);
        this.vpnConcentrators = builder.vpnConcentrators;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVpnConcentrators() {
        return this.vpnConcentrators != null && !(this.vpnConcentrators instanceof SdkAutoConstructList);
    }

    public final List<VpnConcentrator> vpnConcentrators() {
        return this.vpnConcentrators;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpnConcentrators() ? this.vpnConcentrators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpnConcentratorsResponse)) {
            return false;
        }
        DescribeVpnConcentratorsResponse other = (DescribeVpnConcentratorsResponse)((Object)obj);
        return this.hasVpnConcentrators() == other.hasVpnConcentrators() && Objects.equals(this.vpnConcentrators(), other.vpnConcentrators()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVpnConcentratorsResponse").add("VpnConcentrators", this.hasVpnConcentrators() ? this.vpnConcentrators() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpnConcentrators": {
                return Optional.ofNullable(clazz.cast(this.vpnConcentrators()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VpnConcentratorSet", VPN_CONCENTRATORS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpnConcentratorsResponse, T> g) {
        return obj -> g.apply((DescribeVpnConcentratorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<VpnConcentrator> vpnConcentrators = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpnConcentratorsResponse model) {
            super(model);
            this.vpnConcentrators(model.vpnConcentrators);
            this.nextToken(model.nextToken);
        }

        public final List<VpnConcentrator.Builder> getVpnConcentrators() {
            List<VpnConcentrator.Builder> result = VpnConcentratorListCopier.copyToBuilder(this.vpnConcentrators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpnConcentrators(Collection<VpnConcentrator.BuilderImpl> vpnConcentrators) {
            this.vpnConcentrators = VpnConcentratorListCopier.copyFromBuilder(vpnConcentrators);
        }

        @Override
        public final Builder vpnConcentrators(Collection<VpnConcentrator> vpnConcentrators) {
            this.vpnConcentrators = VpnConcentratorListCopier.copy(vpnConcentrators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnConcentrators(VpnConcentrator ... vpnConcentrators) {
            this.vpnConcentrators(Arrays.asList(vpnConcentrators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnConcentrators(Consumer<VpnConcentrator.Builder> ... vpnConcentrators) {
            this.vpnConcentrators(Stream.of(vpnConcentrators).map(c -> (VpnConcentrator)((VpnConcentrator.Builder)VpnConcentrator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeVpnConcentratorsResponse build() {
            return new DescribeVpnConcentratorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVpnConcentratorsResponse> {
        public Builder vpnConcentrators(Collection<VpnConcentrator> var1);

        public Builder vpnConcentrators(VpnConcentrator ... var1);

        public Builder vpnConcentrators(Consumer<VpnConcentrator.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

