/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateInterruptibleCapacityReservationAllocationResponse extends Ec2Response
        implements
        ToCopyableBuilder<UpdateInterruptibleCapacityReservationAllocationResponse.Builder, UpdateInterruptibleCapacityReservationAllocationResponse> {
    private static final SdkField<String> INTERRUPTIBLE_CAPACITY_RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InterruptibleCapacityReservationId")
            .getter(getter(UpdateInterruptibleCapacityReservationAllocationResponse::interruptibleCapacityReservationId))
            .setter(setter(Builder::interruptibleCapacityReservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterruptibleCapacityReservationId")
                    .unmarshallLocationName("interruptibleCapacityReservationId").build()).build();

    private static final SdkField<String> SOURCE_CAPACITY_RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceCapacityReservationId")
            .getter(getter(UpdateInterruptibleCapacityReservationAllocationResponse::sourceCapacityReservationId))
            .setter(setter(Builder::sourceCapacityReservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCapacityReservationId")
                    .unmarshallLocationName("sourceCapacityReservationId").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount")
            .getter(getter(UpdateInterruptibleCapacityReservationAllocationResponse::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount")
                    .unmarshallLocationName("instanceCount").build()).build();

    private static final SdkField<Integer> TARGET_INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TargetInstanceCount")
            .getter(getter(UpdateInterruptibleCapacityReservationAllocationResponse::targetInstanceCount))
            .setter(setter(Builder::targetInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetInstanceCount")
                    .unmarshallLocationName("targetInstanceCount").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(UpdateInterruptibleCapacityReservationAllocationResponse::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<String> INTERRUPTION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InterruptionType")
            .getter(getter(UpdateInterruptibleCapacityReservationAllocationResponse::interruptionTypeAsString))
            .setter(setter(Builder::interruptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterruptionType")
                    .unmarshallLocationName("interruptionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INTERRUPTIBLE_CAPACITY_RESERVATION_ID_FIELD, SOURCE_CAPACITY_RESERVATION_ID_FIELD, INSTANCE_COUNT_FIELD,
            TARGET_INSTANCE_COUNT_FIELD, STATUS_FIELD, INTERRUPTION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String interruptibleCapacityReservationId;

    private final String sourceCapacityReservationId;

    private final Integer instanceCount;

    private final Integer targetInstanceCount;

    private final String status;

    private final String interruptionType;

    private UpdateInterruptibleCapacityReservationAllocationResponse(BuilderImpl builder) {
        super(builder);
        this.interruptibleCapacityReservationId = builder.interruptibleCapacityReservationId;
        this.sourceCapacityReservationId = builder.sourceCapacityReservationId;
        this.instanceCount = builder.instanceCount;
        this.targetInstanceCount = builder.targetInstanceCount;
        this.status = builder.status;
        this.interruptionType = builder.interruptionType;
    }

    /**
     * <p>
     * The ID of the interruptible Capacity Reservation that was modified.
     * </p>
     * 
     * @return The ID of the interruptible Capacity Reservation that was modified.
     */
    public final String interruptibleCapacityReservationId() {
        return interruptibleCapacityReservationId;
    }

    /**
     * <p>
     * The ID of the source Capacity Reservation to which capacity was reclaimed or from which capacity was allocated.
     * </p>
     * 
     * @return The ID of the source Capacity Reservation to which capacity was reclaimed or from which capacity was
     *         allocated.
     */
    public final String sourceCapacityReservationId() {
        return sourceCapacityReservationId;
    }

    /**
     * <p>
     * The current number of instances allocated to the interruptible reservation.
     * </p>
     * 
     * @return The current number of instances allocated to the interruptible reservation.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The requested number of instances for the interruptible Capacity Reservation.
     * </p>
     * 
     * @return The requested number of instances for the interruptible Capacity Reservation.
     */
    public final Integer targetInstanceCount() {
        return targetInstanceCount;
    }

    /**
     * <p>
     * The current status of the allocation (updating during reclamation, active when complete).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InterruptibleCapacityReservationAllocationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the allocation (updating during reclamation, active when complete).
     * @see InterruptibleCapacityReservationAllocationStatus
     */
    public final InterruptibleCapacityReservationAllocationStatus status() {
        return InterruptibleCapacityReservationAllocationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the allocation (updating during reclamation, active when complete).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InterruptibleCapacityReservationAllocationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the allocation (updating during reclamation, active when complete).
     * @see InterruptibleCapacityReservationAllocationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The interruption type for the interruptible reservation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interruptionType}
     * will return {@link InterruptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interruptionTypeAsString}.
     * </p>
     * 
     * @return The interruption type for the interruptible reservation.
     * @see InterruptionType
     */
    public final InterruptionType interruptionType() {
        return InterruptionType.fromValue(interruptionType);
    }

    /**
     * <p>
     * The interruption type for the interruptible reservation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interruptionType}
     * will return {@link InterruptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interruptionTypeAsString}.
     * </p>
     * 
     * @return The interruption type for the interruptible reservation.
     * @see InterruptionType
     */
    public final String interruptionTypeAsString() {
        return interruptionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(interruptibleCapacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCapacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(targetInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(interruptionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInterruptibleCapacityReservationAllocationResponse)) {
            return false;
        }
        UpdateInterruptibleCapacityReservationAllocationResponse other = (UpdateInterruptibleCapacityReservationAllocationResponse) obj;
        return Objects.equals(interruptibleCapacityReservationId(), other.interruptibleCapacityReservationId())
                && Objects.equals(sourceCapacityReservationId(), other.sourceCapacityReservationId())
                && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(targetInstanceCount(), other.targetInstanceCount())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(interruptionTypeAsString(), other.interruptionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateInterruptibleCapacityReservationAllocationResponse")
                .add("InterruptibleCapacityReservationId", interruptibleCapacityReservationId())
                .add("SourceCapacityReservationId", sourceCapacityReservationId()).add("InstanceCount", instanceCount())
                .add("TargetInstanceCount", targetInstanceCount()).add("Status", statusAsString())
                .add("InterruptionType", interruptionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InterruptibleCapacityReservationId":
            return Optional.ofNullable(clazz.cast(interruptibleCapacityReservationId()));
        case "SourceCapacityReservationId":
            return Optional.ofNullable(clazz.cast(sourceCapacityReservationId()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "TargetInstanceCount":
            return Optional.ofNullable(clazz.cast(targetInstanceCount()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "InterruptionType":
            return Optional.ofNullable(clazz.cast(interruptionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InterruptibleCapacityReservationId", INTERRUPTIBLE_CAPACITY_RESERVATION_ID_FIELD);
        map.put("SourceCapacityReservationId", SOURCE_CAPACITY_RESERVATION_ID_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("TargetInstanceCount", TARGET_INSTANCE_COUNT_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("InterruptionType", INTERRUPTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateInterruptibleCapacityReservationAllocationResponse, T> g) {
        return obj -> g.apply((UpdateInterruptibleCapacityReservationAllocationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateInterruptibleCapacityReservationAllocationResponse> {
        /**
         * <p>
         * The ID of the interruptible Capacity Reservation that was modified.
         * </p>
         * 
         * @param interruptibleCapacityReservationId
         *        The ID of the interruptible Capacity Reservation that was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interruptibleCapacityReservationId(String interruptibleCapacityReservationId);

        /**
         * <p>
         * The ID of the source Capacity Reservation to which capacity was reclaimed or from which capacity was
         * allocated.
         * </p>
         * 
         * @param sourceCapacityReservationId
         *        The ID of the source Capacity Reservation to which capacity was reclaimed or from which capacity was
         *        allocated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCapacityReservationId(String sourceCapacityReservationId);

        /**
         * <p>
         * The current number of instances allocated to the interruptible reservation.
         * </p>
         * 
         * @param instanceCount
         *        The current number of instances allocated to the interruptible reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The requested number of instances for the interruptible Capacity Reservation.
         * </p>
         * 
         * @param targetInstanceCount
         *        The requested number of instances for the interruptible Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetInstanceCount(Integer targetInstanceCount);

        /**
         * <p>
         * The current status of the allocation (updating during reclamation, active when complete).
         * </p>
         * 
         * @param status
         *        The current status of the allocation (updating during reclamation, active when complete).
         * @see InterruptibleCapacityReservationAllocationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterruptibleCapacityReservationAllocationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the allocation (updating during reclamation, active when complete).
         * </p>
         * 
         * @param status
         *        The current status of the allocation (updating during reclamation, active when complete).
         * @see InterruptibleCapacityReservationAllocationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterruptibleCapacityReservationAllocationStatus
         */
        Builder status(InterruptibleCapacityReservationAllocationStatus status);

        /**
         * <p>
         * The interruption type for the interruptible reservation.
         * </p>
         * 
         * @param interruptionType
         *        The interruption type for the interruptible reservation.
         * @see InterruptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterruptionType
         */
        Builder interruptionType(String interruptionType);

        /**
         * <p>
         * The interruption type for the interruptible reservation.
         * </p>
         * 
         * @param interruptionType
         *        The interruption type for the interruptible reservation.
         * @see InterruptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterruptionType
         */
        Builder interruptionType(InterruptionType interruptionType);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String interruptibleCapacityReservationId;

        private String sourceCapacityReservationId;

        private Integer instanceCount;

        private Integer targetInstanceCount;

        private String status;

        private String interruptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInterruptibleCapacityReservationAllocationResponse model) {
            super(model);
            interruptibleCapacityReservationId(model.interruptibleCapacityReservationId);
            sourceCapacityReservationId(model.sourceCapacityReservationId);
            instanceCount(model.instanceCount);
            targetInstanceCount(model.targetInstanceCount);
            status(model.status);
            interruptionType(model.interruptionType);
        }

        public final String getInterruptibleCapacityReservationId() {
            return interruptibleCapacityReservationId;
        }

        public final void setInterruptibleCapacityReservationId(String interruptibleCapacityReservationId) {
            this.interruptibleCapacityReservationId = interruptibleCapacityReservationId;
        }

        @Override
        public final Builder interruptibleCapacityReservationId(String interruptibleCapacityReservationId) {
            this.interruptibleCapacityReservationId = interruptibleCapacityReservationId;
            return this;
        }

        public final String getSourceCapacityReservationId() {
            return sourceCapacityReservationId;
        }

        public final void setSourceCapacityReservationId(String sourceCapacityReservationId) {
            this.sourceCapacityReservationId = sourceCapacityReservationId;
        }

        @Override
        public final Builder sourceCapacityReservationId(String sourceCapacityReservationId) {
            this.sourceCapacityReservationId = sourceCapacityReservationId;
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final Integer getTargetInstanceCount() {
            return targetInstanceCount;
        }

        public final void setTargetInstanceCount(Integer targetInstanceCount) {
            this.targetInstanceCount = targetInstanceCount;
        }

        @Override
        public final Builder targetInstanceCount(Integer targetInstanceCount) {
            this.targetInstanceCount = targetInstanceCount;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InterruptibleCapacityReservationAllocationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getInterruptionType() {
            return interruptionType;
        }

        public final void setInterruptionType(String interruptionType) {
            this.interruptionType = interruptionType;
        }

        @Override
        public final Builder interruptionType(String interruptionType) {
            this.interruptionType = interruptionType;
            return this;
        }

        @Override
        public final Builder interruptionType(InterruptionType interruptionType) {
            this.interruptionType(interruptionType == null ? null : interruptionType.toString());
            return this;
        }

        @Override
        public UpdateInterruptibleCapacityReservationAllocationResponse build() {
            return new UpdateInterruptibleCapacityReservationAllocationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
