/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyIpamPolicyAllocationRulesResponse extends Ec2Response implements
        ToCopyableBuilder<ModifyIpamPolicyAllocationRulesResponse.Builder, ModifyIpamPolicyAllocationRulesResponse> {
    private static final SdkField<IpamPolicyDocument> IPAM_POLICY_DOCUMENT_FIELD = SdkField
            .<IpamPolicyDocument> builder(MarshallingType.SDK_POJO)
            .memberName("IpamPolicyDocument")
            .getter(getter(ModifyIpamPolicyAllocationRulesResponse::ipamPolicyDocument))
            .setter(setter(Builder::ipamPolicyDocument))
            .constructor(IpamPolicyDocument::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPolicyDocument")
                    .unmarshallLocationName("ipamPolicyDocument").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_POLICY_DOCUMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final IpamPolicyDocument ipamPolicyDocument;

    private ModifyIpamPolicyAllocationRulesResponse(BuilderImpl builder) {
        super(builder);
        this.ipamPolicyDocument = builder.ipamPolicyDocument;
    }

    /**
     * <p>
     * The modified IPAM policy containing the updated allocation rules.
     * </p>
     * 
     * @return The modified IPAM policy containing the updated allocation rules.
     */
    public final IpamPolicyDocument ipamPolicyDocument() {
        return ipamPolicyDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipamPolicyDocument());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIpamPolicyAllocationRulesResponse)) {
            return false;
        }
        ModifyIpamPolicyAllocationRulesResponse other = (ModifyIpamPolicyAllocationRulesResponse) obj;
        return Objects.equals(ipamPolicyDocument(), other.ipamPolicyDocument());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyIpamPolicyAllocationRulesResponse").add("IpamPolicyDocument", ipamPolicyDocument())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpamPolicyDocument":
            return Optional.ofNullable(clazz.cast(ipamPolicyDocument()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IpamPolicyDocument", IPAM_POLICY_DOCUMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyIpamPolicyAllocationRulesResponse, T> g) {
        return obj -> g.apply((ModifyIpamPolicyAllocationRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyIpamPolicyAllocationRulesResponse> {
        /**
         * <p>
         * The modified IPAM policy containing the updated allocation rules.
         * </p>
         * 
         * @param ipamPolicyDocument
         *        The modified IPAM policy containing the updated allocation rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPolicyDocument(IpamPolicyDocument ipamPolicyDocument);

        /**
         * <p>
         * The modified IPAM policy containing the updated allocation rules.
         * </p>
         * This is a convenience method that creates an instance of the {@link IpamPolicyDocument.Builder} avoiding the
         * need to create one manually via {@link IpamPolicyDocument#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IpamPolicyDocument.Builder#build()} is called immediately and its
         * result is passed to {@link #ipamPolicyDocument(IpamPolicyDocument)}.
         * 
         * @param ipamPolicyDocument
         *        a consumer that will call methods on {@link IpamPolicyDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipamPolicyDocument(IpamPolicyDocument)
         */
        default Builder ipamPolicyDocument(Consumer<IpamPolicyDocument.Builder> ipamPolicyDocument) {
            return ipamPolicyDocument(IpamPolicyDocument.builder().applyMutation(ipamPolicyDocument).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private IpamPolicyDocument ipamPolicyDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIpamPolicyAllocationRulesResponse model) {
            super(model);
            ipamPolicyDocument(model.ipamPolicyDocument);
        }

        public final IpamPolicyDocument.Builder getIpamPolicyDocument() {
            return ipamPolicyDocument != null ? ipamPolicyDocument.toBuilder() : null;
        }

        public final void setIpamPolicyDocument(IpamPolicyDocument.BuilderImpl ipamPolicyDocument) {
            this.ipamPolicyDocument = ipamPolicyDocument != null ? ipamPolicyDocument.build() : null;
        }

        @Override
        public final Builder ipamPolicyDocument(IpamPolicyDocument ipamPolicyDocument) {
            this.ipamPolicyDocument = ipamPolicyDocument;
            return this;
        }

        @Override
        public ModifyIpamPolicyAllocationRulesResponse build() {
            return new ModifyIpamPolicyAllocationRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
