/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a custom configuration for a System Integrity Protection (SIP) modification task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MacSystemIntegrityProtectionConfigurationRequest
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<MacSystemIntegrityProtectionConfigurationRequest.Builder, MacSystemIntegrityProtectionConfigurationRequest> {
    private static final SdkField<String> APPLE_INTERNAL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AppleInternal")
            .getter(getter(MacSystemIntegrityProtectionConfigurationRequest::appleInternalAsString))
            .setter(setter(Builder::appleInternal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppleInternal")
                    .unmarshallLocationName("AppleInternal").build()).build();

    private static final SdkField<String> BASE_SYSTEM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BaseSystem")
            .getter(getter(MacSystemIntegrityProtectionConfigurationRequest::baseSystemAsString))
            .setter(setter(Builder::baseSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseSystem")
                    .unmarshallLocationName("BaseSystem").build()).build();

    private static final SdkField<String> DEBUGGING_RESTRICTIONS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DebuggingRestrictions")
            .getter(getter(MacSystemIntegrityProtectionConfigurationRequest::debuggingRestrictionsAsString))
            .setter(setter(Builder::debuggingRestrictions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DebuggingRestrictions")
                    .unmarshallLocationName("DebuggingRestrictions").build()).build();

    private static final SdkField<String> D_TRACE_RESTRICTIONS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DTraceRestrictions")
            .getter(getter(MacSystemIntegrityProtectionConfigurationRequest::dTraceRestrictionsAsString))
            .setter(setter(Builder::dTraceRestrictions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DTraceRestrictions")
                    .unmarshallLocationName("DTraceRestrictions").build()).build();

    private static final SdkField<String> FILESYSTEM_PROTECTIONS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FilesystemProtections")
            .getter(getter(MacSystemIntegrityProtectionConfigurationRequest::filesystemProtectionsAsString))
            .setter(setter(Builder::filesystemProtections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilesystemProtections")
                    .unmarshallLocationName("FilesystemProtections").build()).build();

    private static final SdkField<String> KEXT_SIGNING_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KextSigning")
            .getter(getter(MacSystemIntegrityProtectionConfigurationRequest::kextSigningAsString))
            .setter(setter(Builder::kextSigning))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KextSigning")
                    .unmarshallLocationName("KextSigning").build()).build();

    private static final SdkField<String> NVRAM_PROTECTIONS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NvramProtections")
            .getter(getter(MacSystemIntegrityProtectionConfigurationRequest::nvramProtectionsAsString))
            .setter(setter(Builder::nvramProtections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NvramProtections")
                    .unmarshallLocationName("NvramProtections").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLE_INTERNAL_FIELD,
            BASE_SYSTEM_FIELD, DEBUGGING_RESTRICTIONS_FIELD, D_TRACE_RESTRICTIONS_FIELD, FILESYSTEM_PROTECTIONS_FIELD,
            KEXT_SIGNING_FIELD, NVRAM_PROTECTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String appleInternal;

    private final String baseSystem;

    private final String debuggingRestrictions;

    private final String dTraceRestrictions;

    private final String filesystemProtections;

    private final String kextSigning;

    private final String nvramProtections;

    private MacSystemIntegrityProtectionConfigurationRequest(BuilderImpl builder) {
        this.appleInternal = builder.appleInternal;
        this.baseSystem = builder.baseSystem;
        this.debuggingRestrictions = builder.debuggingRestrictions;
        this.dTraceRestrictions = builder.dTraceRestrictions;
        this.filesystemProtections = builder.filesystemProtections;
        this.kextSigning = builder.kextSigning;
        this.nvramProtections = builder.nvramProtections;
    }

    /**
     * <p>
     * Enables or disables Apple Internal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appleInternal}
     * will return {@link MacSystemIntegrityProtectionSettingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #appleInternalAsString}.
     * </p>
     * 
     * @return Enables or disables Apple Internal.
     * @see MacSystemIntegrityProtectionSettingStatus
     */
    public final MacSystemIntegrityProtectionSettingStatus appleInternal() {
        return MacSystemIntegrityProtectionSettingStatus.fromValue(appleInternal);
    }

    /**
     * <p>
     * Enables or disables Apple Internal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appleInternal}
     * will return {@link MacSystemIntegrityProtectionSettingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #appleInternalAsString}.
     * </p>
     * 
     * @return Enables or disables Apple Internal.
     * @see MacSystemIntegrityProtectionSettingStatus
     */
    public final String appleInternalAsString() {
        return appleInternal;
    }

    /**
     * <p>
     * Enables or disables Base System.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #baseSystem} will
     * return {@link MacSystemIntegrityProtectionSettingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #baseSystemAsString}.
     * </p>
     * 
     * @return Enables or disables Base System.
     * @see MacSystemIntegrityProtectionSettingStatus
     */
    public final MacSystemIntegrityProtectionSettingStatus baseSystem() {
        return MacSystemIntegrityProtectionSettingStatus.fromValue(baseSystem);
    }

    /**
     * <p>
     * Enables or disables Base System.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #baseSystem} will
     * return {@link MacSystemIntegrityProtectionSettingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #baseSystemAsString}.
     * </p>
     * 
     * @return Enables or disables Base System.
     * @see MacSystemIntegrityProtectionSettingStatus
     */
    public final String baseSystemAsString() {
        return baseSystem;
    }

    /**
     * <p>
     * Enables or disables Debugging Restrictions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #debuggingRestrictions} will return
     * {@link MacSystemIntegrityProtectionSettingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #debuggingRestrictionsAsString}.
     * </p>
     * 
     * @return Enables or disables Debugging Restrictions.
     * @see MacSystemIntegrityProtectionSettingStatus
     */
    public final MacSystemIntegrityProtectionSettingStatus debuggingRestrictions() {
        return MacSystemIntegrityProtectionSettingStatus.fromValue(debuggingRestrictions);
    }

    /**
     * <p>
     * Enables or disables Debugging Restrictions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #debuggingRestrictions} will return
     * {@link MacSystemIntegrityProtectionSettingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #debuggingRestrictionsAsString}.
     * </p>
     * 
     * @return Enables or disables Debugging Restrictions.
     * @see MacSystemIntegrityProtectionSettingStatus
     */
    public final String debuggingRestrictionsAsString() {
        return debuggingRestrictions;
    }

    /**
     * <p>
     * Enables or disables Dtrace Restrictions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dTraceRestrictions} will return {@link MacSystemIntegrityProtectionSettingStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #dTraceRestrictionsAsString}.
     * </p>
     * 
     * @return Enables or disables Dtrace Restrictions.
     * @see MacSystemIntegrityProtectionSettingStatus
     */
    public final MacSystemIntegrityProtectionSettingStatus dTraceRestrictions() {
        return MacSystemIntegrityProtectionSettingStatus.fromValue(dTraceRestrictions);
    }

    /**
     * <p>
     * Enables or disables Dtrace Restrictions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dTraceRestrictions} will return {@link MacSystemIntegrityProtectionSettingStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #dTraceRestrictionsAsString}.
     * </p>
     * 
     * @return Enables or disables Dtrace Restrictions.
     * @see MacSystemIntegrityProtectionSettingStatus
     */
    public final String dTraceRestrictionsAsString() {
        return dTraceRestrictions;
    }

    /**
     * <p>
     * Enables or disables Filesystem Protections.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #filesystemProtections} will return
     * {@link MacSystemIntegrityProtectionSettingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #filesystemProtectionsAsString}.
     * </p>
     * 
     * @return Enables or disables Filesystem Protections.
     * @see MacSystemIntegrityProtectionSettingStatus
     */
    public final MacSystemIntegrityProtectionSettingStatus filesystemProtections() {
        return MacSystemIntegrityProtectionSettingStatus.fromValue(filesystemProtections);
    }

    /**
     * <p>
     * Enables or disables Filesystem Protections.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #filesystemProtections} will return
     * {@link MacSystemIntegrityProtectionSettingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #filesystemProtectionsAsString}.
     * </p>
     * 
     * @return Enables or disables Filesystem Protections.
     * @see MacSystemIntegrityProtectionSettingStatus
     */
    public final String filesystemProtectionsAsString() {
        return filesystemProtections;
    }

    /**
     * <p>
     * Enables or disables Kext Signing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #kextSigning} will
     * return {@link MacSystemIntegrityProtectionSettingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #kextSigningAsString}.
     * </p>
     * 
     * @return Enables or disables Kext Signing.
     * @see MacSystemIntegrityProtectionSettingStatus
     */
    public final MacSystemIntegrityProtectionSettingStatus kextSigning() {
        return MacSystemIntegrityProtectionSettingStatus.fromValue(kextSigning);
    }

    /**
     * <p>
     * Enables or disables Kext Signing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #kextSigning} will
     * return {@link MacSystemIntegrityProtectionSettingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #kextSigningAsString}.
     * </p>
     * 
     * @return Enables or disables Kext Signing.
     * @see MacSystemIntegrityProtectionSettingStatus
     */
    public final String kextSigningAsString() {
        return kextSigning;
    }

    /**
     * <p>
     * Enables or disables Nvram Protections.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nvramProtections}
     * will return {@link MacSystemIntegrityProtectionSettingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #nvramProtectionsAsString}.
     * </p>
     * 
     * @return Enables or disables Nvram Protections.
     * @see MacSystemIntegrityProtectionSettingStatus
     */
    public final MacSystemIntegrityProtectionSettingStatus nvramProtections() {
        return MacSystemIntegrityProtectionSettingStatus.fromValue(nvramProtections);
    }

    /**
     * <p>
     * Enables or disables Nvram Protections.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nvramProtections}
     * will return {@link MacSystemIntegrityProtectionSettingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #nvramProtectionsAsString}.
     * </p>
     * 
     * @return Enables or disables Nvram Protections.
     * @see MacSystemIntegrityProtectionSettingStatus
     */
    public final String nvramProtectionsAsString() {
        return nvramProtections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appleInternalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(baseSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(debuggingRestrictionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dTraceRestrictionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filesystemProtectionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kextSigningAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nvramProtectionsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MacSystemIntegrityProtectionConfigurationRequest)) {
            return false;
        }
        MacSystemIntegrityProtectionConfigurationRequest other = (MacSystemIntegrityProtectionConfigurationRequest) obj;
        return Objects.equals(appleInternalAsString(), other.appleInternalAsString())
                && Objects.equals(baseSystemAsString(), other.baseSystemAsString())
                && Objects.equals(debuggingRestrictionsAsString(), other.debuggingRestrictionsAsString())
                && Objects.equals(dTraceRestrictionsAsString(), other.dTraceRestrictionsAsString())
                && Objects.equals(filesystemProtectionsAsString(), other.filesystemProtectionsAsString())
                && Objects.equals(kextSigningAsString(), other.kextSigningAsString())
                && Objects.equals(nvramProtectionsAsString(), other.nvramProtectionsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MacSystemIntegrityProtectionConfigurationRequest").add("AppleInternal", appleInternalAsString())
                .add("BaseSystem", baseSystemAsString()).add("DebuggingRestrictions", debuggingRestrictionsAsString())
                .add("DTraceRestrictions", dTraceRestrictionsAsString())
                .add("FilesystemProtections", filesystemProtectionsAsString()).add("KextSigning", kextSigningAsString())
                .add("NvramProtections", nvramProtectionsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppleInternal":
            return Optional.ofNullable(clazz.cast(appleInternalAsString()));
        case "BaseSystem":
            return Optional.ofNullable(clazz.cast(baseSystemAsString()));
        case "DebuggingRestrictions":
            return Optional.ofNullable(clazz.cast(debuggingRestrictionsAsString()));
        case "DTraceRestrictions":
            return Optional.ofNullable(clazz.cast(dTraceRestrictionsAsString()));
        case "FilesystemProtections":
            return Optional.ofNullable(clazz.cast(filesystemProtectionsAsString()));
        case "KextSigning":
            return Optional.ofNullable(clazz.cast(kextSigningAsString()));
        case "NvramProtections":
            return Optional.ofNullable(clazz.cast(nvramProtectionsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AppleInternal", APPLE_INTERNAL_FIELD);
        map.put("BaseSystem", BASE_SYSTEM_FIELD);
        map.put("DebuggingRestrictions", DEBUGGING_RESTRICTIONS_FIELD);
        map.put("DTraceRestrictions", D_TRACE_RESTRICTIONS_FIELD);
        map.put("FilesystemProtections", FILESYSTEM_PROTECTIONS_FIELD);
        map.put("KextSigning", KEXT_SIGNING_FIELD);
        map.put("NvramProtections", NVRAM_PROTECTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MacSystemIntegrityProtectionConfigurationRequest, T> g) {
        return obj -> g.apply((MacSystemIntegrityProtectionConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MacSystemIntegrityProtectionConfigurationRequest> {
        /**
         * <p>
         * Enables or disables Apple Internal.
         * </p>
         * 
         * @param appleInternal
         *        Enables or disables Apple Internal.
         * @see MacSystemIntegrityProtectionSettingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MacSystemIntegrityProtectionSettingStatus
         */
        Builder appleInternal(String appleInternal);

        /**
         * <p>
         * Enables or disables Apple Internal.
         * </p>
         * 
         * @param appleInternal
         *        Enables or disables Apple Internal.
         * @see MacSystemIntegrityProtectionSettingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MacSystemIntegrityProtectionSettingStatus
         */
        Builder appleInternal(MacSystemIntegrityProtectionSettingStatus appleInternal);

        /**
         * <p>
         * Enables or disables Base System.
         * </p>
         * 
         * @param baseSystem
         *        Enables or disables Base System.
         * @see MacSystemIntegrityProtectionSettingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MacSystemIntegrityProtectionSettingStatus
         */
        Builder baseSystem(String baseSystem);

        /**
         * <p>
         * Enables or disables Base System.
         * </p>
         * 
         * @param baseSystem
         *        Enables or disables Base System.
         * @see MacSystemIntegrityProtectionSettingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MacSystemIntegrityProtectionSettingStatus
         */
        Builder baseSystem(MacSystemIntegrityProtectionSettingStatus baseSystem);

        /**
         * <p>
         * Enables or disables Debugging Restrictions.
         * </p>
         * 
         * @param debuggingRestrictions
         *        Enables or disables Debugging Restrictions.
         * @see MacSystemIntegrityProtectionSettingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MacSystemIntegrityProtectionSettingStatus
         */
        Builder debuggingRestrictions(String debuggingRestrictions);

        /**
         * <p>
         * Enables or disables Debugging Restrictions.
         * </p>
         * 
         * @param debuggingRestrictions
         *        Enables or disables Debugging Restrictions.
         * @see MacSystemIntegrityProtectionSettingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MacSystemIntegrityProtectionSettingStatus
         */
        Builder debuggingRestrictions(MacSystemIntegrityProtectionSettingStatus debuggingRestrictions);

        /**
         * <p>
         * Enables or disables Dtrace Restrictions.
         * </p>
         * 
         * @param dTraceRestrictions
         *        Enables or disables Dtrace Restrictions.
         * @see MacSystemIntegrityProtectionSettingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MacSystemIntegrityProtectionSettingStatus
         */
        Builder dTraceRestrictions(String dTraceRestrictions);

        /**
         * <p>
         * Enables or disables Dtrace Restrictions.
         * </p>
         * 
         * @param dTraceRestrictions
         *        Enables or disables Dtrace Restrictions.
         * @see MacSystemIntegrityProtectionSettingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MacSystemIntegrityProtectionSettingStatus
         */
        Builder dTraceRestrictions(MacSystemIntegrityProtectionSettingStatus dTraceRestrictions);

        /**
         * <p>
         * Enables or disables Filesystem Protections.
         * </p>
         * 
         * @param filesystemProtections
         *        Enables or disables Filesystem Protections.
         * @see MacSystemIntegrityProtectionSettingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MacSystemIntegrityProtectionSettingStatus
         */
        Builder filesystemProtections(String filesystemProtections);

        /**
         * <p>
         * Enables or disables Filesystem Protections.
         * </p>
         * 
         * @param filesystemProtections
         *        Enables or disables Filesystem Protections.
         * @see MacSystemIntegrityProtectionSettingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MacSystemIntegrityProtectionSettingStatus
         */
        Builder filesystemProtections(MacSystemIntegrityProtectionSettingStatus filesystemProtections);

        /**
         * <p>
         * Enables or disables Kext Signing.
         * </p>
         * 
         * @param kextSigning
         *        Enables or disables Kext Signing.
         * @see MacSystemIntegrityProtectionSettingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MacSystemIntegrityProtectionSettingStatus
         */
        Builder kextSigning(String kextSigning);

        /**
         * <p>
         * Enables or disables Kext Signing.
         * </p>
         * 
         * @param kextSigning
         *        Enables or disables Kext Signing.
         * @see MacSystemIntegrityProtectionSettingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MacSystemIntegrityProtectionSettingStatus
         */
        Builder kextSigning(MacSystemIntegrityProtectionSettingStatus kextSigning);

        /**
         * <p>
         * Enables or disables Nvram Protections.
         * </p>
         * 
         * @param nvramProtections
         *        Enables or disables Nvram Protections.
         * @see MacSystemIntegrityProtectionSettingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MacSystemIntegrityProtectionSettingStatus
         */
        Builder nvramProtections(String nvramProtections);

        /**
         * <p>
         * Enables or disables Nvram Protections.
         * </p>
         * 
         * @param nvramProtections
         *        Enables or disables Nvram Protections.
         * @see MacSystemIntegrityProtectionSettingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MacSystemIntegrityProtectionSettingStatus
         */
        Builder nvramProtections(MacSystemIntegrityProtectionSettingStatus nvramProtections);
    }

    static final class BuilderImpl implements Builder {
        private String appleInternal;

        private String baseSystem;

        private String debuggingRestrictions;

        private String dTraceRestrictions;

        private String filesystemProtections;

        private String kextSigning;

        private String nvramProtections;

        private BuilderImpl() {
        }

        private BuilderImpl(MacSystemIntegrityProtectionConfigurationRequest model) {
            appleInternal(model.appleInternal);
            baseSystem(model.baseSystem);
            debuggingRestrictions(model.debuggingRestrictions);
            dTraceRestrictions(model.dTraceRestrictions);
            filesystemProtections(model.filesystemProtections);
            kextSigning(model.kextSigning);
            nvramProtections(model.nvramProtections);
        }

        public final String getAppleInternal() {
            return appleInternal;
        }

        public final void setAppleInternal(String appleInternal) {
            this.appleInternal = appleInternal;
        }

        @Override
        public final Builder appleInternal(String appleInternal) {
            this.appleInternal = appleInternal;
            return this;
        }

        @Override
        public final Builder appleInternal(MacSystemIntegrityProtectionSettingStatus appleInternal) {
            this.appleInternal(appleInternal == null ? null : appleInternal.toString());
            return this;
        }

        public final String getBaseSystem() {
            return baseSystem;
        }

        public final void setBaseSystem(String baseSystem) {
            this.baseSystem = baseSystem;
        }

        @Override
        public final Builder baseSystem(String baseSystem) {
            this.baseSystem = baseSystem;
            return this;
        }

        @Override
        public final Builder baseSystem(MacSystemIntegrityProtectionSettingStatus baseSystem) {
            this.baseSystem(baseSystem == null ? null : baseSystem.toString());
            return this;
        }

        public final String getDebuggingRestrictions() {
            return debuggingRestrictions;
        }

        public final void setDebuggingRestrictions(String debuggingRestrictions) {
            this.debuggingRestrictions = debuggingRestrictions;
        }

        @Override
        public final Builder debuggingRestrictions(String debuggingRestrictions) {
            this.debuggingRestrictions = debuggingRestrictions;
            return this;
        }

        @Override
        public final Builder debuggingRestrictions(MacSystemIntegrityProtectionSettingStatus debuggingRestrictions) {
            this.debuggingRestrictions(debuggingRestrictions == null ? null : debuggingRestrictions.toString());
            return this;
        }

        public final String getDTraceRestrictions() {
            return dTraceRestrictions;
        }

        public final void setDTraceRestrictions(String dTraceRestrictions) {
            this.dTraceRestrictions = dTraceRestrictions;
        }

        @Override
        public final Builder dTraceRestrictions(String dTraceRestrictions) {
            this.dTraceRestrictions = dTraceRestrictions;
            return this;
        }

        @Override
        public final Builder dTraceRestrictions(MacSystemIntegrityProtectionSettingStatus dTraceRestrictions) {
            this.dTraceRestrictions(dTraceRestrictions == null ? null : dTraceRestrictions.toString());
            return this;
        }

        public final String getFilesystemProtections() {
            return filesystemProtections;
        }

        public final void setFilesystemProtections(String filesystemProtections) {
            this.filesystemProtections = filesystemProtections;
        }

        @Override
        public final Builder filesystemProtections(String filesystemProtections) {
            this.filesystemProtections = filesystemProtections;
            return this;
        }

        @Override
        public final Builder filesystemProtections(MacSystemIntegrityProtectionSettingStatus filesystemProtections) {
            this.filesystemProtections(filesystemProtections == null ? null : filesystemProtections.toString());
            return this;
        }

        public final String getKextSigning() {
            return kextSigning;
        }

        public final void setKextSigning(String kextSigning) {
            this.kextSigning = kextSigning;
        }

        @Override
        public final Builder kextSigning(String kextSigning) {
            this.kextSigning = kextSigning;
            return this;
        }

        @Override
        public final Builder kextSigning(MacSystemIntegrityProtectionSettingStatus kextSigning) {
            this.kextSigning(kextSigning == null ? null : kextSigning.toString());
            return this;
        }

        public final String getNvramProtections() {
            return nvramProtections;
        }

        public final void setNvramProtections(String nvramProtections) {
            this.nvramProtections = nvramProtections;
        }

        @Override
        public final Builder nvramProtections(String nvramProtections) {
            this.nvramProtections = nvramProtections;
            return this;
        }

        @Override
        public final Builder nvramProtections(MacSystemIntegrityProtectionSettingStatus nvramProtections) {
            this.nvramProtections(nvramProtections == null ? null : nvramProtections.toString());
            return this;
        }

        @Override
        public MacSystemIntegrityProtectionConfigurationRequest build() {
            return new MacSystemIntegrityProtectionConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
