/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a local gateway virtual interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LocalGatewayVirtualInterface implements SdkPojo, Serializable,
        ToCopyableBuilder<LocalGatewayVirtualInterface.Builder, LocalGatewayVirtualInterface> {
    private static final SdkField<String> LOCAL_GATEWAY_VIRTUAL_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayVirtualInterfaceId")
            .getter(getter(LocalGatewayVirtualInterface::localGatewayVirtualInterfaceId))
            .setter(setter(Builder::localGatewayVirtualInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayVirtualInterfaceId")
                    .unmarshallLocationName("localGatewayVirtualInterfaceId").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayId")
            .getter(getter(LocalGatewayVirtualInterface::localGatewayId))
            .setter(setter(Builder::localGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayId")
                    .unmarshallLocationName("localGatewayId").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayVirtualInterfaceGroupId")
            .getter(getter(LocalGatewayVirtualInterface::localGatewayVirtualInterfaceGroupId))
            .setter(setter(Builder::localGatewayVirtualInterfaceGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LocalGatewayVirtualInterfaceGroupId")
                    .unmarshallLocationName("localGatewayVirtualInterfaceGroupId").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_VIRTUAL_INTERFACE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayVirtualInterfaceArn")
            .getter(getter(LocalGatewayVirtualInterface::localGatewayVirtualInterfaceArn))
            .setter(setter(Builder::localGatewayVirtualInterfaceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayVirtualInterfaceArn")
                    .unmarshallLocationName("localGatewayVirtualInterfaceArn").build()).build();

    private static final SdkField<String> OUTPOST_LAG_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostLagId")
            .getter(getter(LocalGatewayVirtualInterface::outpostLagId))
            .setter(setter(Builder::outpostLagId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostLagId")
                    .unmarshallLocationName("outpostLagId").build()).build();

    private static final SdkField<Integer> VLAN_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Vlan")
            .getter(getter(LocalGatewayVirtualInterface::vlan))
            .setter(setter(Builder::vlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vlan")
                    .unmarshallLocationName("vlan").build()).build();

    private static final SdkField<String> LOCAL_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalAddress")
            .getter(getter(LocalGatewayVirtualInterface::localAddress))
            .setter(setter(Builder::localAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalAddress")
                    .unmarshallLocationName("localAddress").build()).build();

    private static final SdkField<String> PEER_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PeerAddress")
            .getter(getter(LocalGatewayVirtualInterface::peerAddress))
            .setter(setter(Builder::peerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAddress")
                    .unmarshallLocationName("peerAddress").build()).build();

    private static final SdkField<Integer> LOCAL_BGP_ASN_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("LocalBgpAsn")
            .getter(getter(LocalGatewayVirtualInterface::localBgpAsn))
            .setter(setter(Builder::localBgpAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalBgpAsn")
                    .unmarshallLocationName("localBgpAsn").build()).build();

    private static final SdkField<Integer> PEER_BGP_ASN_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("PeerBgpAsn")
            .getter(getter(LocalGatewayVirtualInterface::peerBgpAsn))
            .setter(setter(Builder::peerBgpAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerBgpAsn")
                    .unmarshallLocationName("peerBgpAsn").build()).build();

    private static final SdkField<Long> PEER_BGP_ASN_EXTENDED_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("PeerBgpAsnExtended")
            .getter(getter(LocalGatewayVirtualInterface::peerBgpAsnExtended))
            .setter(setter(Builder::peerBgpAsnExtended))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerBgpAsnExtended")
                    .unmarshallLocationName("peerBgpAsnExtended").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(LocalGatewayVirtualInterface::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(LocalGatewayVirtualInterface::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> CONFIGURATION_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationState")
            .getter(getter(LocalGatewayVirtualInterface::configurationStateAsString))
            .setter(setter(Builder::configurationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationState")
                    .unmarshallLocationName("configurationState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LOCAL_GATEWAY_VIRTUAL_INTERFACE_ID_FIELD, LOCAL_GATEWAY_ID_FIELD, LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD,
            LOCAL_GATEWAY_VIRTUAL_INTERFACE_ARN_FIELD, OUTPOST_LAG_ID_FIELD, VLAN_FIELD, LOCAL_ADDRESS_FIELD, PEER_ADDRESS_FIELD,
            LOCAL_BGP_ASN_FIELD, PEER_BGP_ASN_FIELD, PEER_BGP_ASN_EXTENDED_FIELD, OWNER_ID_FIELD, TAGS_FIELD,
            CONFIGURATION_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String localGatewayVirtualInterfaceId;

    private final String localGatewayId;

    private final String localGatewayVirtualInterfaceGroupId;

    private final String localGatewayVirtualInterfaceArn;

    private final String outpostLagId;

    private final Integer vlan;

    private final String localAddress;

    private final String peerAddress;

    private final Integer localBgpAsn;

    private final Integer peerBgpAsn;

    private final Long peerBgpAsnExtended;

    private final String ownerId;

    private final List<Tag> tags;

    private final String configurationState;

    private LocalGatewayVirtualInterface(BuilderImpl builder) {
        this.localGatewayVirtualInterfaceId = builder.localGatewayVirtualInterfaceId;
        this.localGatewayId = builder.localGatewayId;
        this.localGatewayVirtualInterfaceGroupId = builder.localGatewayVirtualInterfaceGroupId;
        this.localGatewayVirtualInterfaceArn = builder.localGatewayVirtualInterfaceArn;
        this.outpostLagId = builder.outpostLagId;
        this.vlan = builder.vlan;
        this.localAddress = builder.localAddress;
        this.peerAddress = builder.peerAddress;
        this.localBgpAsn = builder.localBgpAsn;
        this.peerBgpAsn = builder.peerBgpAsn;
        this.peerBgpAsnExtended = builder.peerBgpAsnExtended;
        this.ownerId = builder.ownerId;
        this.tags = builder.tags;
        this.configurationState = builder.configurationState;
    }

    /**
     * <p>
     * The ID of the virtual interface.
     * </p>
     * 
     * @return The ID of the virtual interface.
     */
    public final String localGatewayVirtualInterfaceId() {
        return localGatewayVirtualInterfaceId;
    }

    /**
     * <p>
     * The ID of the local gateway.
     * </p>
     * 
     * @return The ID of the local gateway.
     */
    public final String localGatewayId() {
        return localGatewayId;
    }

    /**
     * <p>
     * The ID of the local gateway virtual interface group.
     * </p>
     * 
     * @return The ID of the local gateway virtual interface group.
     */
    public final String localGatewayVirtualInterfaceGroupId() {
        return localGatewayVirtualInterfaceGroupId;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the local gateway virtual interface.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the local gateway virtual interface.
     */
    public final String localGatewayVirtualInterfaceArn() {
        return localGatewayVirtualInterfaceArn;
    }

    /**
     * <p>
     * The Outpost LAG ID.
     * </p>
     * 
     * @return The Outpost LAG ID.
     */
    public final String outpostLagId() {
        return outpostLagId;
    }

    /**
     * <p>
     * The ID of the VLAN.
     * </p>
     * 
     * @return The ID of the VLAN.
     */
    public final Integer vlan() {
        return vlan;
    }

    /**
     * <p>
     * The local address.
     * </p>
     * 
     * @return The local address.
     */
    public final String localAddress() {
        return localAddress;
    }

    /**
     * <p>
     * The peer address.
     * </p>
     * 
     * @return The peer address.
     */
    public final String peerAddress() {
        return peerAddress;
    }

    /**
     * <p>
     * The Border Gateway Protocol (BGP) Autonomous System Number (ASN) of the local gateway.
     * </p>
     * 
     * @return The Border Gateway Protocol (BGP) Autonomous System Number (ASN) of the local gateway.
     */
    public final Integer localBgpAsn() {
        return localBgpAsn;
    }

    /**
     * <p>
     * The peer BGP ASN.
     * </p>
     * 
     * @return The peer BGP ASN.
     */
    public final Integer peerBgpAsn() {
        return peerBgpAsn;
    }

    /**
     * <p>
     * The extended 32-bit ASN of the BGP peer for use with larger ASN values.
     * </p>
     * 
     * @return The extended 32-bit ASN of the BGP peer for use with larger ASN values.
     */
    public final Long peerBgpAsnExtended() {
        return peerBgpAsnExtended;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the local gateway virtual interface.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the local gateway virtual interface.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags assigned to the virtual interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the virtual interface.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The current state of the local gateway virtual interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationState} will return
     * {@link LocalGatewayVirtualInterfaceConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #configurationStateAsString}.
     * </p>
     * 
     * @return The current state of the local gateway virtual interface.
     * @see LocalGatewayVirtualInterfaceConfigurationState
     */
    public final LocalGatewayVirtualInterfaceConfigurationState configurationState() {
        return LocalGatewayVirtualInterfaceConfigurationState.fromValue(configurationState);
    }

    /**
     * <p>
     * The current state of the local gateway virtual interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationState} will return
     * {@link LocalGatewayVirtualInterfaceConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #configurationStateAsString}.
     * </p>
     * 
     * @return The current state of the local gateway virtual interface.
     * @see LocalGatewayVirtualInterfaceConfigurationState
     */
    public final String configurationStateAsString() {
        return configurationState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayVirtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayVirtualInterfaceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayVirtualInterfaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(outpostLagId());
        hashCode = 31 * hashCode + Objects.hashCode(vlan());
        hashCode = 31 * hashCode + Objects.hashCode(localAddress());
        hashCode = 31 * hashCode + Objects.hashCode(peerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(localBgpAsn());
        hashCode = 31 * hashCode + Objects.hashCode(peerBgpAsn());
        hashCode = 31 * hashCode + Objects.hashCode(peerBgpAsnExtended());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(configurationStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalGatewayVirtualInterface)) {
            return false;
        }
        LocalGatewayVirtualInterface other = (LocalGatewayVirtualInterface) obj;
        return Objects.equals(localGatewayVirtualInterfaceId(), other.localGatewayVirtualInterfaceId())
                && Objects.equals(localGatewayId(), other.localGatewayId())
                && Objects.equals(localGatewayVirtualInterfaceGroupId(), other.localGatewayVirtualInterfaceGroupId())
                && Objects.equals(localGatewayVirtualInterfaceArn(), other.localGatewayVirtualInterfaceArn())
                && Objects.equals(outpostLagId(), other.outpostLagId()) && Objects.equals(vlan(), other.vlan())
                && Objects.equals(localAddress(), other.localAddress()) && Objects.equals(peerAddress(), other.peerAddress())
                && Objects.equals(localBgpAsn(), other.localBgpAsn()) && Objects.equals(peerBgpAsn(), other.peerBgpAsn())
                && Objects.equals(peerBgpAsnExtended(), other.peerBgpAsnExtended()) && Objects.equals(ownerId(), other.ownerId())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(configurationStateAsString(), other.configurationStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LocalGatewayVirtualInterface")
                .add("LocalGatewayVirtualInterfaceId", localGatewayVirtualInterfaceId()).add("LocalGatewayId", localGatewayId())
                .add("LocalGatewayVirtualInterfaceGroupId", localGatewayVirtualInterfaceGroupId())
                .add("LocalGatewayVirtualInterfaceArn", localGatewayVirtualInterfaceArn()).add("OutpostLagId", outpostLagId())
                .add("Vlan", vlan()).add("LocalAddress", localAddress()).add("PeerAddress", peerAddress())
                .add("LocalBgpAsn", localBgpAsn()).add("PeerBgpAsn", peerBgpAsn())
                .add("PeerBgpAsnExtended", peerBgpAsnExtended()).add("OwnerId", ownerId()).add("Tags", hasTags() ? tags() : null)
                .add("ConfigurationState", configurationStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalGatewayVirtualInterfaceId":
            return Optional.ofNullable(clazz.cast(localGatewayVirtualInterfaceId()));
        case "LocalGatewayId":
            return Optional.ofNullable(clazz.cast(localGatewayId()));
        case "LocalGatewayVirtualInterfaceGroupId":
            return Optional.ofNullable(clazz.cast(localGatewayVirtualInterfaceGroupId()));
        case "LocalGatewayVirtualInterfaceArn":
            return Optional.ofNullable(clazz.cast(localGatewayVirtualInterfaceArn()));
        case "OutpostLagId":
            return Optional.ofNullable(clazz.cast(outpostLagId()));
        case "Vlan":
            return Optional.ofNullable(clazz.cast(vlan()));
        case "LocalAddress":
            return Optional.ofNullable(clazz.cast(localAddress()));
        case "PeerAddress":
            return Optional.ofNullable(clazz.cast(peerAddress()));
        case "LocalBgpAsn":
            return Optional.ofNullable(clazz.cast(localBgpAsn()));
        case "PeerBgpAsn":
            return Optional.ofNullable(clazz.cast(peerBgpAsn()));
        case "PeerBgpAsnExtended":
            return Optional.ofNullable(clazz.cast(peerBgpAsnExtended()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ConfigurationState":
            return Optional.ofNullable(clazz.cast(configurationStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LocalGatewayVirtualInterfaceId", LOCAL_GATEWAY_VIRTUAL_INTERFACE_ID_FIELD);
        map.put("LocalGatewayId", LOCAL_GATEWAY_ID_FIELD);
        map.put("LocalGatewayVirtualInterfaceGroupId", LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD);
        map.put("LocalGatewayVirtualInterfaceArn", LOCAL_GATEWAY_VIRTUAL_INTERFACE_ARN_FIELD);
        map.put("OutpostLagId", OUTPOST_LAG_ID_FIELD);
        map.put("Vlan", VLAN_FIELD);
        map.put("LocalAddress", LOCAL_ADDRESS_FIELD);
        map.put("PeerAddress", PEER_ADDRESS_FIELD);
        map.put("LocalBgpAsn", LOCAL_BGP_ASN_FIELD);
        map.put("PeerBgpAsn", PEER_BGP_ASN_FIELD);
        map.put("PeerBgpAsnExtended", PEER_BGP_ASN_EXTENDED_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("ConfigurationState", CONFIGURATION_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LocalGatewayVirtualInterface, T> g) {
        return obj -> g.apply((LocalGatewayVirtualInterface) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LocalGatewayVirtualInterface> {
        /**
         * <p>
         * The ID of the virtual interface.
         * </p>
         * 
         * @param localGatewayVirtualInterfaceId
         *        The ID of the virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayVirtualInterfaceId(String localGatewayVirtualInterfaceId);

        /**
         * <p>
         * The ID of the local gateway.
         * </p>
         * 
         * @param localGatewayId
         *        The ID of the local gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayId(String localGatewayId);

        /**
         * <p>
         * The ID of the local gateway virtual interface group.
         * </p>
         * 
         * @param localGatewayVirtualInterfaceGroupId
         *        The ID of the local gateway virtual interface group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId);

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the local gateway virtual interface.
         * </p>
         * 
         * @param localGatewayVirtualInterfaceArn
         *        The Amazon Resource Number (ARN) of the local gateway virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayVirtualInterfaceArn(String localGatewayVirtualInterfaceArn);

        /**
         * <p>
         * The Outpost LAG ID.
         * </p>
         * 
         * @param outpostLagId
         *        The Outpost LAG ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostLagId(String outpostLagId);

        /**
         * <p>
         * The ID of the VLAN.
         * </p>
         * 
         * @param vlan
         *        The ID of the VLAN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vlan(Integer vlan);

        /**
         * <p>
         * The local address.
         * </p>
         * 
         * @param localAddress
         *        The local address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localAddress(String localAddress);

        /**
         * <p>
         * The peer address.
         * </p>
         * 
         * @param peerAddress
         *        The peer address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerAddress(String peerAddress);

        /**
         * <p>
         * The Border Gateway Protocol (BGP) Autonomous System Number (ASN) of the local gateway.
         * </p>
         * 
         * @param localBgpAsn
         *        The Border Gateway Protocol (BGP) Autonomous System Number (ASN) of the local gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localBgpAsn(Integer localBgpAsn);

        /**
         * <p>
         * The peer BGP ASN.
         * </p>
         * 
         * @param peerBgpAsn
         *        The peer BGP ASN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerBgpAsn(Integer peerBgpAsn);

        /**
         * <p>
         * The extended 32-bit ASN of the BGP peer for use with larger ASN values.
         * </p>
         * 
         * @param peerBgpAsnExtended
         *        The extended 32-bit ASN of the BGP peer for use with larger ASN values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerBgpAsnExtended(Long peerBgpAsnExtended);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the local gateway virtual interface.
         * </p>
         * 
         * @param ownerId
         *        The ID of the Amazon Web Services account that owns the local gateway virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The tags assigned to the virtual interface.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags assigned to the virtual interface.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags assigned to the virtual interface.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The current state of the local gateway virtual interface.
         * </p>
         * 
         * @param configurationState
         *        The current state of the local gateway virtual interface.
         * @see LocalGatewayVirtualInterfaceConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocalGatewayVirtualInterfaceConfigurationState
         */
        Builder configurationState(String configurationState);

        /**
         * <p>
         * The current state of the local gateway virtual interface.
         * </p>
         * 
         * @param configurationState
         *        The current state of the local gateway virtual interface.
         * @see LocalGatewayVirtualInterfaceConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocalGatewayVirtualInterfaceConfigurationState
         */
        Builder configurationState(LocalGatewayVirtualInterfaceConfigurationState configurationState);
    }

    static final class BuilderImpl implements Builder {
        private String localGatewayVirtualInterfaceId;

        private String localGatewayId;

        private String localGatewayVirtualInterfaceGroupId;

        private String localGatewayVirtualInterfaceArn;

        private String outpostLagId;

        private Integer vlan;

        private String localAddress;

        private String peerAddress;

        private Integer localBgpAsn;

        private Integer peerBgpAsn;

        private Long peerBgpAsnExtended;

        private String ownerId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String configurationState;

        private BuilderImpl() {
        }

        private BuilderImpl(LocalGatewayVirtualInterface model) {
            localGatewayVirtualInterfaceId(model.localGatewayVirtualInterfaceId);
            localGatewayId(model.localGatewayId);
            localGatewayVirtualInterfaceGroupId(model.localGatewayVirtualInterfaceGroupId);
            localGatewayVirtualInterfaceArn(model.localGatewayVirtualInterfaceArn);
            outpostLagId(model.outpostLagId);
            vlan(model.vlan);
            localAddress(model.localAddress);
            peerAddress(model.peerAddress);
            localBgpAsn(model.localBgpAsn);
            peerBgpAsn(model.peerBgpAsn);
            peerBgpAsnExtended(model.peerBgpAsnExtended);
            ownerId(model.ownerId);
            tags(model.tags);
            configurationState(model.configurationState);
        }

        public final String getLocalGatewayVirtualInterfaceId() {
            return localGatewayVirtualInterfaceId;
        }

        public final void setLocalGatewayVirtualInterfaceId(String localGatewayVirtualInterfaceId) {
            this.localGatewayVirtualInterfaceId = localGatewayVirtualInterfaceId;
        }

        @Override
        public final Builder localGatewayVirtualInterfaceId(String localGatewayVirtualInterfaceId) {
            this.localGatewayVirtualInterfaceId = localGatewayVirtualInterfaceId;
            return this;
        }

        public final String getLocalGatewayId() {
            return localGatewayId;
        }

        public final void setLocalGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
        }

        @Override
        public final Builder localGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
            return this;
        }

        public final String getLocalGatewayVirtualInterfaceGroupId() {
            return localGatewayVirtualInterfaceGroupId;
        }

        public final void setLocalGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
        }

        @Override
        public final Builder localGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
            return this;
        }

        public final String getLocalGatewayVirtualInterfaceArn() {
            return localGatewayVirtualInterfaceArn;
        }

        public final void setLocalGatewayVirtualInterfaceArn(String localGatewayVirtualInterfaceArn) {
            this.localGatewayVirtualInterfaceArn = localGatewayVirtualInterfaceArn;
        }

        @Override
        public final Builder localGatewayVirtualInterfaceArn(String localGatewayVirtualInterfaceArn) {
            this.localGatewayVirtualInterfaceArn = localGatewayVirtualInterfaceArn;
            return this;
        }

        public final String getOutpostLagId() {
            return outpostLagId;
        }

        public final void setOutpostLagId(String outpostLagId) {
            this.outpostLagId = outpostLagId;
        }

        @Override
        public final Builder outpostLagId(String outpostLagId) {
            this.outpostLagId = outpostLagId;
            return this;
        }

        public final Integer getVlan() {
            return vlan;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final String getLocalAddress() {
            return localAddress;
        }

        public final void setLocalAddress(String localAddress) {
            this.localAddress = localAddress;
        }

        @Override
        public final Builder localAddress(String localAddress) {
            this.localAddress = localAddress;
            return this;
        }

        public final String getPeerAddress() {
            return peerAddress;
        }

        public final void setPeerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
        }

        @Override
        public final Builder peerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        public final Integer getLocalBgpAsn() {
            return localBgpAsn;
        }

        public final void setLocalBgpAsn(Integer localBgpAsn) {
            this.localBgpAsn = localBgpAsn;
        }

        @Override
        public final Builder localBgpAsn(Integer localBgpAsn) {
            this.localBgpAsn = localBgpAsn;
            return this;
        }

        public final Integer getPeerBgpAsn() {
            return peerBgpAsn;
        }

        public final void setPeerBgpAsn(Integer peerBgpAsn) {
            this.peerBgpAsn = peerBgpAsn;
        }

        @Override
        public final Builder peerBgpAsn(Integer peerBgpAsn) {
            this.peerBgpAsn = peerBgpAsn;
            return this;
        }

        public final Long getPeerBgpAsnExtended() {
            return peerBgpAsnExtended;
        }

        public final void setPeerBgpAsnExtended(Long peerBgpAsnExtended) {
            this.peerBgpAsnExtended = peerBgpAsnExtended;
        }

        @Override
        public final Builder peerBgpAsnExtended(Long peerBgpAsnExtended) {
            this.peerBgpAsnExtended = peerBgpAsnExtended;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getConfigurationState() {
            return configurationState;
        }

        public final void setConfigurationState(String configurationState) {
            this.configurationState = configurationState;
        }

        @Override
        public final Builder configurationState(String configurationState) {
            this.configurationState = configurationState;
            return this;
        }

        @Override
        public final Builder configurationState(LocalGatewayVirtualInterfaceConfigurationState configurationState) {
            this.configurationState(configurationState == null ? null : configurationState.toString());
            return this;
        }

        @Override
        public LocalGatewayVirtualInterface build() {
            return new LocalGatewayVirtualInterface(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
