/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetImageAncestryResponse extends Ec2Response implements
        ToCopyableBuilder<GetImageAncestryResponse.Builder, GetImageAncestryResponse> {
    private static final SdkField<List<ImageAncestryEntry>> IMAGE_ANCESTRY_ENTRIES_FIELD = SdkField
            .<List<ImageAncestryEntry>> builder(MarshallingType.LIST)
            .memberName("ImageAncestryEntries")
            .getter(getter(GetImageAncestryResponse::imageAncestryEntries))
            .setter(setter(Builder::imageAncestryEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageAncestryEntrySet")
                    .unmarshallLocationName("imageAncestryEntrySet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ImageAncestryEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageAncestryEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_ANCESTRY_ENTRIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ImageAncestryEntry> imageAncestryEntries;

    private GetImageAncestryResponse(BuilderImpl builder) {
        super(builder);
        this.imageAncestryEntries = builder.imageAncestryEntries;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageAncestryEntries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImageAncestryEntries() {
        return imageAncestryEntries != null && !(imageAncestryEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of entries in the AMI ancestry chain, from the specified AMI to the root AMI.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageAncestryEntries} method.
     * </p>
     * 
     * @return A list of entries in the AMI ancestry chain, from the specified AMI to the root AMI.
     */
    public final List<ImageAncestryEntry> imageAncestryEntries() {
        return imageAncestryEntries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasImageAncestryEntries() ? imageAncestryEntries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetImageAncestryResponse)) {
            return false;
        }
        GetImageAncestryResponse other = (GetImageAncestryResponse) obj;
        return hasImageAncestryEntries() == other.hasImageAncestryEntries()
                && Objects.equals(imageAncestryEntries(), other.imageAncestryEntries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetImageAncestryResponse")
                .add("ImageAncestryEntries", hasImageAncestryEntries() ? imageAncestryEntries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageAncestryEntries":
            return Optional.ofNullable(clazz.cast(imageAncestryEntries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ImageAncestryEntrySet", IMAGE_ANCESTRY_ENTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetImageAncestryResponse, T> g) {
        return obj -> g.apply((GetImageAncestryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetImageAncestryResponse> {
        /**
         * <p>
         * A list of entries in the AMI ancestry chain, from the specified AMI to the root AMI.
         * </p>
         * 
         * @param imageAncestryEntries
         *        A list of entries in the AMI ancestry chain, from the specified AMI to the root AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageAncestryEntries(Collection<ImageAncestryEntry> imageAncestryEntries);

        /**
         * <p>
         * A list of entries in the AMI ancestry chain, from the specified AMI to the root AMI.
         * </p>
         * 
         * @param imageAncestryEntries
         *        A list of entries in the AMI ancestry chain, from the specified AMI to the root AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageAncestryEntries(ImageAncestryEntry... imageAncestryEntries);

        /**
         * <p>
         * A list of entries in the AMI ancestry chain, from the specified AMI to the root AMI.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ImageAncestryEntry.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.ImageAncestryEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ImageAncestryEntry.Builder#build()} is called immediately
         * and its result is passed to {@link #imageAncestryEntries(List<ImageAncestryEntry>)}.
         * 
         * @param imageAncestryEntries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ImageAncestryEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageAncestryEntries(java.util.Collection<ImageAncestryEntry>)
         */
        Builder imageAncestryEntries(Consumer<ImageAncestryEntry.Builder>... imageAncestryEntries);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<ImageAncestryEntry> imageAncestryEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetImageAncestryResponse model) {
            super(model);
            imageAncestryEntries(model.imageAncestryEntries);
        }

        public final List<ImageAncestryEntry.Builder> getImageAncestryEntries() {
            List<ImageAncestryEntry.Builder> result = ImageAncestryEntryListCopier.copyToBuilder(this.imageAncestryEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageAncestryEntries(Collection<ImageAncestryEntry.BuilderImpl> imageAncestryEntries) {
            this.imageAncestryEntries = ImageAncestryEntryListCopier.copyFromBuilder(imageAncestryEntries);
        }

        @Override
        public final Builder imageAncestryEntries(Collection<ImageAncestryEntry> imageAncestryEntries) {
            this.imageAncestryEntries = ImageAncestryEntryListCopier.copy(imageAncestryEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageAncestryEntries(ImageAncestryEntry... imageAncestryEntries) {
            imageAncestryEntries(Arrays.asList(imageAncestryEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageAncestryEntries(Consumer<ImageAncestryEntry.Builder>... imageAncestryEntries) {
            imageAncestryEntries(Stream.of(imageAncestryEntries).map(c -> ImageAncestryEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetImageAncestryResponse build() {
            return new GetImageAncestryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
