/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNatGatewayRequest extends Ec2Request implements
        ToCopyableBuilder<CreateNatGatewayRequest.Builder, CreateNatGatewayRequest> {
    private static final SdkField<String> AVAILABILITY_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityMode")
            .getter(getter(CreateNatGatewayRequest::availabilityModeAsString))
            .setter(setter(Builder::availabilityMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityMode")
                    .unmarshallLocationName("AvailabilityMode").build()).build();

    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AllocationId")
            .getter(getter(CreateNatGatewayRequest::allocationId))
            .setter(setter(Builder::allocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId")
                    .unmarshallLocationName("AllocationId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateNatGatewayRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreateNatGatewayRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetId")
            .getter(getter(CreateNatGatewayRequest::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("SubnetId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcId")
            .getter(getter(CreateNatGatewayRequest::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("VpcId").build()).build();

    private static final SdkField<List<AvailabilityZoneAddress>> AVAILABILITY_ZONE_ADDRESSES_FIELD = SdkField
            .<List<AvailabilityZoneAddress>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZoneAddresses")
            .getter(getter(CreateNatGatewayRequest::availabilityZoneAddresses))
            .setter(setter(Builder::availabilityZoneAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneAddress")
                    .unmarshallLocationName("AvailabilityZoneAddress").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AvailabilityZoneAddress")
                            .memberFieldInfo(
                                    SdkField.<AvailabilityZoneAddress> builder(MarshallingType.SDK_POJO)
                                            .constructor(AvailabilityZoneAddress::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AvailabilityZoneAddress")
                                                    .unmarshallLocationName("AvailabilityZoneAddress").build()).build()).build())
            .build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateNatGatewayRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> CONNECTIVITY_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConnectivityType")
            .getter(getter(CreateNatGatewayRequest::connectivityTypeAsString))
            .setter(setter(Builder::connectivityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectivityType")
                    .unmarshallLocationName("ConnectivityType").build()).build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateIpAddress")
            .getter(getter(CreateNatGatewayRequest::privateIpAddress))
            .setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress")
                    .unmarshallLocationName("PrivateIpAddress").build()).build();

    private static final SdkField<List<String>> SECONDARY_ALLOCATION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecondaryAllocationIds")
            .getter(getter(CreateNatGatewayRequest::secondaryAllocationIds))
            .setter(setter(Builder::secondaryAllocationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryAllocationId")
                    .unmarshallLocationName("SecondaryAllocationId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AllocationId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AllocationId").unmarshallLocationName("AllocationId").build())
                                            .build()).build()).build();

    private static final SdkField<List<String>> SECONDARY_PRIVATE_IP_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecondaryPrivateIpAddresses")
            .getter(getter(CreateNatGatewayRequest::secondaryPrivateIpAddresses))
            .setter(setter(Builder::secondaryPrivateIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryPrivateIpAddress")
                    .unmarshallLocationName("SecondaryPrivateIpAddress").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SecondaryPrivateIpAddressCount")
            .getter(getter(CreateNatGatewayRequest::secondaryPrivateIpAddressCount))
            .setter(setter(Builder::secondaryPrivateIpAddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryPrivateIpAddressCount")
                    .unmarshallLocationName("SecondaryPrivateIpAddressCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_MODE_FIELD,
            ALLOCATION_ID_FIELD, CLIENT_TOKEN_FIELD, DRY_RUN_FIELD, SUBNET_ID_FIELD, VPC_ID_FIELD,
            AVAILABILITY_ZONE_ADDRESSES_FIELD, TAG_SPECIFICATIONS_FIELD, CONNECTIVITY_TYPE_FIELD, PRIVATE_IP_ADDRESS_FIELD,
            SECONDARY_ALLOCATION_IDS_FIELD, SECONDARY_PRIVATE_IP_ADDRESSES_FIELD, SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String availabilityMode;

    private final String allocationId;

    private final String clientToken;

    private final Boolean dryRun;

    private final String subnetId;

    private final String vpcId;

    private final List<AvailabilityZoneAddress> availabilityZoneAddresses;

    private final List<TagSpecification> tagSpecifications;

    private final String connectivityType;

    private final String privateIpAddress;

    private final List<String> secondaryAllocationIds;

    private final List<String> secondaryPrivateIpAddresses;

    private final Integer secondaryPrivateIpAddressCount;

    private CreateNatGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityMode = builder.availabilityMode;
        this.allocationId = builder.allocationId;
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
        this.availabilityZoneAddresses = builder.availabilityZoneAddresses;
        this.tagSpecifications = builder.tagSpecifications;
        this.connectivityType = builder.connectivityType;
        this.privateIpAddress = builder.privateIpAddress;
        this.secondaryAllocationIds = builder.secondaryAllocationIds;
        this.secondaryPrivateIpAddresses = builder.secondaryPrivateIpAddresses;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
    }

    /**
     * <p>
     * Specifies whether to create a zonal (single-AZ) or regional (multi-AZ) NAT gateway. Defaults to
     * <code>zonal</code>.
     * </p>
     * <p>
     * A zonal NAT gateway is a NAT Gateway that provides redundancy and scalability within a single availability zone.
     * A regional NAT gateway is a single NAT Gateway that works across multiple availability zones (AZs) in your VPC,
     * providing redundancy, scalability and availability across all the AZs in a Region.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateways-regional.html">Regional NAT gateways for
     * automatic multi-AZ expansion</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #availabilityMode}
     * will return {@link AvailabilityMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #availabilityModeAsString}.
     * </p>
     * 
     * @return Specifies whether to create a zonal (single-AZ) or regional (multi-AZ) NAT gateway. Defaults to
     *         <code>zonal</code>.</p>
     *         <p>
     *         A zonal NAT gateway is a NAT Gateway that provides redundancy and scalability within a single
     *         availability zone. A regional NAT gateway is a single NAT Gateway that works across multiple availability
     *         zones (AZs) in your VPC, providing redundancy, scalability and availability across all the AZs in a
     *         Region.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateways-regional.html">Regional NAT gateways
     *         for automatic multi-AZ expansion</a> in the <i>Amazon VPC User Guide</i>.
     * @see AvailabilityMode
     */
    public final AvailabilityMode availabilityMode() {
        return AvailabilityMode.fromValue(availabilityMode);
    }

    /**
     * <p>
     * Specifies whether to create a zonal (single-AZ) or regional (multi-AZ) NAT gateway. Defaults to
     * <code>zonal</code>.
     * </p>
     * <p>
     * A zonal NAT gateway is a NAT Gateway that provides redundancy and scalability within a single availability zone.
     * A regional NAT gateway is a single NAT Gateway that works across multiple availability zones (AZs) in your VPC,
     * providing redundancy, scalability and availability across all the AZs in a Region.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateways-regional.html">Regional NAT gateways for
     * automatic multi-AZ expansion</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #availabilityMode}
     * will return {@link AvailabilityMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #availabilityModeAsString}.
     * </p>
     * 
     * @return Specifies whether to create a zonal (single-AZ) or regional (multi-AZ) NAT gateway. Defaults to
     *         <code>zonal</code>.</p>
     *         <p>
     *         A zonal NAT gateway is a NAT Gateway that provides redundancy and scalability within a single
     *         availability zone. A regional NAT gateway is a single NAT Gateway that works across multiple availability
     *         zones (AZs) in your VPC, providing redundancy, scalability and availability across all the AZs in a
     *         Region.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateways-regional.html">Regional NAT gateways
     *         for automatic multi-AZ expansion</a> in the <i>Amazon VPC User Guide</i>.
     * @see AvailabilityMode
     */
    public final String availabilityModeAsString() {
        return availabilityMode;
    }

    /**
     * <p>
     * [Public NAT gateways only] The allocation ID of an Elastic IP address to associate with the NAT gateway. You
     * cannot specify an Elastic IP address with a private NAT gateway. If the Elastic IP address is associated with
     * another resource, you must first disassociate it.
     * </p>
     * 
     * @return [Public NAT gateways only] The allocation ID of an Elastic IP address to associate with the NAT gateway.
     *         You cannot specify an Elastic IP address with a private NAT gateway. If the Elastic IP address is
     *         associated with another resource, you must first disassociate it.
     */
    public final String allocationId() {
        return allocationId;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
     * idempotency</a>.
     * </p>
     * <p>
     * Constraint: Maximum 64 ASCII characters.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
     *         idempotency</a>.</p>
     *         <p>
     *         Constraint: Maximum 64 ASCII characters.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the subnet in which to create the NAT gateway.
     * </p>
     * 
     * @return The ID of the subnet in which to create the NAT gateway.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The ID of the VPC where you want to create a regional NAT gateway.
     * </p>
     * 
     * @return The ID of the VPC where you want to create a regional NAT gateway.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZoneAddresses property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAvailabilityZoneAddresses() {
        return availabilityZoneAddresses != null && !(availabilityZoneAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For regional NAT gateways only: Specifies which Availability Zones you want the NAT gateway to support and the
     * Elastic IP addresses (EIPs) to use in each AZ. The regional NAT gateway uses these EIPs to handle outbound NAT
     * traffic from their respective AZs. If not specified, the NAT gateway will automatically expand to new AZs and
     * associate EIPs upon detection of an elastic network interface. If you specify this parameter, auto-expansion is
     * disabled and you must manually manage AZ coverage.
     * </p>
     * <p>
     * A regional NAT gateway is a single NAT Gateway that works across multiple availability zones (AZs) in your VPC,
     * providing redundancy, scalability and availability across all the AZs in a Region.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateways-regional.html">Regional NAT gateways for
     * automatic multi-AZ expansion</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZoneAddresses} method.
     * </p>
     * 
     * @return For regional NAT gateways only: Specifies which Availability Zones you want the NAT gateway to support
     *         and the Elastic IP addresses (EIPs) to use in each AZ. The regional NAT gateway uses these EIPs to handle
     *         outbound NAT traffic from their respective AZs. If not specified, the NAT gateway will automatically
     *         expand to new AZs and associate EIPs upon detection of an elastic network interface. If you specify this
     *         parameter, auto-expansion is disabled and you must manually manage AZ coverage.</p>
     *         <p>
     *         A regional NAT gateway is a single NAT Gateway that works across multiple availability zones (AZs) in
     *         your VPC, providing redundancy, scalability and availability across all the AZs in a Region.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateways-regional.html">Regional NAT gateways
     *         for automatic multi-AZ expansion</a> in the <i>Amazon VPC User Guide</i>.
     */
    public final List<AvailabilityZoneAddress> availabilityZoneAddresses() {
        return availabilityZoneAddresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to assign to the NAT gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to assign to the NAT gateway.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * Indicates whether the NAT gateway supports public or private connectivity. The default is public connectivity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectivityType}
     * will return {@link ConnectivityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectivityTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the NAT gateway supports public or private connectivity. The default is public
     *         connectivity.
     * @see ConnectivityType
     */
    public final ConnectivityType connectivityType() {
        return ConnectivityType.fromValue(connectivityType);
    }

    /**
     * <p>
     * Indicates whether the NAT gateway supports public or private connectivity. The default is public connectivity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectivityType}
     * will return {@link ConnectivityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectivityTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the NAT gateway supports public or private connectivity. The default is public
     *         connectivity.
     * @see ConnectivityType
     */
    public final String connectivityTypeAsString() {
        return connectivityType;
    }

    /**
     * <p>
     * The private IPv4 address to assign to the NAT gateway. If you don't provide an address, a private IPv4 address
     * will be automatically assigned.
     * </p>
     * 
     * @return The private IPv4 address to assign to the NAT gateway. If you don't provide an address, a private IPv4
     *         address will be automatically assigned.
     */
    public final String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecondaryAllocationIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSecondaryAllocationIds() {
        return secondaryAllocationIds != null && !(secondaryAllocationIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Secondary EIP allocation IDs. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Create a NAT gateway</a> in
     * the <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecondaryAllocationIds} method.
     * </p>
     * 
     * @return Secondary EIP allocation IDs. For more information, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Create a NAT
     *         gateway</a> in the <i>Amazon VPC User Guide</i>.
     */
    public final List<String> secondaryAllocationIds() {
        return secondaryAllocationIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecondaryPrivateIpAddresses property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSecondaryPrivateIpAddresses() {
        return secondaryPrivateIpAddresses != null && !(secondaryPrivateIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Secondary private IPv4 addresses. For more information about secondary addresses, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Create a NAT gateway</a> in
     * the <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecondaryPrivateIpAddresses} method.
     * </p>
     * 
     * @return Secondary private IPv4 addresses. For more information about secondary addresses, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Create a NAT
     *         gateway</a> in the <i>Amazon VPC User Guide</i>.
     */
    public final List<String> secondaryPrivateIpAddresses() {
        return secondaryPrivateIpAddresses;
    }

    /**
     * <p>
     * [Private NAT gateway only] The number of secondary private IPv4 addresses you want to assign to the NAT gateway.
     * For more information about secondary addresses, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Create a NAT gateway</a> in
     * the <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @return [Private NAT gateway only] The number of secondary private IPv4 addresses you want to assign to the NAT
     *         gateway. For more information about secondary addresses, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Create a NAT
     *         gateway</a> in the <i>Amazon VPC User Guide</i>.
     */
    public final Integer secondaryPrivateIpAddressCount() {
        return secondaryPrivateIpAddressCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(availabilityModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZoneAddresses() ? availabilityZoneAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectivityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecondaryAllocationIds() ? secondaryAllocationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecondaryPrivateIpAddresses() ? secondaryPrivateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(secondaryPrivateIpAddressCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNatGatewayRequest)) {
            return false;
        }
        CreateNatGatewayRequest other = (CreateNatGatewayRequest) obj;
        return Objects.equals(availabilityModeAsString(), other.availabilityModeAsString())
                && Objects.equals(allocationId(), other.allocationId()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(dryRun(), other.dryRun()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(vpcId(), other.vpcId())
                && hasAvailabilityZoneAddresses() == other.hasAvailabilityZoneAddresses()
                && Objects.equals(availabilityZoneAddresses(), other.availabilityZoneAddresses())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && Objects.equals(connectivityTypeAsString(), other.connectivityTypeAsString())
                && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && hasSecondaryAllocationIds() == other.hasSecondaryAllocationIds()
                && Objects.equals(secondaryAllocationIds(), other.secondaryAllocationIds())
                && hasSecondaryPrivateIpAddresses() == other.hasSecondaryPrivateIpAddresses()
                && Objects.equals(secondaryPrivateIpAddresses(), other.secondaryPrivateIpAddresses())
                && Objects.equals(secondaryPrivateIpAddressCount(), other.secondaryPrivateIpAddressCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNatGatewayRequest").add("AvailabilityMode", availabilityModeAsString())
                .add("AllocationId", allocationId()).add("ClientToken", clientToken()).add("DryRun", dryRun())
                .add("SubnetId", subnetId()).add("VpcId", vpcId())
                .add("AvailabilityZoneAddresses", hasAvailabilityZoneAddresses() ? availabilityZoneAddresses() : null)
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null)
                .add("ConnectivityType", connectivityTypeAsString()).add("PrivateIpAddress", privateIpAddress())
                .add("SecondaryAllocationIds", hasSecondaryAllocationIds() ? secondaryAllocationIds() : null)
                .add("SecondaryPrivateIpAddresses", hasSecondaryPrivateIpAddresses() ? secondaryPrivateIpAddresses() : null)
                .add("SecondaryPrivateIpAddressCount", secondaryPrivateIpAddressCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityMode":
            return Optional.ofNullable(clazz.cast(availabilityModeAsString()));
        case "AllocationId":
            return Optional.ofNullable(clazz.cast(allocationId()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "AvailabilityZoneAddresses":
            return Optional.ofNullable(clazz.cast(availabilityZoneAddresses()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "ConnectivityType":
            return Optional.ofNullable(clazz.cast(connectivityTypeAsString()));
        case "PrivateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        case "SecondaryAllocationIds":
            return Optional.ofNullable(clazz.cast(secondaryAllocationIds()));
        case "SecondaryPrivateIpAddresses":
            return Optional.ofNullable(clazz.cast(secondaryPrivateIpAddresses()));
        case "SecondaryPrivateIpAddressCount":
            return Optional.ofNullable(clazz.cast(secondaryPrivateIpAddressCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AvailabilityMode", AVAILABILITY_MODE_FIELD);
        map.put("AllocationId", ALLOCATION_ID_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("AvailabilityZoneAddress", AVAILABILITY_ZONE_ADDRESSES_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("ConnectivityType", CONNECTIVITY_TYPE_FIELD);
        map.put("PrivateIpAddress", PRIVATE_IP_ADDRESS_FIELD);
        map.put("SecondaryAllocationId", SECONDARY_ALLOCATION_IDS_FIELD);
        map.put("SecondaryPrivateIpAddress", SECONDARY_PRIVATE_IP_ADDRESSES_FIELD);
        map.put("SecondaryPrivateIpAddressCount", SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateNatGatewayRequest, T> g) {
        return obj -> g.apply((CreateNatGatewayRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateNatGatewayRequest> {
        /**
         * <p>
         * Specifies whether to create a zonal (single-AZ) or regional (multi-AZ) NAT gateway. Defaults to
         * <code>zonal</code>.
         * </p>
         * <p>
         * A zonal NAT gateway is a NAT Gateway that provides redundancy and scalability within a single availability
         * zone. A regional NAT gateway is a single NAT Gateway that works across multiple availability zones (AZs) in
         * your VPC, providing redundancy, scalability and availability across all the AZs in a Region.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateways-regional.html">Regional NAT gateways for
         * automatic multi-AZ expansion</a> in the <i>Amazon VPC User Guide</i>.
         * </p>
         * 
         * @param availabilityMode
         *        Specifies whether to create a zonal (single-AZ) or regional (multi-AZ) NAT gateway. Defaults to
         *        <code>zonal</code>.</p>
         *        <p>
         *        A zonal NAT gateway is a NAT Gateway that provides redundancy and scalability within a single
         *        availability zone. A regional NAT gateway is a single NAT Gateway that works across multiple
         *        availability zones (AZs) in your VPC, providing redundancy, scalability and availability across all
         *        the AZs in a Region.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateways-regional.html">Regional NAT
         *        gateways for automatic multi-AZ expansion</a> in the <i>Amazon VPC User Guide</i>.
         * @see AvailabilityMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailabilityMode
         */
        Builder availabilityMode(String availabilityMode);

        /**
         * <p>
         * Specifies whether to create a zonal (single-AZ) or regional (multi-AZ) NAT gateway. Defaults to
         * <code>zonal</code>.
         * </p>
         * <p>
         * A zonal NAT gateway is a NAT Gateway that provides redundancy and scalability within a single availability
         * zone. A regional NAT gateway is a single NAT Gateway that works across multiple availability zones (AZs) in
         * your VPC, providing redundancy, scalability and availability across all the AZs in a Region.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateways-regional.html">Regional NAT gateways for
         * automatic multi-AZ expansion</a> in the <i>Amazon VPC User Guide</i>.
         * </p>
         * 
         * @param availabilityMode
         *        Specifies whether to create a zonal (single-AZ) or regional (multi-AZ) NAT gateway. Defaults to
         *        <code>zonal</code>.</p>
         *        <p>
         *        A zonal NAT gateway is a NAT Gateway that provides redundancy and scalability within a single
         *        availability zone. A regional NAT gateway is a single NAT Gateway that works across multiple
         *        availability zones (AZs) in your VPC, providing redundancy, scalability and availability across all
         *        the AZs in a Region.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateways-regional.html">Regional NAT
         *        gateways for automatic multi-AZ expansion</a> in the <i>Amazon VPC User Guide</i>.
         * @see AvailabilityMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailabilityMode
         */
        Builder availabilityMode(AvailabilityMode availabilityMode);

        /**
         * <p>
         * [Public NAT gateways only] The allocation ID of an Elastic IP address to associate with the NAT gateway. You
         * cannot specify an Elastic IP address with a private NAT gateway. If the Elastic IP address is associated with
         * another resource, you must first disassociate it.
         * </p>
         * 
         * @param allocationId
         *        [Public NAT gateways only] The allocation ID of an Elastic IP address to associate with the NAT
         *        gateway. You cannot specify an Elastic IP address with a private NAT gateway. If the Elastic IP
         *        address is associated with another resource, you must first disassociate it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationId(String allocationId);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
         * idempotency</a>.
         * </p>
         * <p>
         * Constraint: Maximum 64 ASCII characters.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
         *        idempotency</a>.</p>
         *        <p>
         *        Constraint: Maximum 64 ASCII characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the subnet in which to create the NAT gateway.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet in which to create the NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The ID of the VPC where you want to create a regional NAT gateway.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC where you want to create a regional NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * For regional NAT gateways only: Specifies which Availability Zones you want the NAT gateway to support and
         * the Elastic IP addresses (EIPs) to use in each AZ. The regional NAT gateway uses these EIPs to handle
         * outbound NAT traffic from their respective AZs. If not specified, the NAT gateway will automatically expand
         * to new AZs and associate EIPs upon detection of an elastic network interface. If you specify this parameter,
         * auto-expansion is disabled and you must manually manage AZ coverage.
         * </p>
         * <p>
         * A regional NAT gateway is a single NAT Gateway that works across multiple availability zones (AZs) in your
         * VPC, providing redundancy, scalability and availability across all the AZs in a Region.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateways-regional.html">Regional NAT gateways for
         * automatic multi-AZ expansion</a> in the <i>Amazon VPC User Guide</i>.
         * </p>
         * 
         * @param availabilityZoneAddresses
         *        For regional NAT gateways only: Specifies which Availability Zones you want the NAT gateway to support
         *        and the Elastic IP addresses (EIPs) to use in each AZ. The regional NAT gateway uses these EIPs to
         *        handle outbound NAT traffic from their respective AZs. If not specified, the NAT gateway will
         *        automatically expand to new AZs and associate EIPs upon detection of an elastic network interface. If
         *        you specify this parameter, auto-expansion is disabled and you must manually manage AZ coverage.</p>
         *        <p>
         *        A regional NAT gateway is a single NAT Gateway that works across multiple availability zones (AZs) in
         *        your VPC, providing redundancy, scalability and availability across all the AZs in a Region.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateways-regional.html">Regional NAT
         *        gateways for automatic multi-AZ expansion</a> in the <i>Amazon VPC User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneAddresses(Collection<AvailabilityZoneAddress> availabilityZoneAddresses);

        /**
         * <p>
         * For regional NAT gateways only: Specifies which Availability Zones you want the NAT gateway to support and
         * the Elastic IP addresses (EIPs) to use in each AZ. The regional NAT gateway uses these EIPs to handle
         * outbound NAT traffic from their respective AZs. If not specified, the NAT gateway will automatically expand
         * to new AZs and associate EIPs upon detection of an elastic network interface. If you specify this parameter,
         * auto-expansion is disabled and you must manually manage AZ coverage.
         * </p>
         * <p>
         * A regional NAT gateway is a single NAT Gateway that works across multiple availability zones (AZs) in your
         * VPC, providing redundancy, scalability and availability across all the AZs in a Region.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateways-regional.html">Regional NAT gateways for
         * automatic multi-AZ expansion</a> in the <i>Amazon VPC User Guide</i>.
         * </p>
         * 
         * @param availabilityZoneAddresses
         *        For regional NAT gateways only: Specifies which Availability Zones you want the NAT gateway to support
         *        and the Elastic IP addresses (EIPs) to use in each AZ. The regional NAT gateway uses these EIPs to
         *        handle outbound NAT traffic from their respective AZs. If not specified, the NAT gateway will
         *        automatically expand to new AZs and associate EIPs upon detection of an elastic network interface. If
         *        you specify this parameter, auto-expansion is disabled and you must manually manage AZ coverage.</p>
         *        <p>
         *        A regional NAT gateway is a single NAT Gateway that works across multiple availability zones (AZs) in
         *        your VPC, providing redundancy, scalability and availability across all the AZs in a Region.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateways-regional.html">Regional NAT
         *        gateways for automatic multi-AZ expansion</a> in the <i>Amazon VPC User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneAddresses(AvailabilityZoneAddress... availabilityZoneAddresses);

        /**
         * <p>
         * For regional NAT gateways only: Specifies which Availability Zones you want the NAT gateway to support and
         * the Elastic IP addresses (EIPs) to use in each AZ. The regional NAT gateway uses these EIPs to handle
         * outbound NAT traffic from their respective AZs. If not specified, the NAT gateway will automatically expand
         * to new AZs and associate EIPs upon detection of an elastic network interface. If you specify this parameter,
         * auto-expansion is disabled and you must manually manage AZ coverage.
         * </p>
         * <p>
         * A regional NAT gateway is a single NAT Gateway that works across multiple availability zones (AZs) in your
         * VPC, providing redundancy, scalability and availability across all the AZs in a Region.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateways-regional.html">Regional NAT gateways for
         * automatic multi-AZ expansion</a> in the <i>Amazon VPC User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.AvailabilityZoneAddress.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.AvailabilityZoneAddress#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.AvailabilityZoneAddress.Builder#build()} is called
         * immediately and its result is passed to {@link #availabilityZoneAddresses(List<AvailabilityZoneAddress>)}.
         * 
         * @param availabilityZoneAddresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.AvailabilityZoneAddress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availabilityZoneAddresses(java.util.Collection<AvailabilityZoneAddress>)
         */
        Builder availabilityZoneAddresses(Consumer<AvailabilityZoneAddress.Builder>... availabilityZoneAddresses);

        /**
         * <p>
         * The tags to assign to the NAT gateway.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to assign to the NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to assign to the NAT gateway.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to assign to the NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to assign to the NAT gateway.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * Indicates whether the NAT gateway supports public or private connectivity. The default is public
         * connectivity.
         * </p>
         * 
         * @param connectivityType
         *        Indicates whether the NAT gateway supports public or private connectivity. The default is public
         *        connectivity.
         * @see ConnectivityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectivityType
         */
        Builder connectivityType(String connectivityType);

        /**
         * <p>
         * Indicates whether the NAT gateway supports public or private connectivity. The default is public
         * connectivity.
         * </p>
         * 
         * @param connectivityType
         *        Indicates whether the NAT gateway supports public or private connectivity. The default is public
         *        connectivity.
         * @see ConnectivityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectivityType
         */
        Builder connectivityType(ConnectivityType connectivityType);

        /**
         * <p>
         * The private IPv4 address to assign to the NAT gateway. If you don't provide an address, a private IPv4
         * address will be automatically assigned.
         * </p>
         * 
         * @param privateIpAddress
         *        The private IPv4 address to assign to the NAT gateway. If you don't provide an address, a private IPv4
         *        address will be automatically assigned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * Secondary EIP allocation IDs. For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Create a NAT
         * gateway</a> in the <i>Amazon VPC User Guide</i>.
         * </p>
         * 
         * @param secondaryAllocationIds
         *        Secondary EIP allocation IDs. For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Create a NAT
         *        gateway</a> in the <i>Amazon VPC User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryAllocationIds(Collection<String> secondaryAllocationIds);

        /**
         * <p>
         * Secondary EIP allocation IDs. For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Create a NAT
         * gateway</a> in the <i>Amazon VPC User Guide</i>.
         * </p>
         * 
         * @param secondaryAllocationIds
         *        Secondary EIP allocation IDs. For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Create a NAT
         *        gateway</a> in the <i>Amazon VPC User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryAllocationIds(String... secondaryAllocationIds);

        /**
         * <p>
         * Secondary private IPv4 addresses. For more information about secondary addresses, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Create a NAT
         * gateway</a> in the <i>Amazon VPC User Guide</i>.
         * </p>
         * 
         * @param secondaryPrivateIpAddresses
         *        Secondary private IPv4 addresses. For more information about secondary addresses, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Create a NAT
         *        gateway</a> in the <i>Amazon VPC User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryPrivateIpAddresses(Collection<String> secondaryPrivateIpAddresses);

        /**
         * <p>
         * Secondary private IPv4 addresses. For more information about secondary addresses, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Create a NAT
         * gateway</a> in the <i>Amazon VPC User Guide</i>.
         * </p>
         * 
         * @param secondaryPrivateIpAddresses
         *        Secondary private IPv4 addresses. For more information about secondary addresses, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Create a NAT
         *        gateway</a> in the <i>Amazon VPC User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryPrivateIpAddresses(String... secondaryPrivateIpAddresses);

        /**
         * <p>
         * [Private NAT gateway only] The number of secondary private IPv4 addresses you want to assign to the NAT
         * gateway. For more information about secondary addresses, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Create a NAT
         * gateway</a> in the <i>Amazon VPC User Guide</i>.
         * </p>
         * 
         * @param secondaryPrivateIpAddressCount
         *        [Private NAT gateway only] The number of secondary private IPv4 addresses you want to assign to the
         *        NAT gateway. For more information about secondary addresses, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Create a NAT
         *        gateway</a> in the <i>Amazon VPC User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String availabilityMode;

        private String allocationId;

        private String clientToken;

        private Boolean dryRun;

        private String subnetId;

        private String vpcId;

        private List<AvailabilityZoneAddress> availabilityZoneAddresses = DefaultSdkAutoConstructList.getInstance();

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private String connectivityType;

        private String privateIpAddress;

        private List<String> secondaryAllocationIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> secondaryPrivateIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private Integer secondaryPrivateIpAddressCount;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNatGatewayRequest model) {
            super(model);
            availabilityMode(model.availabilityMode);
            allocationId(model.allocationId);
            clientToken(model.clientToken);
            dryRun(model.dryRun);
            subnetId(model.subnetId);
            vpcId(model.vpcId);
            availabilityZoneAddresses(model.availabilityZoneAddresses);
            tagSpecifications(model.tagSpecifications);
            connectivityType(model.connectivityType);
            privateIpAddress(model.privateIpAddress);
            secondaryAllocationIds(model.secondaryAllocationIds);
            secondaryPrivateIpAddresses(model.secondaryPrivateIpAddresses);
            secondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
        }

        public final String getAvailabilityMode() {
            return availabilityMode;
        }

        public final void setAvailabilityMode(String availabilityMode) {
            this.availabilityMode = availabilityMode;
        }

        @Override
        public final Builder availabilityMode(String availabilityMode) {
            this.availabilityMode = availabilityMode;
            return this;
        }

        @Override
        public final Builder availabilityMode(AvailabilityMode availabilityMode) {
            this.availabilityMode(availabilityMode == null ? null : availabilityMode.toString());
            return this;
        }

        public final String getAllocationId() {
            return allocationId;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final List<AvailabilityZoneAddress.Builder> getAvailabilityZoneAddresses() {
            List<AvailabilityZoneAddress.Builder> result = AvailabilityZoneAddressesCopier
                    .copyToBuilder(this.availabilityZoneAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailabilityZoneAddresses(Collection<AvailabilityZoneAddress.BuilderImpl> availabilityZoneAddresses) {
            this.availabilityZoneAddresses = AvailabilityZoneAddressesCopier.copyFromBuilder(availabilityZoneAddresses);
        }

        @Override
        public final Builder availabilityZoneAddresses(Collection<AvailabilityZoneAddress> availabilityZoneAddresses) {
            this.availabilityZoneAddresses = AvailabilityZoneAddressesCopier.copy(availabilityZoneAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZoneAddresses(AvailabilityZoneAddress... availabilityZoneAddresses) {
            availabilityZoneAddresses(Arrays.asList(availabilityZoneAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZoneAddresses(Consumer<AvailabilityZoneAddress.Builder>... availabilityZoneAddresses) {
            availabilityZoneAddresses(Stream.of(availabilityZoneAddresses)
                    .map(c -> AvailabilityZoneAddress.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getConnectivityType() {
            return connectivityType;
        }

        public final void setConnectivityType(String connectivityType) {
            this.connectivityType = connectivityType;
        }

        @Override
        public final Builder connectivityType(String connectivityType) {
            this.connectivityType = connectivityType;
            return this;
        }

        @Override
        public final Builder connectivityType(ConnectivityType connectivityType) {
            this.connectivityType(connectivityType == null ? null : connectivityType.toString());
            return this;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final Collection<String> getSecondaryAllocationIds() {
            if (secondaryAllocationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return secondaryAllocationIds;
        }

        public final void setSecondaryAllocationIds(Collection<String> secondaryAllocationIds) {
            this.secondaryAllocationIds = AllocationIdListCopier.copy(secondaryAllocationIds);
        }

        @Override
        public final Builder secondaryAllocationIds(Collection<String> secondaryAllocationIds) {
            this.secondaryAllocationIds = AllocationIdListCopier.copy(secondaryAllocationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryAllocationIds(String... secondaryAllocationIds) {
            secondaryAllocationIds(Arrays.asList(secondaryAllocationIds));
            return this;
        }

        public final Collection<String> getSecondaryPrivateIpAddresses() {
            if (secondaryPrivateIpAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return secondaryPrivateIpAddresses;
        }

        public final void setSecondaryPrivateIpAddresses(Collection<String> secondaryPrivateIpAddresses) {
            this.secondaryPrivateIpAddresses = IpListCopier.copy(secondaryPrivateIpAddresses);
        }

        @Override
        public final Builder secondaryPrivateIpAddresses(Collection<String> secondaryPrivateIpAddresses) {
            this.secondaryPrivateIpAddresses = IpListCopier.copy(secondaryPrivateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryPrivateIpAddresses(String... secondaryPrivateIpAddresses) {
            secondaryPrivateIpAddresses(Arrays.asList(secondaryPrivateIpAddresses));
            return this;
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return secondaryPrivateIpAddressCount;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        @Override
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNatGatewayRequest build() {
            return new CreateNatGatewayRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
