/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.CapacityManagerDimension;
import software.amazon.awssdk.services.ec2.model.GetCapacityManagerMetricDimensionsRequest;
import software.amazon.awssdk.services.ec2.model.GetCapacityManagerMetricDimensionsResponse;

public class GetCapacityManagerMetricDimensionsIterable
implements SdkIterable<GetCapacityManagerMetricDimensionsResponse> {
    private final Ec2Client client;
    private final GetCapacityManagerMetricDimensionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetCapacityManagerMetricDimensionsIterable(Ec2Client client, GetCapacityManagerMetricDimensionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetCapacityManagerMetricDimensionsResponseFetcher();
    }

    public Iterator<GetCapacityManagerMetricDimensionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CapacityManagerDimension> metricDimensionResults() {
        Function<GetCapacityManagerMetricDimensionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.metricDimensionResults() != null) {
                return response.metricDimensionResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetCapacityManagerMetricDimensionsResponseFetcher
    implements SyncPageFetcher<GetCapacityManagerMetricDimensionsResponse> {
        private GetCapacityManagerMetricDimensionsResponseFetcher() {
        }

        public boolean hasNextPage(GetCapacityManagerMetricDimensionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetCapacityManagerMetricDimensionsResponse nextPage(GetCapacityManagerMetricDimensionsResponse previousPage) {
            if (previousPage == null) {
                return GetCapacityManagerMetricDimensionsIterable.this.client.getCapacityManagerMetricDimensions(GetCapacityManagerMetricDimensionsIterable.this.firstRequest);
            }
            return GetCapacityManagerMetricDimensionsIterable.this.client.getCapacityManagerMetricDimensions((GetCapacityManagerMetricDimensionsRequest)((Object)GetCapacityManagerMetricDimensionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

