/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.TransitGatewayMeteringPayerType;
import software.amazon.awssdk.services.ec2.model.TransitGatewayMeteringPolicyEntryState;
import software.amazon.awssdk.services.ec2.model.TransitGatewayMeteringPolicyRule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayMeteringPolicyEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayMeteringPolicyEntry> {
    private static final SdkField<String> POLICY_RULE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyRuleNumber").getter(TransitGatewayMeteringPolicyEntry.getter(TransitGatewayMeteringPolicyEntry::policyRuleNumber)).setter(TransitGatewayMeteringPolicyEntry.setter(Builder::policyRuleNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyRuleNumber").unmarshallLocationName("policyRuleNumber").build()}).build();
    private static final SdkField<String> METERED_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeteredAccount").getter(TransitGatewayMeteringPolicyEntry.getter(TransitGatewayMeteringPolicyEntry::meteredAccountAsString)).setter(TransitGatewayMeteringPolicyEntry.setter(Builder::meteredAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeteredAccount").unmarshallLocationName("meteredAccount").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(TransitGatewayMeteringPolicyEntry.getter(TransitGatewayMeteringPolicyEntry::stateAsString)).setter(TransitGatewayMeteringPolicyEntry.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(TransitGatewayMeteringPolicyEntry.getter(TransitGatewayMeteringPolicyEntry::updatedAt)).setter(TransitGatewayMeteringPolicyEntry.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").unmarshallLocationName("updatedAt").build()}).build();
    private static final SdkField<Instant> UPDATE_EFFECTIVE_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateEffectiveAt").getter(TransitGatewayMeteringPolicyEntry.getter(TransitGatewayMeteringPolicyEntry::updateEffectiveAt)).setter(TransitGatewayMeteringPolicyEntry.setter(Builder::updateEffectiveAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateEffectiveAt").unmarshallLocationName("updateEffectiveAt").build()}).build();
    private static final SdkField<TransitGatewayMeteringPolicyRule> METERING_POLICY_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MeteringPolicyRule").getter(TransitGatewayMeteringPolicyEntry.getter(TransitGatewayMeteringPolicyEntry::meteringPolicyRule)).setter(TransitGatewayMeteringPolicyEntry.setter(Builder::meteringPolicyRule)).constructor(TransitGatewayMeteringPolicyRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeteringPolicyRule").unmarshallLocationName("meteringPolicyRule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_RULE_NUMBER_FIELD, METERED_ACCOUNT_FIELD, STATE_FIELD, UPDATED_AT_FIELD, UPDATE_EFFECTIVE_AT_FIELD, METERING_POLICY_RULE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransitGatewayMeteringPolicyEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String policyRuleNumber;
    private final String meteredAccount;
    private final String state;
    private final Instant updatedAt;
    private final Instant updateEffectiveAt;
    private final TransitGatewayMeteringPolicyRule meteringPolicyRule;

    private TransitGatewayMeteringPolicyEntry(BuilderImpl builder) {
        this.policyRuleNumber = builder.policyRuleNumber;
        this.meteredAccount = builder.meteredAccount;
        this.state = builder.state;
        this.updatedAt = builder.updatedAt;
        this.updateEffectiveAt = builder.updateEffectiveAt;
        this.meteringPolicyRule = builder.meteringPolicyRule;
    }

    public final String policyRuleNumber() {
        return this.policyRuleNumber;
    }

    public final TransitGatewayMeteringPayerType meteredAccount() {
        return TransitGatewayMeteringPayerType.fromValue(this.meteredAccount);
    }

    public final String meteredAccountAsString() {
        return this.meteredAccount;
    }

    public final TransitGatewayMeteringPolicyEntryState state() {
        return TransitGatewayMeteringPolicyEntryState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final Instant updateEffectiveAt() {
        return this.updateEffectiveAt;
    }

    public final TransitGatewayMeteringPolicyRule meteringPolicyRule() {
        return this.meteringPolicyRule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyRuleNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.meteredAccountAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateEffectiveAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.meteringPolicyRule());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayMeteringPolicyEntry)) {
            return false;
        }
        TransitGatewayMeteringPolicyEntry other = (TransitGatewayMeteringPolicyEntry)obj;
        return Objects.equals(this.policyRuleNumber(), other.policyRuleNumber()) && Objects.equals(this.meteredAccountAsString(), other.meteredAccountAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updateEffectiveAt(), other.updateEffectiveAt()) && Objects.equals(this.meteringPolicyRule(), other.meteringPolicyRule());
    }

    public final String toString() {
        return ToString.builder((String)"TransitGatewayMeteringPolicyEntry").add("PolicyRuleNumber", (Object)this.policyRuleNumber()).add("MeteredAccount", (Object)this.meteredAccountAsString()).add("State", (Object)this.stateAsString()).add("UpdatedAt", (Object)this.updatedAt()).add("UpdateEffectiveAt", (Object)this.updateEffectiveAt()).add("MeteringPolicyRule", (Object)this.meteringPolicyRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyRuleNumber": {
                return Optional.ofNullable(clazz.cast(this.policyRuleNumber()));
            }
            case "MeteredAccount": {
                return Optional.ofNullable(clazz.cast(this.meteredAccountAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "UpdateEffectiveAt": {
                return Optional.ofNullable(clazz.cast(this.updateEffectiveAt()));
            }
            case "MeteringPolicyRule": {
                return Optional.ofNullable(clazz.cast(this.meteringPolicyRule()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PolicyRuleNumber", POLICY_RULE_NUMBER_FIELD);
        map.put("MeteredAccount", METERED_ACCOUNT_FIELD);
        map.put("State", STATE_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("UpdateEffectiveAt", UPDATE_EFFECTIVE_AT_FIELD);
        map.put("MeteringPolicyRule", METERING_POLICY_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayMeteringPolicyEntry, T> g) {
        return obj -> g.apply((TransitGatewayMeteringPolicyEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyRuleNumber;
        private String meteredAccount;
        private String state;
        private Instant updatedAt;
        private Instant updateEffectiveAt;
        private TransitGatewayMeteringPolicyRule meteringPolicyRule;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayMeteringPolicyEntry model) {
            this.policyRuleNumber(model.policyRuleNumber);
            this.meteredAccount(model.meteredAccount);
            this.state(model.state);
            this.updatedAt(model.updatedAt);
            this.updateEffectiveAt(model.updateEffectiveAt);
            this.meteringPolicyRule(model.meteringPolicyRule);
        }

        public final String getPolicyRuleNumber() {
            return this.policyRuleNumber;
        }

        public final void setPolicyRuleNumber(String policyRuleNumber) {
            this.policyRuleNumber = policyRuleNumber;
        }

        @Override
        public final Builder policyRuleNumber(String policyRuleNumber) {
            this.policyRuleNumber = policyRuleNumber;
            return this;
        }

        public final String getMeteredAccount() {
            return this.meteredAccount;
        }

        public final void setMeteredAccount(String meteredAccount) {
            this.meteredAccount = meteredAccount;
        }

        @Override
        public final Builder meteredAccount(String meteredAccount) {
            this.meteredAccount = meteredAccount;
            return this;
        }

        @Override
        public final Builder meteredAccount(TransitGatewayMeteringPayerType meteredAccount) {
            this.meteredAccount(meteredAccount == null ? null : meteredAccount.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayMeteringPolicyEntryState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Instant getUpdateEffectiveAt() {
            return this.updateEffectiveAt;
        }

        public final void setUpdateEffectiveAt(Instant updateEffectiveAt) {
            this.updateEffectiveAt = updateEffectiveAt;
        }

        @Override
        public final Builder updateEffectiveAt(Instant updateEffectiveAt) {
            this.updateEffectiveAt = updateEffectiveAt;
            return this;
        }

        public final TransitGatewayMeteringPolicyRule.Builder getMeteringPolicyRule() {
            return this.meteringPolicyRule != null ? this.meteringPolicyRule.toBuilder() : null;
        }

        public final void setMeteringPolicyRule(TransitGatewayMeteringPolicyRule.BuilderImpl meteringPolicyRule) {
            this.meteringPolicyRule = meteringPolicyRule != null ? meteringPolicyRule.build() : null;
        }

        @Override
        public final Builder meteringPolicyRule(TransitGatewayMeteringPolicyRule meteringPolicyRule) {
            this.meteringPolicyRule = meteringPolicyRule;
            return this;
        }

        public TransitGatewayMeteringPolicyEntry build() {
            return new TransitGatewayMeteringPolicyEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayMeteringPolicyEntry> {
        public Builder policyRuleNumber(String var1);

        public Builder meteredAccount(String var1);

        public Builder meteredAccount(TransitGatewayMeteringPayerType var1);

        public Builder state(String var1);

        public Builder state(TransitGatewayMeteringPolicyEntryState var1);

        public Builder updatedAt(Instant var1);

        public Builder updateEffectiveAt(Instant var1);

        public Builder meteringPolicyRule(TransitGatewayMeteringPolicyRule var1);

        default public Builder meteringPolicyRule(Consumer<TransitGatewayMeteringPolicyRule.Builder> meteringPolicyRule) {
            return this.meteringPolicyRule((TransitGatewayMeteringPolicyRule)((TransitGatewayMeteringPolicyRule.Builder)TransitGatewayMeteringPolicyRule.builder().applyMutation(meteringPolicyRule)).build());
        }
    }
}

