/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IpamPublicAddressType {
    SERVICE_MANAGED_IP("service-managed-ip"),
    SERVICE_MANAGED_BYOIP("service-managed-byoip"),
    AMAZON_OWNED_EIP("amazon-owned-eip"),
    AMAZON_OWNED_CONTIG("amazon-owned-contig"),
    BYOIP("byoip"),
    EC2_PUBLIC_IP("ec2-public-ip"),
    ANYCAST_IP_LIST_IP("anycast-ip-list-ip"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IpamPublicAddressType> VALUE_MAP;
    private final String value;

    private IpamPublicAddressType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IpamPublicAddressType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IpamPublicAddressType> knownValues() {
        EnumSet<IpamPublicAddressType> knownValues = EnumSet.allOf(IpamPublicAddressType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IpamPublicAddressType.class, IpamPublicAddressType::toString);
    }
}

