/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ImageUsageReportEntry;
import software.amazon.awssdk.services.ec2.model.ImageUsageReportEntryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImageUsageReportEntriesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeImageUsageReportEntriesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeImageUsageReportEntriesResponse.getter(DescribeImageUsageReportEntriesResponse::nextToken)).setter(DescribeImageUsageReportEntriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<ImageUsageReportEntry>> IMAGE_USAGE_REPORT_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImageUsageReportEntries").getter(DescribeImageUsageReportEntriesResponse.getter(DescribeImageUsageReportEntriesResponse::imageUsageReportEntries)).setter(DescribeImageUsageReportEntriesResponse.setter(Builder::imageUsageReportEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUsageReportEntrySet").unmarshallLocationName("imageUsageReportEntrySet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageUsageReportEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, IMAGE_USAGE_REPORT_ENTRIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeImageUsageReportEntriesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ImageUsageReportEntry> imageUsageReportEntries;

    private DescribeImageUsageReportEntriesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.imageUsageReportEntries = builder.imageUsageReportEntries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasImageUsageReportEntries() {
        return this.imageUsageReportEntries != null && !(this.imageUsageReportEntries instanceof SdkAutoConstructList);
    }

    public final List<ImageUsageReportEntry> imageUsageReportEntries() {
        return this.imageUsageReportEntries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageUsageReportEntries() ? this.imageUsageReportEntries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageUsageReportEntriesResponse)) {
            return false;
        }
        DescribeImageUsageReportEntriesResponse other = (DescribeImageUsageReportEntriesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasImageUsageReportEntries() == other.hasImageUsageReportEntries() && Objects.equals(this.imageUsageReportEntries(), other.imageUsageReportEntries());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeImageUsageReportEntriesResponse").add("NextToken", (Object)this.nextToken()).add("ImageUsageReportEntries", this.hasImageUsageReportEntries() ? this.imageUsageReportEntries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ImageUsageReportEntries": {
                return Optional.ofNullable(clazz.cast(this.imageUsageReportEntries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ImageUsageReportEntrySet", IMAGE_USAGE_REPORT_ENTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageUsageReportEntriesResponse, T> g) {
        return obj -> g.apply((DescribeImageUsageReportEntriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ImageUsageReportEntry> imageUsageReportEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageUsageReportEntriesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.imageUsageReportEntries(model.imageUsageReportEntries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ImageUsageReportEntry.Builder> getImageUsageReportEntries() {
            List<ImageUsageReportEntry.Builder> result = ImageUsageReportEntryListCopier.copyToBuilder(this.imageUsageReportEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageUsageReportEntries(Collection<ImageUsageReportEntry.BuilderImpl> imageUsageReportEntries) {
            this.imageUsageReportEntries = ImageUsageReportEntryListCopier.copyFromBuilder(imageUsageReportEntries);
        }

        @Override
        public final Builder imageUsageReportEntries(Collection<ImageUsageReportEntry> imageUsageReportEntries) {
            this.imageUsageReportEntries = ImageUsageReportEntryListCopier.copy(imageUsageReportEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageUsageReportEntries(ImageUsageReportEntry ... imageUsageReportEntries) {
            this.imageUsageReportEntries(Arrays.asList(imageUsageReportEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageUsageReportEntries(Consumer<ImageUsageReportEntry.Builder> ... imageUsageReportEntries) {
            this.imageUsageReportEntries(Stream.of(imageUsageReportEntries).map(c -> (ImageUsageReportEntry)((ImageUsageReportEntry.Builder)ImageUsageReportEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeImageUsageReportEntriesResponse build() {
            return new DescribeImageUsageReportEntriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImageUsageReportEntriesResponse> {
        public Builder nextToken(String var1);

        public Builder imageUsageReportEntries(Collection<ImageUsageReportEntry> var1);

        public Builder imageUsageReportEntries(ImageUsageReportEntry ... var1);

        public Builder imageUsageReportEntries(Consumer<ImageUsageReportEntry.Builder> ... var1);
    }
}

