/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a resource that is not compliant with VPC encryption requirements.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-encryption-controls.html">Enforce VPC encryption in
 * transit</a> in the <i>Amazon VPC User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcEncryptionNonCompliantResource implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcEncryptionNonCompliantResource.Builder, VpcEncryptionNonCompliantResource> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(VpcEncryptionNonCompliantResource::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("id")
                    .build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Type")
            .getter(getter(VpcEncryptionNonCompliantResource::type))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("type").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(VpcEncryptionNonCompliantResource::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<Boolean> IS_EXCLUDABLE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsExcludable")
            .getter(getter(VpcEncryptionNonCompliantResource::isExcludable))
            .setter(setter(Builder::isExcludable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsExcludable")
                    .unmarshallLocationName("isExcludable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD,
            DESCRIPTION_FIELD, IS_EXCLUDABLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String type;

    private final String description;

    private final Boolean isExcludable;

    private VpcEncryptionNonCompliantResource(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.description = builder.description;
        this.isExcludable = builder.isExcludable;
    }

    /**
     * <p>
     * The ID of the non-compliant resource.
     * </p>
     * 
     * @return The ID of the non-compliant resource.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of the non-compliant resource.
     * </p>
     * 
     * @return The type of the non-compliant resource.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * A description of the non-compliant resource.
     * </p>
     * 
     * @return A description of the non-compliant resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Indicates whether the resource can be excluded from encryption enforcement.
     * </p>
     * 
     * @return Indicates whether the resource can be excluded from encryption enforcement.
     */
    public final Boolean isExcludable() {
        return isExcludable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(isExcludable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEncryptionNonCompliantResource)) {
            return false;
        }
        VpcEncryptionNonCompliantResource other = (VpcEncryptionNonCompliantResource) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(type(), other.type())
                && Objects.equals(description(), other.description()) && Objects.equals(isExcludable(), other.isExcludable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcEncryptionNonCompliantResource").add("Id", id()).add("Type", type())
                .add("Description", description()).add("IsExcludable", isExcludable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "IsExcludable":
            return Optional.ofNullable(clazz.cast(isExcludable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("IsExcludable", IS_EXCLUDABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcEncryptionNonCompliantResource, T> g) {
        return obj -> g.apply((VpcEncryptionNonCompliantResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcEncryptionNonCompliantResource> {
        /**
         * <p>
         * The ID of the non-compliant resource.
         * </p>
         * 
         * @param id
         *        The ID of the non-compliant resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of the non-compliant resource.
         * </p>
         * 
         * @param type
         *        The type of the non-compliant resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * A description of the non-compliant resource.
         * </p>
         * 
         * @param description
         *        A description of the non-compliant resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates whether the resource can be excluded from encryption enforcement.
         * </p>
         * 
         * @param isExcludable
         *        Indicates whether the resource can be excluded from encryption enforcement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isExcludable(Boolean isExcludable);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String type;

        private String description;

        private Boolean isExcludable;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcEncryptionNonCompliantResource model) {
            id(model.id);
            type(model.type);
            description(model.description);
            isExcludable(model.isExcludable);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIsExcludable() {
            return isExcludable;
        }

        public final void setIsExcludable(Boolean isExcludable) {
            this.isExcludable = isExcludable;
        }

        @Override
        public final Builder isExcludable(Boolean isExcludable) {
            this.isExcludable = isExcludable;
            return this;
        }

        @Override
        public VpcEncryptionNonCompliantResource build() {
            return new VpcEncryptionNonCompliantResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
