/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the traffic matching criteria for a transit gateway metering policy rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayMeteringPolicyRule implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayMeteringPolicyRule.Builder, TransitGatewayMeteringPolicyRule> {
    private static final SdkField<String> SOURCE_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceTransitGatewayAttachmentId")
            .getter(getter(TransitGatewayMeteringPolicyRule::sourceTransitGatewayAttachmentId))
            .setter(setter(Builder::sourceTransitGatewayAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTransitGatewayAttachmentId")
                    .unmarshallLocationName("sourceTransitGatewayAttachmentId").build()).build();

    private static final SdkField<String> SOURCE_TRANSIT_GATEWAY_ATTACHMENT_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceTransitGatewayAttachmentType")
            .getter(getter(TransitGatewayMeteringPolicyRule::sourceTransitGatewayAttachmentTypeAsString))
            .setter(setter(Builder::sourceTransitGatewayAttachmentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTransitGatewayAttachmentType")
                    .unmarshallLocationName("sourceTransitGatewayAttachmentType").build()).build();

    private static final SdkField<String> SOURCE_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceCidrBlock")
            .getter(getter(TransitGatewayMeteringPolicyRule::sourceCidrBlock))
            .setter(setter(Builder::sourceCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCidrBlock")
                    .unmarshallLocationName("sourceCidrBlock").build()).build();

    private static final SdkField<String> SOURCE_PORT_RANGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourcePortRange")
            .getter(getter(TransitGatewayMeteringPolicyRule::sourcePortRange))
            .setter(setter(Builder::sourcePortRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePortRange")
                    .unmarshallLocationName("sourcePortRange").build()).build();

    private static final SdkField<String> DESTINATION_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationTransitGatewayAttachmentId")
            .getter(getter(TransitGatewayMeteringPolicyRule::destinationTransitGatewayAttachmentId))
            .setter(setter(Builder::destinationTransitGatewayAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DestinationTransitGatewayAttachmentId")
                    .unmarshallLocationName("destinationTransitGatewayAttachmentId").build()).build();

    private static final SdkField<String> DESTINATION_TRANSIT_GATEWAY_ATTACHMENT_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationTransitGatewayAttachmentType")
            .getter(getter(TransitGatewayMeteringPolicyRule::destinationTransitGatewayAttachmentTypeAsString))
            .setter(setter(Builder::destinationTransitGatewayAttachmentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DestinationTransitGatewayAttachmentType")
                    .unmarshallLocationName("destinationTransitGatewayAttachmentType").build()).build();

    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationCidrBlock")
            .getter(getter(TransitGatewayMeteringPolicyRule::destinationCidrBlock))
            .setter(setter(Builder::destinationCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock")
                    .unmarshallLocationName("destinationCidrBlock").build()).build();

    private static final SdkField<String> DESTINATION_PORT_RANGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationPortRange")
            .getter(getter(TransitGatewayMeteringPolicyRule::destinationPortRange))
            .setter(setter(Builder::destinationPortRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPortRange")
                    .unmarshallLocationName("destinationPortRange").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Protocol")
            .getter(getter(TransitGatewayMeteringPolicyRule::protocol))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol")
                    .unmarshallLocationName("protocol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SOURCE_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, SOURCE_TRANSIT_GATEWAY_ATTACHMENT_TYPE_FIELD, SOURCE_CIDR_BLOCK_FIELD,
            SOURCE_PORT_RANGE_FIELD, DESTINATION_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD,
            DESTINATION_TRANSIT_GATEWAY_ATTACHMENT_TYPE_FIELD, DESTINATION_CIDR_BLOCK_FIELD, DESTINATION_PORT_RANGE_FIELD,
            PROTOCOL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceTransitGatewayAttachmentId;

    private final String sourceTransitGatewayAttachmentType;

    private final String sourceCidrBlock;

    private final String sourcePortRange;

    private final String destinationTransitGatewayAttachmentId;

    private final String destinationTransitGatewayAttachmentType;

    private final String destinationCidrBlock;

    private final String destinationPortRange;

    private final String protocol;

    private TransitGatewayMeteringPolicyRule(BuilderImpl builder) {
        this.sourceTransitGatewayAttachmentId = builder.sourceTransitGatewayAttachmentId;
        this.sourceTransitGatewayAttachmentType = builder.sourceTransitGatewayAttachmentType;
        this.sourceCidrBlock = builder.sourceCidrBlock;
        this.sourcePortRange = builder.sourcePortRange;
        this.destinationTransitGatewayAttachmentId = builder.destinationTransitGatewayAttachmentId;
        this.destinationTransitGatewayAttachmentType = builder.destinationTransitGatewayAttachmentType;
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.destinationPortRange = builder.destinationPortRange;
        this.protocol = builder.protocol;
    }

    /**
     * <p>
     * The ID of the source transit gateway attachment.
     * </p>
     * 
     * @return The ID of the source transit gateway attachment.
     */
    public final String sourceTransitGatewayAttachmentId() {
        return sourceTransitGatewayAttachmentId;
    }

    /**
     * <p>
     * The type of the source transit gateway attachment. Note that the <code>tgw-peering</code> resource type has been
     * deprecated. To configure metering policies for Connect, use the transport attachment type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sourceTransitGatewayAttachmentType} will return
     * {@link TransitGatewayAttachmentResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sourceTransitGatewayAttachmentTypeAsString}.
     * </p>
     * 
     * @return The type of the source transit gateway attachment. Note that the <code>tgw-peering</code> resource type
     *         has been deprecated. To configure metering policies for Connect, use the transport attachment type.
     * @see TransitGatewayAttachmentResourceType
     */
    public final TransitGatewayAttachmentResourceType sourceTransitGatewayAttachmentType() {
        return TransitGatewayAttachmentResourceType.fromValue(sourceTransitGatewayAttachmentType);
    }

    /**
     * <p>
     * The type of the source transit gateway attachment. Note that the <code>tgw-peering</code> resource type has been
     * deprecated. To configure metering policies for Connect, use the transport attachment type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sourceTransitGatewayAttachmentType} will return
     * {@link TransitGatewayAttachmentResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sourceTransitGatewayAttachmentTypeAsString}.
     * </p>
     * 
     * @return The type of the source transit gateway attachment. Note that the <code>tgw-peering</code> resource type
     *         has been deprecated. To configure metering policies for Connect, use the transport attachment type.
     * @see TransitGatewayAttachmentResourceType
     */
    public final String sourceTransitGatewayAttachmentTypeAsString() {
        return sourceTransitGatewayAttachmentType;
    }

    /**
     * <p>
     * The source CIDR block for the rule.
     * </p>
     * 
     * @return The source CIDR block for the rule.
     */
    public final String sourceCidrBlock() {
        return sourceCidrBlock;
    }

    /**
     * <p>
     * The source port range for the rule.
     * </p>
     * 
     * @return The source port range for the rule.
     */
    public final String sourcePortRange() {
        return sourcePortRange;
    }

    /**
     * <p>
     * The ID of the destination transit gateway attachment.
     * </p>
     * 
     * @return The ID of the destination transit gateway attachment.
     */
    public final String destinationTransitGatewayAttachmentId() {
        return destinationTransitGatewayAttachmentId;
    }

    /**
     * <p>
     * The type of the destination transit gateway attachment. Note that the <code>tgw-peering</code> resource type has
     * been deprecated. To configure metering policies for Connect, use the transport attachment type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #destinationTransitGatewayAttachmentType} will return
     * {@link TransitGatewayAttachmentResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #destinationTransitGatewayAttachmentTypeAsString}.
     * </p>
     * 
     * @return The type of the destination transit gateway attachment. Note that the <code>tgw-peering</code> resource
     *         type has been deprecated. To configure metering policies for Connect, use the transport attachment type.
     * @see TransitGatewayAttachmentResourceType
     */
    public final TransitGatewayAttachmentResourceType destinationTransitGatewayAttachmentType() {
        return TransitGatewayAttachmentResourceType.fromValue(destinationTransitGatewayAttachmentType);
    }

    /**
     * <p>
     * The type of the destination transit gateway attachment. Note that the <code>tgw-peering</code> resource type has
     * been deprecated. To configure metering policies for Connect, use the transport attachment type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #destinationTransitGatewayAttachmentType} will return
     * {@link TransitGatewayAttachmentResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #destinationTransitGatewayAttachmentTypeAsString}.
     * </p>
     * 
     * @return The type of the destination transit gateway attachment. Note that the <code>tgw-peering</code> resource
     *         type has been deprecated. To configure metering policies for Connect, use the transport attachment type.
     * @see TransitGatewayAttachmentResourceType
     */
    public final String destinationTransitGatewayAttachmentTypeAsString() {
        return destinationTransitGatewayAttachmentType;
    }

    /**
     * <p>
     * The destination CIDR block for the rule.
     * </p>
     * 
     * @return The destination CIDR block for the rule.
     */
    public final String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * <p>
     * The destination port range for the rule.
     * </p>
     * 
     * @return The destination port range for the rule.
     */
    public final String destinationPortRange() {
        return destinationPortRange;
    }

    /**
     * <p>
     * The protocol for the rule (1, 6, 17, etc.).
     * </p>
     * 
     * @return The protocol for the rule (1, 6, 17, etc.).
     */
    public final String protocol() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceTransitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTransitGatewayAttachmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePortRange());
        hashCode = 31 * hashCode + Objects.hashCode(destinationTransitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationTransitGatewayAttachmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayMeteringPolicyRule)) {
            return false;
        }
        TransitGatewayMeteringPolicyRule other = (TransitGatewayMeteringPolicyRule) obj;
        return Objects.equals(sourceTransitGatewayAttachmentId(), other.sourceTransitGatewayAttachmentId())
                && Objects.equals(sourceTransitGatewayAttachmentTypeAsString(),
                        other.sourceTransitGatewayAttachmentTypeAsString())
                && Objects.equals(sourceCidrBlock(), other.sourceCidrBlock())
                && Objects.equals(sourcePortRange(), other.sourcePortRange())
                && Objects.equals(destinationTransitGatewayAttachmentId(), other.destinationTransitGatewayAttachmentId())
                && Objects.equals(destinationTransitGatewayAttachmentTypeAsString(),
                        other.destinationTransitGatewayAttachmentTypeAsString())
                && Objects.equals(destinationCidrBlock(), other.destinationCidrBlock())
                && Objects.equals(destinationPortRange(), other.destinationPortRange())
                && Objects.equals(protocol(), other.protocol());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGatewayMeteringPolicyRule")
                .add("SourceTransitGatewayAttachmentId", sourceTransitGatewayAttachmentId())
                .add("SourceTransitGatewayAttachmentType", sourceTransitGatewayAttachmentTypeAsString())
                .add("SourceCidrBlock", sourceCidrBlock()).add("SourcePortRange", sourcePortRange())
                .add("DestinationTransitGatewayAttachmentId", destinationTransitGatewayAttachmentId())
                .add("DestinationTransitGatewayAttachmentType", destinationTransitGatewayAttachmentTypeAsString())
                .add("DestinationCidrBlock", destinationCidrBlock()).add("DestinationPortRange", destinationPortRange())
                .add("Protocol", protocol()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceTransitGatewayAttachmentId":
            return Optional.ofNullable(clazz.cast(sourceTransitGatewayAttachmentId()));
        case "SourceTransitGatewayAttachmentType":
            return Optional.ofNullable(clazz.cast(sourceTransitGatewayAttachmentTypeAsString()));
        case "SourceCidrBlock":
            return Optional.ofNullable(clazz.cast(sourceCidrBlock()));
        case "SourcePortRange":
            return Optional.ofNullable(clazz.cast(sourcePortRange()));
        case "DestinationTransitGatewayAttachmentId":
            return Optional.ofNullable(clazz.cast(destinationTransitGatewayAttachmentId()));
        case "DestinationTransitGatewayAttachmentType":
            return Optional.ofNullable(clazz.cast(destinationTransitGatewayAttachmentTypeAsString()));
        case "DestinationCidrBlock":
            return Optional.ofNullable(clazz.cast(destinationCidrBlock()));
        case "DestinationPortRange":
            return Optional.ofNullable(clazz.cast(destinationPortRange()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceTransitGatewayAttachmentId", SOURCE_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD);
        map.put("SourceTransitGatewayAttachmentType", SOURCE_TRANSIT_GATEWAY_ATTACHMENT_TYPE_FIELD);
        map.put("SourceCidrBlock", SOURCE_CIDR_BLOCK_FIELD);
        map.put("SourcePortRange", SOURCE_PORT_RANGE_FIELD);
        map.put("DestinationTransitGatewayAttachmentId", DESTINATION_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD);
        map.put("DestinationTransitGatewayAttachmentType", DESTINATION_TRANSIT_GATEWAY_ATTACHMENT_TYPE_FIELD);
        map.put("DestinationCidrBlock", DESTINATION_CIDR_BLOCK_FIELD);
        map.put("DestinationPortRange", DESTINATION_PORT_RANGE_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayMeteringPolicyRule, T> g) {
        return obj -> g.apply((TransitGatewayMeteringPolicyRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayMeteringPolicyRule> {
        /**
         * <p>
         * The ID of the source transit gateway attachment.
         * </p>
         * 
         * @param sourceTransitGatewayAttachmentId
         *        The ID of the source transit gateway attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTransitGatewayAttachmentId(String sourceTransitGatewayAttachmentId);

        /**
         * <p>
         * The type of the source transit gateway attachment. Note that the <code>tgw-peering</code> resource type has
         * been deprecated. To configure metering policies for Connect, use the transport attachment type.
         * </p>
         * 
         * @param sourceTransitGatewayAttachmentType
         *        The type of the source transit gateway attachment. Note that the <code>tgw-peering</code> resource
         *        type has been deprecated. To configure metering policies for Connect, use the transport attachment
         *        type.
         * @see TransitGatewayAttachmentResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentResourceType
         */
        Builder sourceTransitGatewayAttachmentType(String sourceTransitGatewayAttachmentType);

        /**
         * <p>
         * The type of the source transit gateway attachment. Note that the <code>tgw-peering</code> resource type has
         * been deprecated. To configure metering policies for Connect, use the transport attachment type.
         * </p>
         * 
         * @param sourceTransitGatewayAttachmentType
         *        The type of the source transit gateway attachment. Note that the <code>tgw-peering</code> resource
         *        type has been deprecated. To configure metering policies for Connect, use the transport attachment
         *        type.
         * @see TransitGatewayAttachmentResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentResourceType
         */
        Builder sourceTransitGatewayAttachmentType(TransitGatewayAttachmentResourceType sourceTransitGatewayAttachmentType);

        /**
         * <p>
         * The source CIDR block for the rule.
         * </p>
         * 
         * @param sourceCidrBlock
         *        The source CIDR block for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCidrBlock(String sourceCidrBlock);

        /**
         * <p>
         * The source port range for the rule.
         * </p>
         * 
         * @param sourcePortRange
         *        The source port range for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePortRange(String sourcePortRange);

        /**
         * <p>
         * The ID of the destination transit gateway attachment.
         * </p>
         * 
         * @param destinationTransitGatewayAttachmentId
         *        The ID of the destination transit gateway attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationTransitGatewayAttachmentId(String destinationTransitGatewayAttachmentId);

        /**
         * <p>
         * The type of the destination transit gateway attachment. Note that the <code>tgw-peering</code> resource type
         * has been deprecated. To configure metering policies for Connect, use the transport attachment type.
         * </p>
         * 
         * @param destinationTransitGatewayAttachmentType
         *        The type of the destination transit gateway attachment. Note that the <code>tgw-peering</code>
         *        resource type has been deprecated. To configure metering policies for Connect, use the transport
         *        attachment type.
         * @see TransitGatewayAttachmentResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentResourceType
         */
        Builder destinationTransitGatewayAttachmentType(String destinationTransitGatewayAttachmentType);

        /**
         * <p>
         * The type of the destination transit gateway attachment. Note that the <code>tgw-peering</code> resource type
         * has been deprecated. To configure metering policies for Connect, use the transport attachment type.
         * </p>
         * 
         * @param destinationTransitGatewayAttachmentType
         *        The type of the destination transit gateway attachment. Note that the <code>tgw-peering</code>
         *        resource type has been deprecated. To configure metering policies for Connect, use the transport
         *        attachment type.
         * @see TransitGatewayAttachmentResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentResourceType
         */
        Builder destinationTransitGatewayAttachmentType(
                TransitGatewayAttachmentResourceType destinationTransitGatewayAttachmentType);

        /**
         * <p>
         * The destination CIDR block for the rule.
         * </p>
         * 
         * @param destinationCidrBlock
         *        The destination CIDR block for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * The destination port range for the rule.
         * </p>
         * 
         * @param destinationPortRange
         *        The destination port range for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPortRange(String destinationPortRange);

        /**
         * <p>
         * The protocol for the rule (1, 6, 17, etc.).
         * </p>
         * 
         * @param protocol
         *        The protocol for the rule (1, 6, 17, etc.).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);
    }

    static final class BuilderImpl implements Builder {
        private String sourceTransitGatewayAttachmentId;

        private String sourceTransitGatewayAttachmentType;

        private String sourceCidrBlock;

        private String sourcePortRange;

        private String destinationTransitGatewayAttachmentId;

        private String destinationTransitGatewayAttachmentType;

        private String destinationCidrBlock;

        private String destinationPortRange;

        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayMeteringPolicyRule model) {
            sourceTransitGatewayAttachmentId(model.sourceTransitGatewayAttachmentId);
            sourceTransitGatewayAttachmentType(model.sourceTransitGatewayAttachmentType);
            sourceCidrBlock(model.sourceCidrBlock);
            sourcePortRange(model.sourcePortRange);
            destinationTransitGatewayAttachmentId(model.destinationTransitGatewayAttachmentId);
            destinationTransitGatewayAttachmentType(model.destinationTransitGatewayAttachmentType);
            destinationCidrBlock(model.destinationCidrBlock);
            destinationPortRange(model.destinationPortRange);
            protocol(model.protocol);
        }

        public final String getSourceTransitGatewayAttachmentId() {
            return sourceTransitGatewayAttachmentId;
        }

        public final void setSourceTransitGatewayAttachmentId(String sourceTransitGatewayAttachmentId) {
            this.sourceTransitGatewayAttachmentId = sourceTransitGatewayAttachmentId;
        }

        @Override
        public final Builder sourceTransitGatewayAttachmentId(String sourceTransitGatewayAttachmentId) {
            this.sourceTransitGatewayAttachmentId = sourceTransitGatewayAttachmentId;
            return this;
        }

        public final String getSourceTransitGatewayAttachmentType() {
            return sourceTransitGatewayAttachmentType;
        }

        public final void setSourceTransitGatewayAttachmentType(String sourceTransitGatewayAttachmentType) {
            this.sourceTransitGatewayAttachmentType = sourceTransitGatewayAttachmentType;
        }

        @Override
        public final Builder sourceTransitGatewayAttachmentType(String sourceTransitGatewayAttachmentType) {
            this.sourceTransitGatewayAttachmentType = sourceTransitGatewayAttachmentType;
            return this;
        }

        @Override
        public final Builder sourceTransitGatewayAttachmentType(
                TransitGatewayAttachmentResourceType sourceTransitGatewayAttachmentType) {
            this.sourceTransitGatewayAttachmentType(sourceTransitGatewayAttachmentType == null ? null
                    : sourceTransitGatewayAttachmentType.toString());
            return this;
        }

        public final String getSourceCidrBlock() {
            return sourceCidrBlock;
        }

        public final void setSourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
        }

        @Override
        public final Builder sourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
            return this;
        }

        public final String getSourcePortRange() {
            return sourcePortRange;
        }

        public final void setSourcePortRange(String sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
        }

        @Override
        public final Builder sourcePortRange(String sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
            return this;
        }

        public final String getDestinationTransitGatewayAttachmentId() {
            return destinationTransitGatewayAttachmentId;
        }

        public final void setDestinationTransitGatewayAttachmentId(String destinationTransitGatewayAttachmentId) {
            this.destinationTransitGatewayAttachmentId = destinationTransitGatewayAttachmentId;
        }

        @Override
        public final Builder destinationTransitGatewayAttachmentId(String destinationTransitGatewayAttachmentId) {
            this.destinationTransitGatewayAttachmentId = destinationTransitGatewayAttachmentId;
            return this;
        }

        public final String getDestinationTransitGatewayAttachmentType() {
            return destinationTransitGatewayAttachmentType;
        }

        public final void setDestinationTransitGatewayAttachmentType(String destinationTransitGatewayAttachmentType) {
            this.destinationTransitGatewayAttachmentType = destinationTransitGatewayAttachmentType;
        }

        @Override
        public final Builder destinationTransitGatewayAttachmentType(String destinationTransitGatewayAttachmentType) {
            this.destinationTransitGatewayAttachmentType = destinationTransitGatewayAttachmentType;
            return this;
        }

        @Override
        public final Builder destinationTransitGatewayAttachmentType(
                TransitGatewayAttachmentResourceType destinationTransitGatewayAttachmentType) {
            this.destinationTransitGatewayAttachmentType(destinationTransitGatewayAttachmentType == null ? null
                    : destinationTransitGatewayAttachmentType.toString());
            return this;
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getDestinationPortRange() {
            return destinationPortRange;
        }

        public final void setDestinationPortRange(String destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
        }

        @Override
        public final Builder destinationPortRange(String destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public TransitGatewayMeteringPolicyRule build() {
            return new TransitGatewayMeteringPolicyRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
