/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an entry in a transit gateway metering policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayMeteringPolicyEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayMeteringPolicyEntry.Builder, TransitGatewayMeteringPolicyEntry> {
    private static final SdkField<String> POLICY_RULE_NUMBER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PolicyRuleNumber")
            .getter(getter(TransitGatewayMeteringPolicyEntry::policyRuleNumber))
            .setter(setter(Builder::policyRuleNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyRuleNumber")
                    .unmarshallLocationName("policyRuleNumber").build()).build();

    private static final SdkField<String> METERED_ACCOUNT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MeteredAccount")
            .getter(getter(TransitGatewayMeteringPolicyEntry::meteredAccountAsString))
            .setter(setter(Builder::meteredAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeteredAccount")
                    .unmarshallLocationName("meteredAccount").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(TransitGatewayMeteringPolicyEntry::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt")
            .getter(getter(TransitGatewayMeteringPolicyEntry::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt")
                    .unmarshallLocationName("updatedAt").build()).build();

    private static final SdkField<Instant> UPDATE_EFFECTIVE_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateEffectiveAt")
            .getter(getter(TransitGatewayMeteringPolicyEntry::updateEffectiveAt))
            .setter(setter(Builder::updateEffectiveAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateEffectiveAt")
                    .unmarshallLocationName("updateEffectiveAt").build()).build();

    private static final SdkField<TransitGatewayMeteringPolicyRule> METERING_POLICY_RULE_FIELD = SdkField
            .<TransitGatewayMeteringPolicyRule> builder(MarshallingType.SDK_POJO)
            .memberName("MeteringPolicyRule")
            .getter(getter(TransitGatewayMeteringPolicyEntry::meteringPolicyRule))
            .setter(setter(Builder::meteringPolicyRule))
            .constructor(TransitGatewayMeteringPolicyRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeteringPolicyRule")
                    .unmarshallLocationName("meteringPolicyRule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_RULE_NUMBER_FIELD,
            METERED_ACCOUNT_FIELD, STATE_FIELD, UPDATED_AT_FIELD, UPDATE_EFFECTIVE_AT_FIELD, METERING_POLICY_RULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String policyRuleNumber;

    private final String meteredAccount;

    private final String state;

    private final Instant updatedAt;

    private final Instant updateEffectiveAt;

    private final TransitGatewayMeteringPolicyRule meteringPolicyRule;

    private TransitGatewayMeteringPolicyEntry(BuilderImpl builder) {
        this.policyRuleNumber = builder.policyRuleNumber;
        this.meteredAccount = builder.meteredAccount;
        this.state = builder.state;
        this.updatedAt = builder.updatedAt;
        this.updateEffectiveAt = builder.updateEffectiveAt;
        this.meteringPolicyRule = builder.meteringPolicyRule;
    }

    /**
     * <p>
     * The rule number of the metering policy entry.
     * </p>
     * 
     * @return The rule number of the metering policy entry.
     */
    public final String policyRuleNumber() {
        return policyRuleNumber;
    }

    /**
     * <p>
     * The Amazon Web Services account ID to which the metered traffic is attributed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #meteredAccount}
     * will return {@link TransitGatewayMeteringPayerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #meteredAccountAsString}.
     * </p>
     * 
     * @return The Amazon Web Services account ID to which the metered traffic is attributed.
     * @see TransitGatewayMeteringPayerType
     */
    public final TransitGatewayMeteringPayerType meteredAccount() {
        return TransitGatewayMeteringPayerType.fromValue(meteredAccount);
    }

    /**
     * <p>
     * The Amazon Web Services account ID to which the metered traffic is attributed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #meteredAccount}
     * will return {@link TransitGatewayMeteringPayerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #meteredAccountAsString}.
     * </p>
     * 
     * @return The Amazon Web Services account ID to which the metered traffic is attributed.
     * @see TransitGatewayMeteringPayerType
     */
    public final String meteredAccountAsString() {
        return meteredAccount;
    }

    /**
     * <p>
     * The state of the metering policy entry.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayMeteringPolicyEntryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the metering policy entry.
     * @see TransitGatewayMeteringPolicyEntryState
     */
    public final TransitGatewayMeteringPolicyEntryState state() {
        return TransitGatewayMeteringPolicyEntryState.fromValue(state);
    }

    /**
     * <p>
     * The state of the metering policy entry.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayMeteringPolicyEntryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the metering policy entry.
     * @see TransitGatewayMeteringPolicyEntryState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The date and time when the metering policy entry was last updated.
     * </p>
     * 
     * @return The date and time when the metering policy entry was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The date and time when the metering policy entry update becomes effective.
     * </p>
     * 
     * @return The date and time when the metering policy entry update becomes effective.
     */
    public final Instant updateEffectiveAt() {
        return updateEffectiveAt;
    }

    /**
     * <p>
     * The metering policy rule that defines traffic matching criteria.
     * </p>
     * 
     * @return The metering policy rule that defines traffic matching criteria.
     */
    public final TransitGatewayMeteringPolicyRule meteringPolicyRule() {
        return meteringPolicyRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyRuleNumber());
        hashCode = 31 * hashCode + Objects.hashCode(meteredAccountAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updateEffectiveAt());
        hashCode = 31 * hashCode + Objects.hashCode(meteringPolicyRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayMeteringPolicyEntry)) {
            return false;
        }
        TransitGatewayMeteringPolicyEntry other = (TransitGatewayMeteringPolicyEntry) obj;
        return Objects.equals(policyRuleNumber(), other.policyRuleNumber())
                && Objects.equals(meteredAccountAsString(), other.meteredAccountAsString())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(updateEffectiveAt(), other.updateEffectiveAt())
                && Objects.equals(meteringPolicyRule(), other.meteringPolicyRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGatewayMeteringPolicyEntry").add("PolicyRuleNumber", policyRuleNumber())
                .add("MeteredAccount", meteredAccountAsString()).add("State", stateAsString()).add("UpdatedAt", updatedAt())
                .add("UpdateEffectiveAt", updateEffectiveAt()).add("MeteringPolicyRule", meteringPolicyRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyRuleNumber":
            return Optional.ofNullable(clazz.cast(policyRuleNumber()));
        case "MeteredAccount":
            return Optional.ofNullable(clazz.cast(meteredAccountAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "UpdateEffectiveAt":
            return Optional.ofNullable(clazz.cast(updateEffectiveAt()));
        case "MeteringPolicyRule":
            return Optional.ofNullable(clazz.cast(meteringPolicyRule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PolicyRuleNumber", POLICY_RULE_NUMBER_FIELD);
        map.put("MeteredAccount", METERED_ACCOUNT_FIELD);
        map.put("State", STATE_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("UpdateEffectiveAt", UPDATE_EFFECTIVE_AT_FIELD);
        map.put("MeteringPolicyRule", METERING_POLICY_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayMeteringPolicyEntry, T> g) {
        return obj -> g.apply((TransitGatewayMeteringPolicyEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayMeteringPolicyEntry> {
        /**
         * <p>
         * The rule number of the metering policy entry.
         * </p>
         * 
         * @param policyRuleNumber
         *        The rule number of the metering policy entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyRuleNumber(String policyRuleNumber);

        /**
         * <p>
         * The Amazon Web Services account ID to which the metered traffic is attributed.
         * </p>
         * 
         * @param meteredAccount
         *        The Amazon Web Services account ID to which the metered traffic is attributed.
         * @see TransitGatewayMeteringPayerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayMeteringPayerType
         */
        Builder meteredAccount(String meteredAccount);

        /**
         * <p>
         * The Amazon Web Services account ID to which the metered traffic is attributed.
         * </p>
         * 
         * @param meteredAccount
         *        The Amazon Web Services account ID to which the metered traffic is attributed.
         * @see TransitGatewayMeteringPayerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayMeteringPayerType
         */
        Builder meteredAccount(TransitGatewayMeteringPayerType meteredAccount);

        /**
         * <p>
         * The state of the metering policy entry.
         * </p>
         * 
         * @param state
         *        The state of the metering policy entry.
         * @see TransitGatewayMeteringPolicyEntryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayMeteringPolicyEntryState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the metering policy entry.
         * </p>
         * 
         * @param state
         *        The state of the metering policy entry.
         * @see TransitGatewayMeteringPolicyEntryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayMeteringPolicyEntryState
         */
        Builder state(TransitGatewayMeteringPolicyEntryState state);

        /**
         * <p>
         * The date and time when the metering policy entry was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time when the metering policy entry was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The date and time when the metering policy entry update becomes effective.
         * </p>
         * 
         * @param updateEffectiveAt
         *        The date and time when the metering policy entry update becomes effective.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateEffectiveAt(Instant updateEffectiveAt);

        /**
         * <p>
         * The metering policy rule that defines traffic matching criteria.
         * </p>
         * 
         * @param meteringPolicyRule
         *        The metering policy rule that defines traffic matching criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meteringPolicyRule(TransitGatewayMeteringPolicyRule meteringPolicyRule);

        /**
         * <p>
         * The metering policy rule that defines traffic matching criteria.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransitGatewayMeteringPolicyRule.Builder}
         * avoiding the need to create one manually via {@link TransitGatewayMeteringPolicyRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransitGatewayMeteringPolicyRule.Builder#build()} is called
         * immediately and its result is passed to {@link #meteringPolicyRule(TransitGatewayMeteringPolicyRule)}.
         * 
         * @param meteringPolicyRule
         *        a consumer that will call methods on {@link TransitGatewayMeteringPolicyRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #meteringPolicyRule(TransitGatewayMeteringPolicyRule)
         */
        default Builder meteringPolicyRule(Consumer<TransitGatewayMeteringPolicyRule.Builder> meteringPolicyRule) {
            return meteringPolicyRule(TransitGatewayMeteringPolicyRule.builder().applyMutation(meteringPolicyRule).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String policyRuleNumber;

        private String meteredAccount;

        private String state;

        private Instant updatedAt;

        private Instant updateEffectiveAt;

        private TransitGatewayMeteringPolicyRule meteringPolicyRule;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayMeteringPolicyEntry model) {
            policyRuleNumber(model.policyRuleNumber);
            meteredAccount(model.meteredAccount);
            state(model.state);
            updatedAt(model.updatedAt);
            updateEffectiveAt(model.updateEffectiveAt);
            meteringPolicyRule(model.meteringPolicyRule);
        }

        public final String getPolicyRuleNumber() {
            return policyRuleNumber;
        }

        public final void setPolicyRuleNumber(String policyRuleNumber) {
            this.policyRuleNumber = policyRuleNumber;
        }

        @Override
        public final Builder policyRuleNumber(String policyRuleNumber) {
            this.policyRuleNumber = policyRuleNumber;
            return this;
        }

        public final String getMeteredAccount() {
            return meteredAccount;
        }

        public final void setMeteredAccount(String meteredAccount) {
            this.meteredAccount = meteredAccount;
        }

        @Override
        public final Builder meteredAccount(String meteredAccount) {
            this.meteredAccount = meteredAccount;
            return this;
        }

        @Override
        public final Builder meteredAccount(TransitGatewayMeteringPayerType meteredAccount) {
            this.meteredAccount(meteredAccount == null ? null : meteredAccount.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayMeteringPolicyEntryState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Instant getUpdateEffectiveAt() {
            return updateEffectiveAt;
        }

        public final void setUpdateEffectiveAt(Instant updateEffectiveAt) {
            this.updateEffectiveAt = updateEffectiveAt;
        }

        @Override
        public final Builder updateEffectiveAt(Instant updateEffectiveAt) {
            this.updateEffectiveAt = updateEffectiveAt;
            return this;
        }

        public final TransitGatewayMeteringPolicyRule.Builder getMeteringPolicyRule() {
            return meteringPolicyRule != null ? meteringPolicyRule.toBuilder() : null;
        }

        public final void setMeteringPolicyRule(TransitGatewayMeteringPolicyRule.BuilderImpl meteringPolicyRule) {
            this.meteringPolicyRule = meteringPolicyRule != null ? meteringPolicyRule.build() : null;
        }

        @Override
        public final Builder meteringPolicyRule(TransitGatewayMeteringPolicyRule meteringPolicyRule) {
            this.meteringPolicyRule = meteringPolicyRule;
            return this;
        }

        @Override
        public TransitGatewayMeteringPolicyEntry build() {
            return new TransitGatewayMeteringPolicyEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
