/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyIpamPolicyAllocationRulesRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyIpamPolicyAllocationRulesRequest.Builder, ModifyIpamPolicyAllocationRulesRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyIpamPolicyAllocationRulesRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> IPAM_POLICY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamPolicyId")
            .getter(getter(ModifyIpamPolicyAllocationRulesRequest::ipamPolicyId))
            .setter(setter(Builder::ipamPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPolicyId")
                    .unmarshallLocationName("IpamPolicyId").build()).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Locale")
            .getter(getter(ModifyIpamPolicyAllocationRulesRequest::locale))
            .setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale")
                    .unmarshallLocationName("Locale").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceType")
            .getter(getter(ModifyIpamPolicyAllocationRulesRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType")
                    .unmarshallLocationName("ResourceType").build()).build();

    private static final SdkField<List<IpamPolicyAllocationRuleRequest>> ALLOCATION_RULES_FIELD = SdkField
            .<List<IpamPolicyAllocationRuleRequest>> builder(MarshallingType.LIST)
            .memberName("AllocationRules")
            .getter(getter(ModifyIpamPolicyAllocationRulesRequest::allocationRules))
            .setter(setter(Builder::allocationRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationRule")
                    .unmarshallLocationName("AllocationRule").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IpamPolicyAllocationRuleRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpamPolicyAllocationRuleRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            IPAM_POLICY_ID_FIELD, LOCALE_FIELD, RESOURCE_TYPE_FIELD, ALLOCATION_RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dryRun;

    private final String ipamPolicyId;

    private final String locale;

    private final String resourceType;

    private final List<IpamPolicyAllocationRuleRequest> allocationRules;

    private ModifyIpamPolicyAllocationRulesRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamPolicyId = builder.ipamPolicyId;
        this.locale = builder.locale;
        this.resourceType = builder.resourceType;
        this.allocationRules = builder.allocationRules;
    }

    /**
     * <p>
     * A check for whether you have the required permissions for the action without actually making the request and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return A check for whether you have the required permissions for the action without actually making the request
     *         and provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the IPAM policy whose allocation rules you want to modify.
     * </p>
     * 
     * @return The ID of the IPAM policy whose allocation rules you want to modify.
     */
    public final String ipamPolicyId() {
        return ipamPolicyId;
    }

    /**
     * <p>
     * The locale for which to modify the allocation rules.
     * </p>
     * 
     * @return The locale for which to modify the allocation rules.
     */
    public final String locale() {
        return locale;
    }

    /**
     * <p>
     * The resource type for which to modify the allocation rules.
     * </p>
     * <p>
     * The Amazon Web Services service or resource type that can use IP addresses through IPAM policies. Supported
     * services and resource types include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Elastic IP addresses
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link IpamPolicyResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type for which to modify the allocation rules.</p>
     *         <p>
     *         The Amazon Web Services service or resource type that can use IP addresses through IPAM policies.
     *         Supported services and resource types include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Elastic IP addresses
     *         </p>
     *         </li>
     * @see IpamPolicyResourceType
     */
    public final IpamPolicyResourceType resourceType() {
        return IpamPolicyResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The resource type for which to modify the allocation rules.
     * </p>
     * <p>
     * The Amazon Web Services service or resource type that can use IP addresses through IPAM policies. Supported
     * services and resource types include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Elastic IP addresses
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link IpamPolicyResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type for which to modify the allocation rules.</p>
     *         <p>
     *         The Amazon Web Services service or resource type that can use IP addresses through IPAM policies.
     *         Supported services and resource types include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Elastic IP addresses
     *         </p>
     *         </li>
     * @see IpamPolicyResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllocationRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllocationRules() {
        return allocationRules != null && !(allocationRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The new allocation rules to apply to the IPAM policy.
     * </p>
     * <p>
     * Allocation rules are optional configurations within an IPAM policy that map Amazon Web Services resource types to
     * specific IPAM pools. If no rules are defined, the resource types default to using Amazon-provided IP addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllocationRules} method.
     * </p>
     * 
     * @return The new allocation rules to apply to the IPAM policy.</p>
     *         <p>
     *         Allocation rules are optional configurations within an IPAM policy that map Amazon Web Services resource
     *         types to specific IPAM pools. If no rules are defined, the resource types default to using
     *         Amazon-provided IP addresses.
     */
    public final List<IpamPolicyAllocationRuleRequest> allocationRules() {
        return allocationRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(ipamPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(locale());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllocationRules() ? allocationRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIpamPolicyAllocationRulesRequest)) {
            return false;
        }
        ModifyIpamPolicyAllocationRulesRequest other = (ModifyIpamPolicyAllocationRulesRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(ipamPolicyId(), other.ipamPolicyId())
                && Objects.equals(locale(), other.locale())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && hasAllocationRules() == other.hasAllocationRules()
                && Objects.equals(allocationRules(), other.allocationRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyIpamPolicyAllocationRulesRequest").add("DryRun", dryRun())
                .add("IpamPolicyId", ipamPolicyId()).add("Locale", locale()).add("ResourceType", resourceTypeAsString())
                .add("AllocationRules", hasAllocationRules() ? allocationRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "IpamPolicyId":
            return Optional.ofNullable(clazz.cast(ipamPolicyId()));
        case "Locale":
            return Optional.ofNullable(clazz.cast(locale()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "AllocationRules":
            return Optional.ofNullable(clazz.cast(allocationRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("IpamPolicyId", IPAM_POLICY_ID_FIELD);
        map.put("Locale", LOCALE_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("AllocationRule", ALLOCATION_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyIpamPolicyAllocationRulesRequest, T> g) {
        return obj -> g.apply((ModifyIpamPolicyAllocationRulesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyIpamPolicyAllocationRulesRequest> {
        /**
         * <p>
         * A check for whether you have the required permissions for the action without actually making the request and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        A check for whether you have the required permissions for the action without actually making the
         *        request and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the IPAM policy whose allocation rules you want to modify.
         * </p>
         * 
         * @param ipamPolicyId
         *        The ID of the IPAM policy whose allocation rules you want to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPolicyId(String ipamPolicyId);

        /**
         * <p>
         * The locale for which to modify the allocation rules.
         * </p>
         * 
         * @param locale
         *        The locale for which to modify the allocation rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locale(String locale);

        /**
         * <p>
         * The resource type for which to modify the allocation rules.
         * </p>
         * <p>
         * The Amazon Web Services service or resource type that can use IP addresses through IPAM policies. Supported
         * services and resource types include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Elastic IP addresses
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        The resource type for which to modify the allocation rules.</p>
         *        <p>
         *        The Amazon Web Services service or resource type that can use IP addresses through IPAM policies.
         *        Supported services and resource types include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Elastic IP addresses
         *        </p>
         *        </li>
         * @see IpamPolicyResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamPolicyResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type for which to modify the allocation rules.
         * </p>
         * <p>
         * The Amazon Web Services service or resource type that can use IP addresses through IPAM policies. Supported
         * services and resource types include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Elastic IP addresses
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        The resource type for which to modify the allocation rules.</p>
         *        <p>
         *        The Amazon Web Services service or resource type that can use IP addresses through IPAM policies.
         *        Supported services and resource types include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Elastic IP addresses
         *        </p>
         *        </li>
         * @see IpamPolicyResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamPolicyResourceType
         */
        Builder resourceType(IpamPolicyResourceType resourceType);

        /**
         * <p>
         * The new allocation rules to apply to the IPAM policy.
         * </p>
         * <p>
         * Allocation rules are optional configurations within an IPAM policy that map Amazon Web Services resource
         * types to specific IPAM pools. If no rules are defined, the resource types default to using Amazon-provided IP
         * addresses.
         * </p>
         * 
         * @param allocationRules
         *        The new allocation rules to apply to the IPAM policy.</p>
         *        <p>
         *        Allocation rules are optional configurations within an IPAM policy that map Amazon Web Services
         *        resource types to specific IPAM pools. If no rules are defined, the resource types default to using
         *        Amazon-provided IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationRules(Collection<IpamPolicyAllocationRuleRequest> allocationRules);

        /**
         * <p>
         * The new allocation rules to apply to the IPAM policy.
         * </p>
         * <p>
         * Allocation rules are optional configurations within an IPAM policy that map Amazon Web Services resource
         * types to specific IPAM pools. If no rules are defined, the resource types default to using Amazon-provided IP
         * addresses.
         * </p>
         * 
         * @param allocationRules
         *        The new allocation rules to apply to the IPAM policy.</p>
         *        <p>
         *        Allocation rules are optional configurations within an IPAM policy that map Amazon Web Services
         *        resource types to specific IPAM pools. If no rules are defined, the resource types default to using
         *        Amazon-provided IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationRules(IpamPolicyAllocationRuleRequest... allocationRules);

        /**
         * <p>
         * The new allocation rules to apply to the IPAM policy.
         * </p>
         * <p>
         * Allocation rules are optional configurations within an IPAM policy that map Amazon Web Services resource
         * types to specific IPAM pools. If no rules are defined, the resource types default to using Amazon-provided IP
         * addresses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.IpamPolicyAllocationRuleRequest.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.IpamPolicyAllocationRuleRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.IpamPolicyAllocationRuleRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #allocationRules(List<IpamPolicyAllocationRuleRequest>)}.
         * 
         * @param allocationRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.IpamPolicyAllocationRuleRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allocationRules(java.util.Collection<IpamPolicyAllocationRuleRequest>)
         */
        Builder allocationRules(Consumer<IpamPolicyAllocationRuleRequest.Builder>... allocationRules);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String ipamPolicyId;

        private String locale;

        private String resourceType;

        private List<IpamPolicyAllocationRuleRequest> allocationRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIpamPolicyAllocationRulesRequest model) {
            super(model);
            dryRun(model.dryRun);
            ipamPolicyId(model.ipamPolicyId);
            locale(model.locale);
            resourceType(model.resourceType);
            allocationRules(model.allocationRules);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamPolicyId() {
            return ipamPolicyId;
        }

        public final void setIpamPolicyId(String ipamPolicyId) {
            this.ipamPolicyId = ipamPolicyId;
        }

        @Override
        public final Builder ipamPolicyId(String ipamPolicyId) {
            this.ipamPolicyId = ipamPolicyId;
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(IpamPolicyResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<IpamPolicyAllocationRuleRequest.Builder> getAllocationRules() {
            List<IpamPolicyAllocationRuleRequest.Builder> result = IpamPolicyAllocationRuleListRequestCopier
                    .copyToBuilder(this.allocationRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllocationRules(Collection<IpamPolicyAllocationRuleRequest.BuilderImpl> allocationRules) {
            this.allocationRules = IpamPolicyAllocationRuleListRequestCopier.copyFromBuilder(allocationRules);
        }

        @Override
        public final Builder allocationRules(Collection<IpamPolicyAllocationRuleRequest> allocationRules) {
            this.allocationRules = IpamPolicyAllocationRuleListRequestCopier.copy(allocationRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allocationRules(IpamPolicyAllocationRuleRequest... allocationRules) {
            allocationRules(Arrays.asList(allocationRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allocationRules(Consumer<IpamPolicyAllocationRuleRequest.Builder>... allocationRules) {
            allocationRules(Stream.of(allocationRules)
                    .map(c -> IpamPolicyAllocationRuleRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyIpamPolicyAllocationRulesRequest build() {
            return new ModifyIpamPolicyAllocationRulesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
